/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.gvsig.gui.beans.CancellableComponent;
import org.gvsig.gui.beans.Messages;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 2325230864829072756L;
    private JProgressBar jProgressBar = null;
    private JButton btnCancel = null;
    private JLabel lblStatus = null;
    private JLabel lblTask = null;
    private String jobName;
    private CancellableComponent cc;
    private String textMessage;

    public ProgressDialog(CancellableComponent owner, String jobName, int stepAmount) {
        this(owner, jobName, jobName, stepAmount);
    }

    public ProgressDialog(CancellableComponent owner, String jobName, String textMessage, int stepAmount) {
        this.setTitle(jobName);
        this.textMessage = textMessage;
        this.getJProgressBar().setMinimum(0);
        this.getJProgressBar().setMaximum(stepAmount);
        this.cc = owner;
        this.initialize();
    }

    private void initialize() {
        this.lblTask = new JLabel();
        this.lblTask.setBounds(10, 12, 280, 20);
        this.lblTask.setFont(new Font("MS Sans Serif", 1, 11));
        this.lblTask.setText(this.textMessage);
        this.lblStatus = new JLabel();
        this.lblStatus.setBounds(10, 63, 280, 20);
        this.getContentPane().setLayout(null);
        this.setSize(308, 168);
        this.getContentPane().add((Component)this.getJProgressBar(), null);
        this.getContentPane().add((Component)this.getBtnCancel(), null);
        this.getContentPane().add((Component)this.lblStatus, null);
        this.getContentPane().add((Component)this.lblTask, null);
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            this.jProgressBar.setBounds(10, 38, 280, 20);
        }
        return this.jProgressBar;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(210, 96, 80, 20);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProgressDialog.this.cc != null) {
                        ProgressDialog.this.cc.cancel();
                    }
                }
            });
            this.btnCancel.setText(Messages.getText("cancel"));
        }
        return this.btnCancel;
    }

    public void setProgress(int step) {
        this.jProgressBar.setValue(step);
    }

    public void setStatusMessage(String message) {
        this.lblStatus.setText(message);
    }
}

