/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.comboboxconfigurablelookup.agents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.gvsig.gui.beans.comboboxconfigurablelookup.ILookUp;
import org.gvsig.gui.beans.comboboxconfigurablelookup.StringComparator;

public class StartsWithLookUpAgent
implements ILookUp {
    @Override
    public synchronized List<Object> doLookUpConsideringCaseSensitive(String text, Vector<Object> sortOrderedItems, StringComparator comp) {
        if (text == null) {
            return null;
        }
        List<Object> results_list = this.doLookUpIgnoringCaseSensitive(text, sortOrderedItems, comp);
        if (results_list == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < results_list.size(); ++i) {
            if (!results_list.get(i).toString().startsWith(text)) continue;
            results.add(results_list.get(i));
        }
        return results;
    }

    @Override
    public synchronized List<Object> doLookUpIgnoringCaseSensitive(String text, Vector<Object> sortOrderedItems, StringComparator comp) {
        if (text == null) {
            return null;
        }
        int size = sortOrderedItems.size();
        int maxNumberOfIterations = (int)(Math.log(size) / Math.log(2.0));
        int lowIndex = 0;
        int highIndex = sortOrderedItems.size() - 1;
        for (int currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
            int mIndx = (lowIndex + highIndex) / 2;
            if (sortOrderedItems.get(mIndx).toString().toLowerCase().startsWith(text.toLowerCase())) {
                highIndex = mIndx;
                lowIndex = highIndex++;
                while (highIndex < size && sortOrderedItems.get(highIndex).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    ++highIndex;
                }
                while (lowIndex - 1 > -1 && sortOrderedItems.get(lowIndex - 1).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    --lowIndex;
                }
                return Arrays.asList(sortOrderedItems.subList(lowIndex, highIndex).toArray());
            }
            if (comp.compare(sortOrderedItems.get(mIndx).toString().toLowerCase(), text.toLowerCase()) > 0) {
                highIndex = mIndx - 1;
                continue;
            }
            lowIndex = mIndx + 1;
        }
        return null;
    }
}

