/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.controls.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JList;
import org.gvsig.gui.beans.controls.dnd.JDnDListModel;

public class JDnDList
extends JList
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private static final long serialVersionUID = -9071985815215584362L;
    private DragSource dragSource;
    private boolean dragging;
    private int overIndex;
    private int[] selectedIndices;

    public JDnDList() {
        new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public JDnDList(JDnDListModel model) {
        super(model);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        this.selectedIndices = this.getSelectedIndices();
        Object[] selectedObjects = this.getSelectedValues();
        if (selectedObjects.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < selectedObjects.length; ++i) {
                sb.append(selectedObjects[i].toString() + "\n");
            }
            StringSelection text = new StringSelection(sb.toString());
            this.dragging = true;
            this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, text, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dragging = false;
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.overIndex = -1;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.overIndex = this.locationToIndex(dtde.getLocation());
        this.setSelectedIndex(this.overIndex);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        int overIndex = this.locationToIndex(dtde.getLocation());
        if (overIndex != -1 && overIndex != this.overIndex) {
            this.overIndex = overIndex;
            this.setSelectedIndex(this.overIndex);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(2);
                int newIndex = this.locationToIndex(dtde.getLocation());
                String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                StringTokenizer st = new StringTokenizer(s);
                ArrayList<String> items = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    items.add(st.nextToken());
                }
                JDnDListModel model = (JDnDListModel)this.getModel();
                if (this.dragging) {
                    model.itemsMoved(newIndex, this.selectedIndices);
                } else {
                    model.insertItems(newIndex, items);
                }
                int[] newIndicies = new int[items.size()];
                for (int i = 0; i < items.size(); ++i) {
                    newIndicies[i] = newIndex + i;
                }
                this.setSelectedIndices(newIndicies);
                this.overIndex = -1;
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.rejectDrop();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            System.err.println("Exception" + exception.getMessage());
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            ufException.printStackTrace();
            System.err.println("Exception" + ufException.getMessage());
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void setListData(Object[] obj) {
        JDnDListModel model = new JDnDListModel();
        for (int i = 0; i < obj.length; ++i) {
            model.addElement(obj[i]);
        }
        this.setModel(model);
    }
}

