/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.datainput;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.datainput.DataInputField;

public class DataInputContainer
extends JPanel {
    private static final long serialVersionUID = 7084105134015956663L;
    private JLabel jLabel = null;
    private DataInputField dataInputField = null;
    private int maximumFractionDigits = 3;

    public DataInputContainer(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
        this.initialize();
    }

    public DataInputContainer() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getLText(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.getDataInputField(), gridBagConstraints);
    }

    private JLabel getLText() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("JLabel");
            this.jLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        return this.jLabel;
    }

    public void setLabelText(String text) {
        this.getLText().setText(text + ":");
    }

    public DataInputField getDataInputField() {
        if (this.dataInputField == null) {
            this.dataInputField = new DataInputField(this.maximumFractionDigits);
        }
        return this.dataInputField;
    }

    public String getValue() {
        return this.getDataInputField().getValue();
    }

    public void setControlEnabled(boolean en) {
        this.getLText().setEnabled(en);
        this.getDataInputField().setControlEnabled(en);
    }

    public void setValue(String value) {
        this.getDataInputField().setValue(value);
    }

    public void addValueChangedListener(DataInputContainerListener listener) {
        this.getDataInputField().addValueChangedListener(listener);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.getDataInputField().addKeyListener(listener);
    }

    public void removeValueChangedListener(DataInputContainerListener listener) {
        this.getDataInputField().removeValueChangedListener(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.getDataInputField().removeKeyListener(listener);
    }
}

