/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.imagenavigator;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.imagenavigator.IClientImageNavigator;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;

public class ImageNavigator
extends JComponent
implements KeyListener,
MouseMotionListener,
MouseListener,
MouseWheelListener {
    private static final long serialVersionUID = 1164788214432359272L;
    private IClientImageNavigator iClient = null;
    private Image image = null;
    private Graphics2D widgetGraphics = null;
    private Image imageCache = null;
    private Graphics2D cacheGraphics = null;
    private double zoom = 1.0;
    private double x1 = 0.0;
    private double y1 = 0.0;
    private boolean yInverted = false;
    private boolean xInverted = false;
    private int width = 0;
    private int height = 0;
    private boolean showHelp = false;
    private boolean showBackground = false;
    private Color backgroundColor = new Color(224, 224, 224);
    private ImageIcon imageIconClose = null;
    private ImageIcon imageIconHelp = null;
    private ImageIcon imageIconError = null;
    private double initX1 = 0.0;
    private double initY1 = 0.0;
    private double initX2 = 100.0;
    private double initY2 = 100.0;
    private double initZoom = 1.0;
    private boolean autoAdjusted = true;
    private boolean errorDrawing = false;
    private String errorDrawingMsg = null;
    double updateWidth = 0.0;
    double updateHeight = 0.0;
    Point mouse = null;

    public ImageNavigator() {
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    public ImageNavigator(IClientImageNavigator iClient) {
        this();
        this.setClientImageNavigator(iClient);
    }

    public void setClientImageNavigator(IClientImageNavigator iClient) {
        this.iClient = iClient;
    }

    private void updateDimensions() {
        double factor = (double)this.getWidth() / (this.initX2 - this.initX1);
        if (factor > (double)this.getHeight() / (this.initY2 - this.initY1)) {
            factor = (double)this.getHeight() / (this.initY2 - this.initY1);
        }
        this.zoom = factor;
        this.imageCenter();
    }

    public void imageCenter() {
        this.x1 = this.initX1;
        this.y1 = this.initY1;
        this.x1 = this.isXInverted() ? (this.x1 -= (this.initX2 - this.initX1 - (double)this.getWidth() / this.zoom) / 2.0) : (this.x1 += (this.initX2 - this.initX1 - (double)this.getWidth() / this.zoom) / 2.0);
        this.y1 = this.isYInverted() ? (this.y1 -= (this.initY2 - this.initY1 - (double)this.getHeight() / this.zoom) / 2.0) : (this.y1 += (this.initY2 - this.initY1 - (double)this.getHeight() / this.zoom) / 2.0);
    }

    public void setViewDimensions(double x1, double y1, double x2, double y2) {
        this.initX1 = x1;
        this.initX2 = x2;
        this.initY1 = y1;
        this.initY2 = y2;
        boolean bl = this.yInverted = y2 < y1;
        if (this.yInverted) {
            this.initY1 = y2;
            this.initY2 = y1;
        }
        boolean bl2 = this.xInverted = x2 < x1;
        if (this.xInverted) {
            this.initX1 = x2;
            this.initX2 = x1;
        }
        this.updateDimensions();
    }

    public void updateBuffer() {
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }

    public void setZoom(double zoom) {
        this.zoom = this.initZoom = zoom;
        this.autoAdjusted = false;
        this.imageCenter();
    }

    public void setAutoAdjusted() {
        this.autoAdjusted = true;
        this.updateDimensions();
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }

    private void ZoomIn(double x, double y) {
        double xcent = x / this.zoom;
        double ycent = y / this.zoom;
        this.x1 = this.isXInverted() ? (this.x1 -= xcent) : (this.x1 += xcent);
        this.y1 = this.isYInverted() ? (this.y1 -= ycent) : (this.y1 += ycent);
        this.zoom *= 2.0;
        xcent = x / this.zoom;
        ycent = y / this.zoom;
        this.x1 = this.isXInverted() ? (this.x1 += xcent) : (this.x1 -= xcent);
        this.y1 = this.isYInverted() ? (this.y1 += ycent) : (this.y1 -= ycent);
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }

    private void ZoomOut(double x, double y) {
        double xcent = x / this.zoom;
        double ycent = y / this.zoom;
        this.x1 = this.isXInverted() ? (this.x1 -= xcent) : (this.x1 += xcent);
        this.y1 = this.isYInverted() ? (this.y1 -= ycent) : (this.y1 += ycent);
        this.zoom /= 2.0;
        xcent = x / this.zoom;
        ycent = y / this.zoom;
        this.x1 = this.isXInverted() ? (this.x1 += xcent) : (this.x1 -= xcent);
        this.y1 = this.isYInverted() ? (this.y1 += ycent) : (this.y1 -= ycent);
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }

    private void callShowHelp() {
        this.showHelp = !this.showHelp;
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyChar()) {
            case 'H': 
            case 'h': {
                this.callShowHelp();
                break;
            }
            case '+': {
                this.ZoomIn((double)this.width / 2.0, (double)this.height / 2.0);
                this.autoAdjusted = false;
                break;
            }
            case '-': {
                this.ZoomOut((double)this.width / 2.0, (double)this.height / 2.0);
                this.autoAdjusted = false;
                break;
            }
            case '1': {
                this.autoAdjusted = false;
                this.zoom = this.initZoom;
                this.imageCenter();
                this.updateImageCache(true);
                this.refreshImage(0, 0);
                break;
            }
            case '2': {
                this.autoAdjusted = false;
                this.zoom = this.initZoom * 2.0;
                this.imageCenter();
                this.updateImageCache(true);
                this.refreshImage(0, 0);
                break;
            }
            case '3': {
                this.autoAdjusted = false;
                this.zoom = this.initZoom * 4.0;
                this.imageCenter();
                this.updateImageCache(true);
                this.refreshImage(0, 0);
                break;
            }
            case '4': {
                this.autoAdjusted = false;
                this.zoom = this.initZoom * 8.0;
                this.imageCenter();
                this.updateImageCache(true);
                this.refreshImage(0, 0);
                break;
            }
            case '5': {
                this.autoAdjusted = false;
                this.zoom = this.initZoom * 16.0;
                this.imageCenter();
                this.updateImageCache(true);
                this.refreshImage(0, 0);
                break;
            }
            case 'C': 
            case 'c': {
                this.imageCenter();
                this.updateImageCache(true);
                this.refreshImage(0, 0);
                break;
            }
            case 'B': 
            case 'b': {
                this.setShowBackground(!this.isShowBackground());
                break;
            }
            case ' ': 
            case '0': {
                this.setAutoAdjusted();
            }
        }
    }

    private void updateImageCache(boolean forceUpdate) {
        if (this.getWidgetImage() == null || this.updateWidth == (double)this.getWidgetImage().getWidth(this) && this.updateHeight == (double)this.getWidgetImage().getHeight(this) && !forceUpdate) {
            return;
        }
        this.updateWidth = this.getWidgetImage().getWidth(this);
        this.updateHeight = this.getWidgetImage().getHeight(this);
        if (this.showBackground) {
            int i = 0;
            while (i * 4 <= this.width) {
                int j = 0;
                while (j * 4 <= this.height) {
                    if ((i + j) % 2 == 0) {
                        this.getCacheGraphics().setColor(Color.white);
                    } else {
                        this.getCacheGraphics().setColor(this.getBackgroundColor());
                    }
                    this.getCacheGraphics().fillRect(i * 4, j * 4, 4, 4);
                    ++j;
                }
                ++i;
            }
        } else {
            this.getCacheGraphics().setColor(Color.white);
            this.getCacheGraphics().fillRect(0, 0, this.width, this.height);
        }
        double newY1 = 0.0;
        double newY2 = 0.0;
        double newX1 = 0.0;
        double newX2 = 0.0;
        if (this.isYInverted()) {
            newY1 = this.y1 + (double)this.getHeight() / this.zoom - (this.y1 - this.initY1) * 2.0;
            newY2 = newY1 - (double)this.getHeight() / this.zoom;
        } else {
            newY1 = this.y1;
            newY2 = this.y1 + (double)this.getHeight() / this.zoom;
        }
        if (this.isXInverted()) {
            newX1 = this.x1 + (double)this.getWidth() / this.zoom - (this.x1 - this.initX1) * 2.0;
            newX2 = newX1 - (double)this.getWidth() / this.zoom;
        } else {
            newX1 = this.x1;
            newX2 = this.x1 + (double)this.getWidth() / this.zoom;
        }
        if (Double.isNaN(newX1) || Double.isNaN(newY1)) {
            return;
        }
        if (this.iClient != null) {
            try {
                this.errorDrawing = false;
                this.iClient.drawImage(this.getCacheGraphics(), newX1, newY1, newX2, newY2, this.zoom, this.getWidth(), this.getHeight());
            }
            catch (ImageUnavailableException e) {
                this.getCacheGraphics().setColor(new Color(224, 224, 224));
                this.getCacheGraphics().fillRect(0, 0, this.width, this.height);
                this.errorDrawing = true;
                this.errorDrawingMsg = e.getMessage();
            }
        }
    }

    private Image getWidgetImage() {
        int width2 = this.getBounds().width;
        int height2 = this.getBounds().height;
        if (width2 <= 0) {
            width2 = 1;
        }
        if (height2 <= 0) {
            height2 = 1;
        }
        if (this.width != width2 || this.height != height2) {
            this.image = this.createImage(width2, height2);
            this.imageCache = this.createImage(width2, height2);
            if (this.image == null) {
                return null;
            }
            this.widgetGraphics = (Graphics2D)this.image.getGraphics();
            this.cacheGraphics = (Graphics2D)this.imageCache.getGraphics();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            this.cacheGraphics.setRenderingHints(hints);
        }
        this.width = width2;
        this.height = height2;
        return this.image;
    }

    private Graphics2D getWidgetGraphics() {
        this.getWidgetImage();
        return this.widgetGraphics;
    }

    private Graphics2D getCacheGraphics() {
        this.getWidgetImage();
        return this.cacheGraphics;
    }

    private void redrawBuffer(int x, int y) {
        if (this.showBackground) {
            int i = -2;
            while ((i - 2) * 4 <= this.width) {
                int j = -2;
                while ((j - 2) * 4 <= this.height) {
                    if ((i + j) % 2 == 0) {
                        this.getWidgetGraphics().setColor(Color.white);
                    } else {
                        this.getWidgetGraphics().setColor(this.getBackgroundColor());
                    }
                    this.getWidgetGraphics().fillRect(i * 4 + x % 8, j * 4 + y % 8, 4, 4);
                    ++j;
                }
                ++i;
            }
        } else {
            this.getWidgetGraphics().setColor(Color.white);
            this.getWidgetGraphics().fillRect(0, 0, this.width, this.height);
        }
        this.getWidgetGraphics().drawImage(this.imageCache, x, y, null);
        if (this.errorDrawing) {
            this.paintError(this.getWidgetGraphics());
        } else if (this.showHelp) {
            this.paintHelp(this.getWidgetGraphics());
        } else {
            this.getWidgetGraphics().drawImage(this.getIconHelp().getImage(), this.width - this.getIconHelp().getIconWidth() - 4, 3, null);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.autoAdjusted) {
            this.updateDimensions();
        }
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.setRenderingHints(hints);
        this.updateImageCache(false);
        this.redrawBuffer(0, 0);
        if (this.image != null) {
            if (this.isEnabled()) {
                g.drawImage(this.image, 0, 0, this);
            } else {
                BufferedImage bi = new BufferedImage(this.width, this.height, 1);
                Graphics2D big = bi.createGraphics();
                big.drawImage(this.image, 0, 0, this);
                ColorConvertOp colorConvert = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                colorConvert.filter(bi, bi);
                big.setColor(new Color(255, 255, 255, 164));
                big.fillRect(0, 0, this.width, this.height);
                g.drawImage(bi, this.getVisibleRect().x, this.getVisibleRect().y, this);
            }
        }
    }

    private void refreshImage(int x, int y) {
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        if (g2d == null) {
            return;
        }
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.setRenderingHints(hints);
        this.redrawBuffer(x, y);
        if (this.image != null) {
            this.getGraphics().drawImage(this.image, 0, 0, this);
        }
    }

    private ImageIcon getIconClose() {
        if (this.imageIconClose == null) {
            this.imageIconClose = new ImageIcon(ImageNavigator.class.getResource("images/close.png"));
        }
        return this.imageIconClose;
    }

    private ImageIcon getIconError() {
        if (this.imageIconError == null) {
            this.imageIconError = new ImageIcon(ImageNavigator.class.getResource("images/error.png"));
        }
        return this.imageIconError;
    }

    private ImageIcon getIconHelp() {
        if (this.imageIconHelp == null) {
            this.imageIconHelp = new ImageIcon(ImageNavigator.class.getResource("images/help.png"));
        }
        return this.imageIconHelp;
    }

    private void paintHelp(Graphics2D g) {
        int sep = 13;
        int pos = sep + 1;
        int alto = sep * 8 + 6;
        Image image2 = this.createImage(this.width, alto);
        Graphics2D graphics2 = (Graphics2D)image2.getGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2.setRenderingHints(hints);
        Color color1 = new Color(255, 255, 178);
        Color color2 = new Color(255, 255, 74);
        graphics2.setPaint(new GradientPaint(0.0f, 0.0f, color1, 0.0f, --alto, color2, false));
        graphics2.fillRect(0, 0, this.width, alto);
        graphics2.setColor(new Color(0, 0, 0));
        graphics2.setFont(new Font("Tahoma", 1, sep - 2));
        graphics2.drawString(Messages.getText("teclas") + ":", 10, pos);
        graphics2.setFont(new Font("Tahoma", 0, sep - 2));
        graphics2.drawString(Messages.getText("ayuda_c"), 20, pos += sep);
        graphics2.drawString(Messages.getText("ayuda_0"), 20, pos += sep);
        graphics2.drawString(Messages.getText("ayuda_1_5"), 20, pos += sep);
        graphics2.drawString(Messages.getText("ayuda_more_less"), 20, pos += sep);
        graphics2.drawString(Messages.getText("ayuda_wheel"), 20, pos += sep);
        graphics2.drawString(Messages.getText("ayuda_background"), 20, pos += sep);
        graphics2.drawString(Messages.getText("ayuda_h"), 20, pos += sep);
        graphics2.setColor(new Color(185, 185, 185));
        graphics2.drawLine(0, alto, this.width, alto);
        graphics2.drawImage(this.getIconClose().getImage(), this.width - this.getIconClose().getIconWidth() - 4, 3, null);
        AlphaComposite myAlpha = AlphaComposite.getInstance(3, 0.7f);
        g.setComposite(myAlpha);
        g.drawImage(image2, 0, 0, this);
        myAlpha = AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(myAlpha);
    }

    private ArrayList<String> splitString4Width(Graphics2D g, String msg, int width) {
        String[] words = msg.split(" ");
        ArrayList<String> newString = new ArrayList<String>();
        String aux = "";
        for (int i = 0; i < words.length; ++i) {
            if (aux.length() == 0) {
                aux = words[i];
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (g.getFontMetrics().getStringBounds(stringBuilder.append(aux).append(" ").append(words[i]).toString(), g).getWidth() <= (double)width) {
                aux = aux + " " + words[i];
                continue;
            }
            newString.add(aux);
            aux = words[i];
        }
        newString.add(aux);
        return newString;
    }

    private ArrayList<String> splitString4Intro(Graphics2D g, String msg, int width) {
        String[] words = msg.split("\n");
        ArrayList<String> newString = new ArrayList<String>();
        for (int i = 0; i < words.length; ++i) {
            ArrayList<String> more = this.splitString4Width(g, words[i], width);
            for (int j = 0; j < more.size(); ++j) {
                newString.add(more.get(j));
            }
        }
        return newString;
    }

    private void paintError(Graphics2D g) {
        ArrayList<String> errors = this.splitString4Intro(g, this.errorDrawingMsg, this.width - 30);
        int size = errors.size();
        if (size < 6) {
            size = 6;
        }
        int sep = 13;
        int pos = sep + 2;
        int alto = sep * size + 8;
        Image image2 = this.createImage(this.width, alto);
        Graphics2D graphics2 = (Graphics2D)image2.getGraphics();
        Color color1 = new Color(255, 152, 152);
        Color color2 = new Color(255, 100, 100);
        graphics2.setPaint(new GradientPaint(0.0f, 0.0f, color1, 0.0f, --alto, color2, false));
        graphics2.fillRect(0, 0, this.width, alto);
        graphics2.setColor(new Color(0, 0, 0));
        graphics2.setFont(new Font("Tahoma", 0, sep - 2));
        for (int i = 0; i < errors.size(); ++i) {
            graphics2.drawString(errors.get(i), 24, pos);
            pos += sep;
        }
        graphics2.drawImage(this.getIconError().getImage(), 4, 4, null);
        graphics2.setColor(new Color(185, 185, 185));
        graphics2.drawLine(0, alto, this.width, alto);
        g.drawImage(image2, 0, 0, this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isInteractiveEnabled()) {
            return;
        }
        this.requestFocus();
        if (e.getX() > this.width - 20 && e.getY() < 20) {
            return;
        }
        if (e.getButton() != 1 && e.getButton() != 2) {
            return;
        }
        Color gris = new Color(0, 0, 0, 16);
        this.getCacheGraphics().setColor(gris);
        this.getCacheGraphics().fillRect(0, 0, this.width - 1, this.height - 1);
        this.getCacheGraphics().setColor(Color.gray);
        this.getCacheGraphics().drawRect(0, 0, this.width - 1, this.height - 1);
        this.mouse = new Point(e.getX(), e.getY());
        this.changePos(e.getX(), e.getY());
        this.autoAdjusted = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isInteractiveEnabled()) {
            return;
        }
        this.changePos(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isInteractiveEnabled()) {
            return;
        }
        if (this.mouse != null) {
            this.x1 -= ((double)e.getX() - this.mouse.getX()) / this.zoom;
            this.y1 -= ((double)e.getY() - this.mouse.getY()) / this.zoom;
            this.updateImageCache(true);
            this.refreshImage(0, 0);
        }
        this.mouse = null;
    }

    private void changePos(int x, int y) {
        if (this.mouse != null) {
            this.refreshImage((int)((double)x - this.mouse.getX()), (int)((double)y - this.mouse.getY()));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.isInteractiveEnabled()) {
            return;
        }
        if (e.getWheelRotation() > 0) {
            this.ZoomOut(this.isXInverted() ? (double)(this.getWidth() - e.getX()) : (double)e.getX(), this.isYInverted() ? (double)(this.getHeight() - e.getY()) : (double)e.getY());
            this.autoAdjusted = false;
        }
        if (e.getWheelRotation() < 0) {
            this.ZoomIn(this.isXInverted() ? (double)(this.getWidth() - e.getX()) : (double)e.getX(), this.isYInverted() ? (double)(this.getHeight() - e.getY()) : (double)e.getY());
            this.autoAdjusted = false;
        }
    }

    private boolean isYInverted() {
        return this.yInverted;
    }

    private boolean isXInverted() {
        return this.xInverted;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isInteractiveEnabled()) {
            return;
        }
        if (e.getX() > this.width - 20 && e.getY() < 20) {
            this.setCursor(new Cursor(12));
            if (this.showHelp) {
                this.setToolTipText(Messages.getText("cerrar"));
            } else {
                this.setToolTipText(Messages.getText("ayuda"));
            }
        } else {
            this.setCursor(new Cursor(13));
            this.setToolTipText(null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isInteractiveEnabled()) {
            return;
        }
        if (e.getX() > this.width - 20 && e.getY() < 20) {
            this.callShowHelp();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isShowBackground() {
        return this.showBackground;
    }

    public void setShowBackground(boolean showBackground) {
        this.showBackground = showBackground;
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }

    private boolean isInteractiveEnabled() {
        return this.isEnabled() && !this.errorDrawing;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateImageCache(true);
        this.refreshImage(0, 0);
    }
}

