/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gvsig.gui.beans.swing.JBlank;

public class GridBagLayoutPanel
extends JPanel {
    private static final long serialVersionUID = -5583978286938513624L;
    private GridBagLayout gridBag = new GridBagLayout();
    private boolean changed;
    protected int y;
    private MyValueChangeListener lst;

    public GridBagLayoutPanel() {
        this.setLayout(this.gridBag);
        this.lst = new MyValueChangeListener();
    }

    public void addComponent(String label, Component comp) {
        JLabel l = this.newLabel(label, comp);
        l.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.addComponent((Component)l, comp, 1);
    }

    public void addComponent(String label, Component comp, int fill) {
        JLabel l = this.newLabel(label, comp);
        l.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.addComponent((Component)l, comp, fill);
    }

    public void addComponent(String label, Component comp, Insets insets) {
        this.addComponent(label, comp, 1, insets);
    }

    public void addComponent(String label, Component comp, int fill, Insets insets) {
        JLabel l = this.newLabel(label, comp);
        l.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.addComponent((Component)l, comp, fill, insets);
    }

    public void addComponent(Component comp1, Component comp2) {
        this.addComponent(comp1, comp2, 1);
    }

    public void addComponent(Component comp1, Component comp2, int fill) {
        this.addComponent(comp1, comp2, fill, new Insets(1, 0, 1, 0));
    }

    public void addComponent(Component comp1, Component comp2, int fill, Insets insets) {
        this.copyToolTips(comp1, comp2);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.insets = insets;
        cons.fill = 1;
        this.gridBag.setConstraints(comp1, cons);
        this.add(comp1);
        cons.fill = fill;
        cons.gridx = 1;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(comp2, cons);
        this.add(comp2);
        comp1.addKeyListener(this.lst);
        comp1.addMouseListener(this.lst);
        comp2.addKeyListener(this.lst);
        comp2.addMouseListener(this.lst);
    }

    public void addComponent(Component comp1, Component comp2, Component comp3, int fill) {
        this.addComponent(comp1, comp2, comp3, fill, new Insets(1, 0, 1, 0));
    }

    public void addComponent(Component comp1, Component comp2, Component comp3, int fill, Insets insets) {
        this.copyToolTips(comp1, comp2);
        this.copyToolTips(comp1, comp3);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.insets = insets;
        cons.fill = 1;
        this.gridBag.setConstraints(comp1, cons);
        this.add(comp1);
        cons.gridx = 1;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(comp2, cons);
        this.add(comp2);
        cons.fill = 0;
        cons.gridx = 2;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(comp3, cons);
        this.add(comp3);
        comp1.addKeyListener(this.lst);
        comp1.addMouseListener(this.lst);
        comp2.addKeyListener(this.lst);
        comp2.addMouseListener(this.lst);
    }

    public void addComponent(Component comp1, Component comp2, Component comp3) {
        this.addComponent(comp1, comp2, comp3, 1);
    }

    public void addComponent(Component comp) {
        this.addComponent(comp, new Insets(1, 0, 1, 0));
    }

    public void addComponent(Component comp, Insets insets) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = insets;
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
        comp.addKeyListener(this.lst);
        comp.addMouseListener(this.lst);
    }

    public void addComponent(Component comp, Insets insets, int numRows) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = numRows;
        this.y += numRows;
        cons.gridwidth = 0;
        cons.fill = 2;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = insets;
        cons.weighty = 0.0;
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
        comp.addKeyListener(this.lst);
        comp.addMouseListener(this.lst);
    }

    public void addComponent(Component comp, int fill) {
        this.addComponent(comp, fill, new Insets(1, 0, 1, 0));
    }

    public void addComponent(Component comp, int fill, Insets insets) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = fill;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = insets;
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
        comp.addKeyListener(this.lst);
        comp.addMouseListener(this.lst);
    }

    private void copyToolTips(Component c1, Component c2) {
        int tooltips = 0;
        int jc = 0;
        String text = null;
        JComponent jc1 = null;
        JComponent jc2 = null;
        try {
            jc1 = (JComponent)c1;
            text = jc1.getToolTipText();
            ++jc;
            if (text != null && text.length() > 0) {
                ++tooltips;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jc2 = (JComponent)c2;
            String text2 = jc2.getToolTipText();
            ++jc;
            if (text2 != null && text2.length() > 0) {
                text = text2;
                ++tooltips;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tooltips == 1 && jc == 2) {
            jc1.setToolTipText(text);
            jc2.setToolTipText(text);
        }
    }

    public JLabel newLabel(String label, Component comp) {
        JLabel retval = new JLabel(label);
        try {
            JComponent jc = (JComponent)comp;
            String tttext = jc.getToolTipText();
            retval.setToolTipText(tttext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public void addBlank() {
        this.addComponent(new JBlank(1, 1));
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private class MyValueChangeListener
    implements KeyListener,
    MouseListener {
        private MyValueChangeListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            GridBagLayoutPanel.this.changed = true;
        }
    }
}

