/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.celleditors;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.gvsig.gui.beans.swing.cellrenderers.NumberTableCellRenderer;

public class IntegerTableCellEditor
implements TableCellEditor {
    private static NumberTableCellRenderer renderer = new NumberTableCellRenderer(true, false);
    private ArrayList listeners = new ArrayList();

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            return null;
        }
        return renderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
    }

    @Override
    public void cancelCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingCanceled(evt);
        }
    }

    @Override
    public boolean stopCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingStopped(evt);
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (renderer != null && renderer.getIncrementalNumberField() != null) {
            return renderer.getIncrementalNumberField().getInteger();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }
}

