/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.cellrenderers;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class StringTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 2121615214282741840L;
    private JTextField txt;
    private boolean isBordered;
    private MatteBorder selectedBorder;
    private MatteBorder unselectedBorder;

    public JTextField getTextField() {
        return this.txt;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        try {
            String v = (String)value;
            this.txt = new JTextField(v);
            this.txt.setBackground(table.getBackground());
            return this.txt;
        }
        catch (ClassCastException ccEx) {
            throw new RuntimeException("Trying to use a Boolean cell renderer with a non-Boolean datatype");
        }
    }
}

