/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.wizard.panel;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import jwizardcomponent.JWizardComponents;
import jwizardcomponent.JWizardPanel;
import org.apache.commons.text.WordUtils;
import org.gvsig.gui.beans.wizard.WizardPanelWithLogo;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionPanelContainer
extends JWizardPanel {
    private static final long serialVersionUID = 3947658150325230122L;
    private static final Logger LOG = LoggerFactory.getLogger(OptionPanelContainer.class);
    private OptionPanel optionPanel = null;
    private WizardPanelWithLogo wizardPanel;

    public OptionPanelContainer(WizardPanelWithLogo wizardPanel, OptionPanel optionPanel) {
        super((JWizardComponents)wizardPanel.getWizardComponents());
        this.optionPanel = optionPanel;
        this.wizardPanel = wizardPanel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5), optionPanel.getPanelTitle()));
        this.add(optionPanel.getJPanel(), "Center");
    }

    public void back() {
        this.wizardPanel.setDirection(0);
        LOG.debug("WizarPanel '" + this.optionPanel.getPanelTitle() + "' back.");
        this.optionPanel.lastPanel();
        super.back();
    }

    public void next() {
        block2: {
            try {
                this.wizardPanel.setDirection(1);
                LOG.debug("WizarPanel '" + this.optionPanel.getPanelTitle() + "' next.");
                this.optionPanel.nextPanel();
                super.next();
            }
            catch (NotContinueWizardException e) {
                LOG.info("It is not possible to continue with the wizard. " + e.displayMessage());
                if (!e.displayMessage()) break block2;
                JOptionPane.showMessageDialog(e.getComponent(), WordUtils.wrap((String)e.getLocalizedMessageStack(), (int)120, null, (boolean)true));
            }
        }
    }

    public void update() {
        LOG.debug("WizarPanel '" + this.optionPanel.getPanelTitle() + "' update, direction " + this.wizardPanel.getDirection() + ".");
        this.optionPanel.updatePanel();
        super.update();
    }
}

