/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.Nullable;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.AppleRunTimeMakernoteDirectory;

public class AppleRunTimeMakernoteDescriptor
extends TagDescriptor<AppleRunTimeMakernoteDirectory> {
    public AppleRunTimeMakernoteDescriptor(AppleRunTimeMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.flagsDescription();
            }
            case 4: {
                return this.calculateTimeInSeconds();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    private String flagsDescription() {
        try {
            int value = ((AppleRunTimeMakernoteDirectory)this._directory).getInt(1);
            StringBuilder sb = new StringBuilder();
            if ((value & 1) == 1) {
                sb.append("Valid");
            } else {
                sb.append("Invalid");
            }
            if ((value & 2) != 0) {
                sb.append(", rounded");
            }
            if ((value & 4) != 0) {
                sb.append(", positive infinity");
            }
            if ((value & 8) != 0) {
                sb.append(", negative infinity");
            }
            if ((value & 0x10) != 0) {
                sb.append(", indefinite");
            }
            return sb.toString();
        }
        catch (MetadataException ignored) {
            return null;
        }
    }

    @Nullable
    private String calculateTimeInSeconds() {
        try {
            long value = ((AppleRunTimeMakernoteDirectory)this._directory).getLong(4);
            long scale = ((AppleRunTimeMakernoteDirectory)this._directory).getLong(3);
            return String.format("%d seconds", value / scale);
        }
        catch (MetadataException ignored) {
            return null;
        }
    }
}

