/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.spi.dynformfield;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.gvsig.tools.dynform.spi.dynformfield.DynFormFieldAction;
import org.gvsig.tools.dynform.spi.dynformfield.SupportPopupMenu;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class JCustomTextArea
extends JTextArea
implements SupportPopupMenu {
    private static final long serialVersionUID = -6180702611660178166L;
    private boolean hasEditor = true;
    private static Color backgroundColor = null;
    private String title = null;

    public JCustomTextArea(String title) {
        this(title, true);
    }

    public JCustomTextArea(String title, boolean withEditor) {
        this.title = title;
        this.hasEditor = withEditor;
        if (backgroundColor == null) {
            backgroundColor = UIManager.getLookAndFeel().getDefaults().getColor("TextField.background");
        }
        this.initComponent();
    }

    private void initComponent() {
        ToolsSwingLocator.getToolsSwingManager().setDefaultPopupMenu((JTextComponent)this, this.title, this.hasEditor);
        this.addSeparatorToPopupMenu();
        DynFormFieldAction sact = new DynFormFieldAction(null, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCustomTextArea.this.toggleWrapMode();
            }
        });
        this.addActionToPopupMenu("Toggle wrap mode", sact);
    }

    private void toggleWrapMode() {
        this.setLineWrap(!this.getLineWrap());
    }

    private void setActionEnabled(String name, boolean enabled) {
        Action action = this.getActionMap().get(name);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setActionEnabled("Cut", enabled);
        this.setActionEnabled("Paste", enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setEditable(boolean enabled) {
        this.setActionEnabled("Cut", enabled);
        this.setActionEnabled("Paste", enabled);
        super.setEditable(enabled);
        this.setBackground(backgroundColor);
    }

    public JPopupMenu getJPopupMenu() {
        return this.getComponentPopupMenu();
    }

    @Override
    public void addActionToPopupMenu(String name, Action action) {
        if (name != null && !name.isEmpty()) {
            action.putValue("Name", name);
        }
        this.getJPopupMenu().add(action);
    }

    @Override
    public void addSeparatorToPopupMenu() {
        this.getJPopupMenu().addSeparator();
    }
}

