/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.featureform.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.AbstractList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.featureform.swing.JFeatureReferencesForm;
import org.gvsig.featureform.swing.impl.DefaultFeaturesFormContext;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FacadeOfAFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.impl.DefaultDataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dynform.AbortActionException;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.JDynFormSet;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJFeatureReferencesForm
implements Disposable,
JFeatureReferencesForm {
    private final String REFRESHFORM_ACTION = "refreshForm";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJFeatureReferencesForm.class);
    private JPanel panel = new JPanel(new BorderLayout());
    private JDynFormSet formset;
    private DynFormDefinition definition = null;
    private final ActionListenerSupport actionListeners;
    private List<FeatureReference> references;
    private List<Feature> features;
    private List<DynObject> dynobjects;
    private FeatureStore store;

    public DefaultJFeatureReferencesForm() {
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                DefaultJFeatureReferencesForm.this.dispose();
            }
        });
        this.actionListeners = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
    }

    public void setPreferredSize(Dimension dimension) {
        this.panel.setPreferredSize(dimension);
    }

    private void updateForm() {
        if (this.formset == null) {
            this.getFormset();
        }
        try {
            this.formset.setValues(this.dynobjects);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't update form", ex);
        }
        this.updateButtonEnabledStatus();
    }

    public JComponent asJComponent() {
        this.updateForm();
        return this.panel;
    }

    public void bind(FeatureStore store, List<FeatureReference> references) {
        this.bind(store, null, references);
    }

    public void bind(FeatureStore store, DynClass definition, List<FeatureReference> references) {
        if (store == null || references == null) {
            throw new IllegalArgumentException("bind need a store as parameter, not a null.");
        }
        try {
            DynFormManager formManager = DynFormLocator.getDynFormManager();
            if (definition == null) {
                DefaultDataSwingManager manager = (DefaultDataSwingManager)DALSwingLocator.getSwingManager();
                definition = manager.featureType2DynClass(store, store.getDefaultFeatureType());
            }
            this.store = store;
            this.definition = formManager.getDefinition((DynStruct)definition);
            this.setFeatures(references);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't bind features of '" + store.getName() + "' to form", ex);
        }
    }

    public void dispose() {
        this.panel = null;
        this.formset = null;
        this.features = null;
        this.definition = null;
    }

    public JDynFormSet getFormset() {
        if (this.formset == null) {
            DynFormManager formManager = DynFormLocator.getDynFormManager();
            this.formset = formManager.createJDynFormSet((JDynForm.DynFormContext)new DefaultFeaturesFormContext(this.store){

                @Override
                public Feature getCurrentFeature() {
                    return DefaultJFeatureReferencesForm.this.getCurrentFeature();
                }
            }, this.definition, null);
            List groups = this.definition.getGroups();
            if (groups.size() == 1 && groups.get(0) == null) {
                this.formset.setLayoutMode(0);
            } else {
                this.formset.setLayoutMode(1);
            }
            this.formset.setAllowNew(false);
            this.formset.setAllowDelete(false);
            this.formset.setAllowUpdate(true);
            this.formset.setAllowClose(true);
            this.formset.setAllowSearch(false);
            this.formset.setAutosave(true);
            this.formset.addAction((Action)new RefreshAction());
            this.formset.addListener((JDynFormSet.JDynFormSetListener)new FormSetListener());
            this.formset.getForm().addListener(new JDynForm.JDynFormListener(){

                public void message(String string) {
                }

                public void fieldChanged(JDynFormField jdff) {
                    DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
                }
            });
            ToolsSwingLocator.getToolsSwingManager().removeBorder(this.formset.asJComponent());
            this.panel.add((Component)this.formset.asJComponent(), "Center");
            this.panel.revalidate();
            ToolsSwingUtils.ensureRowsCols((JComponent)this.panel, (int)8, (int)70, (int)25, (int)100);
        }
        this.updateButtonEnabledStatus();
        return this.formset;
    }

    public long getCurrentIndex() {
        if (this.formset == null) {
            return -1L;
        }
        return this.formset.getCurrentIndex();
    }

    public Feature get(long index) {
        if (this.formset == null || this.features == null) {
            return null;
        }
        return this.features.get((int)index);
    }

    public void showForm(WindowManager.MODE mode) {
        WindowManager winmgr = ToolsSwingLocator.getWindowManager();
        String title = this.definition.getLabel();
        winmgr.showWindow(this.asJComponent(), title, mode);
    }

    private void saveChanges(JDynFormSet theFormSet) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            int index = theFormSet.getCurrentIndex();
            DynObject currentElement = theFormSet.get(index);
            theFormSet.getFormValues(currentElement);
            this.store.update(((FacadeOfAFeature)currentElement).getEditableFeature());
            this.formset.message(i18n.getTranslation("_Record_saved"));
            try {
                this.formset.setCurrentIndex(index);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't reload form data after insert.", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            theFormSet.message(i18n.getTranslation("error_saving_data_will_not_save"));
            throw new RuntimeException("Can't save values", ex);
        }
        finally {
            this.updateButtonEnabledStatus();
        }
    }

    public void saveChanges() {
        if (this.formset != null && this.formset.countValues() > 0) {
            this.saveChanges(this.formset);
        }
    }

    private void updateButtonEnabledStatus() {
        if (this.formset == null) {
            return;
        }
        if (this.store == null || this.store.isBroken() || this.references == null) {
            this.formset.setReadOnly(true);
            this.formset.setActionEnabled("save", false);
            this.formset.setActionEnabled("refreshForm", false);
            this.formset.setActionEnabled("#navigation", false);
            return;
        }
        this.formset.setReadOnly(false);
        if (this.features != null && this.features.isEmpty()) {
            this.formset.getForm().setReadOnly(true);
            this.formset.setActionEnabled("save", false);
            this.formset.setActionEnabled("refreshForm", false);
            this.formset.setActionEnabled("#navigation", false);
        } else if (this.formset.getForm().isModified()) {
            this.formset.setActionEnabled("save", true);
            this.formset.setActionEnabled("refreshForm", true);
            this.formset.setActionEnabled("#navigation", true);
        } else {
            this.formset.setActionEnabled("save", false);
            this.formset.setActionEnabled("refreshForm", true);
            this.formset.setActionEnabled("#navigation", true);
        }
    }

    private void clearUniqueFields() {
        for (FeatureAttributeDescriptor attr : this.store.getDefaultFeatureTypeQuietly()) {
            JDynFormField field;
            if ((!attr.isPrimaryKey() || attr.isAutomatic()) && (!attr.isIndexed() || attr.allowIndexDuplicateds()) || (field = this.formset.getForm().getField(attr.getName())) == null) continue;
            field.clear();
        }
    }

    private void setEnabledUniqueFields(boolean enabled) {
        for (FeatureAttributeDescriptor attr : this.store.getDefaultFeatureTypeQuietly()) {
            JDynFormField field;
            if ((!attr.isPrimaryKey() || attr.isAutomatic()) && (!attr.isIndexed() || attr.allowIndexDuplicateds()) || (field = this.formset.getForm().getField(attr.getName())) == null) continue;
            field.setReadOnly(!enabled);
        }
    }

    public long getDataSetSize() {
        if (this.references != null) {
            return this.references.size();
        }
        return 0L;
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.addActionListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.removeActionListener(listener);
    }

    public void removeAllActionListener() {
        this.actionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent event) {
        this.actionListeners.fireActionEvent(event);
    }

    public boolean hasActionListeners() {
        return this.actionListeners.hasActionListeners();
    }

    public void setFeatures(List<FeatureReference> references) {
        this.references = references;
        this.features = new FeaturesList(references);
        this.dynobjects = new DynObjectsList(references);
        if (this.formset != null) {
            this.panel.remove(this.formset.asJComponent());
            this.panel.revalidate();
            this.formset = null;
        }
        this.updateForm();
    }

    public Feature getCurrentFeature() {
        long index = this.getCurrentIndex();
        if (index < 0L) {
            return null;
        }
        Feature f = this.get(index);
        try {
            DynObject adapter = f.getAsDynObject();
            this.getFormset().getForm().getValues(adapter);
            f = ((FacadeOfAFeature)adapter).getFeature();
            return f;
        }
        catch (Exception ex) {
            return f;
        }
    }

    private class FormSetListener
    implements JDynFormSet.JDynFormSetListener {
        private FormSetListener() {
        }

        public void formMessage(String message) {
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formMessage"));
        }

        public void formClose() {
            DefaultJFeatureReferencesForm.this.panel.setVisible(false);
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formClose"));
        }

        public void formMovedTo(int currentPosition) throws AbortActionException {
            LOGGER.trace("formMovedTo " + currentPosition);
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formMovedTo"));
        }

        public void formBeforeSave(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeSave");
            DefaultJFeatureReferencesForm.this.saveChanges(dynformSet);
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeSave"));
        }

        public void formBeforeNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeNew");
            DefaultJFeatureReferencesForm.this.clearUniqueFields();
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeNew"));
        }

        public void formBeforeDelete(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeDelete");
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeDelete"));
        }

        public void formAfterSave(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterSave");
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterSave"));
        }

        public void formAfterNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterNew");
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterNew"));
        }

        public void formAfterDelete(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterDelete");
        }

        public void formBeforeSearch(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeSearch");
        }

        public void formAfterSearch(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterSearch");
        }

        public void formBeforeCancelNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeCancelNew");
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeCancelNew"));
        }

        public void formAfterCancelNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterCancelNew");
            DefaultJFeatureReferencesForm.this.updateButtonEnabledStatus();
            DefaultJFeatureReferencesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterCancelNew"));
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
            this.putValue("Name", null);
            this.putValue("ShortDescription", i18nManager.getTranslation("_Reload_data"));
            this.putValue("SmallIcon", iconTheme.get("form-refresh-data"));
            this.putValue("ActionCommandKey", "refreshForm");
            this.setEnabled(!DefaultJFeatureReferencesForm.this.formset.isInNewState());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                I18nManager i18n = ToolsLocator.getI18nManager();
                DefaultJFeatureReferencesForm.this.formset.message(i18n.getTranslation("_Form_reloaded"));
                int x = DefaultJFeatureReferencesForm.this.formset.getCurrentIndex();
                DefaultJFeatureReferencesForm.this.updateForm();
                DefaultJFeatureReferencesForm.this.formset.setCurrentIndex(x);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't reload form", (Throwable)ex);
            }
        }
    }

    public static class DynObjectsList
    extends AbstractList<DynObject> {
        private final List<FeatureReference> references;

        public DynObjectsList(List<FeatureReference> references) {
            this.references = references;
        }

        @Override
        public DynObject get(int index) {
            try {
                Feature feature = this.references.get(index).getFeature();
                return feature.getAsDynObject();
            }
            catch (DataException ex) {
                throw new RuntimeException("Can't get dynobject " + index, ex);
            }
        }

        @Override
        public int size() {
            return this.references.size();
        }
    }

    public static class FeaturesList
    extends AbstractList<Feature> {
        private final List<FeatureReference> references;

        public FeaturesList(List<FeatureReference> references) {
            this.references = references;
        }

        @Override
        public Feature get(int index) {
            try {
                return this.references.get(index).getFeature();
            }
            catch (DataException ex) {
                throw new RuntimeException("Can't get feature " + index, ex);
            }
        }

        @Override
        public int size() {
            return this.references.size();
        }
    }
}

