/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.featureform.swing.impl.dynformfield.deprecated.linkedentity;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Formatter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.FacadeOfAFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class JDynFormFieldFeatureLink
extends AbstractJDynFormField
implements JDynFormField {
    private static final String DAL_code = "DAL.code";
    private static final String DAL_foreingTable = "DAL.foreingTable";
    private static final String DAL_foreingCode = "DAL.foreingCode";
    private static final String DAL_foreingDescriptionMask = "DAL.foreingDescriptionMask";
    private static final String DAL_foreingDescriptionFields = "DAL.foreingDescriptionFields";
    private DynObject assignedValue = null;
    private DynObject value = null;
    private JTextField txtDescription = null;
    private JButton btnLink = null;
    private JButton btnUnlink = null;
    private JButton btnEdit = null;
    private String codeFieldName = null;
    private String foreingTableName;
    private String foreingCodeName;
    private String foreingDescriptionMask = null;
    private String[] foreingDescriptionFieldNames = null;

    public JDynFormFieldFeatureLink(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        if (value != null) {
            this.assignedValue = (DynObject)value;
        }
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        this.foreingDescriptionFieldNames = null;
        this.codeFieldName = this.getTagValueAsString(DAL_code, null);
        this.foreingTableName = this.getTagValueAsString(DAL_foreingTable, null);
        this.foreingCodeName = this.getTagValueAsString(DAL_foreingCode, null);
        this.foreingDescriptionMask = this.getTagValueAsString(DAL_foreingDescriptionMask, null);
        String fieldNames = this.getTagValueAsString(DAL_foreingDescriptionFields, null);
        if (!StringUtils.isEmpty((CharSequence)fieldNames)) {
            this.foreingDescriptionFieldNames = fieldNames.split(",");
        }
        if (StringUtils.isEmpty((CharSequence)this.foreingDescriptionMask) && this.foreingDescriptionFieldNames != null && this.foreingDescriptionFieldNames.length == 1) {
            this.foreingDescriptionMask = "%s";
        }
        this.txtDescription = new JTextField();
        this.btnLink = this.createButton("Select item to link", "link.png");
        this.btnUnlink = this.createButton("Remove link", "unlink.png");
        this.btnEdit = this.createButton("View linked item", "edit.png");
        this.btnLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JDynFormFieldFeatureLink.this.doLink();
            }
        });
        this.btnUnlink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JDynFormFieldFeatureLink.this.doUnlink();
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JDynFormFieldFeatureLink.this.doEdit();
            }
        });
        this.txtDescription.setEditable(false);
        if (StringUtils.isEmpty((CharSequence)this.codeFieldName) || StringUtils.isEmpty((CharSequence)this.foreingDescriptionMask) || StringUtils.isEmpty((CharSequence)this.foreingTableName) || StringUtils.isEmpty((CharSequence)this.foreingCodeName) || this.foreingDescriptionFieldNames == null) {
            this.btnEdit.setEnabled(false);
            this.btnLink.setEnabled(false);
            this.btnUnlink.setEnabled(false);
        }
        this.contents = new JPanel();
        this.contents.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.ipadx = 4;
        c.ipady = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.contents.add((Component)this.txtDescription, c);
        c.fill = 0;
        c.ipadx = 4;
        c.ipady = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        this.contents.add((Component)this.btnLink, c);
        c.fill = 0;
        c.ipadx = 4;
        c.ipady = 1;
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 0.0;
        this.contents.add((Component)this.btnUnlink, c);
        c.fill = 0;
        c.ipadx = 4;
        c.ipady = 1;
        c.gridx = 4;
        c.gridy = 0;
        c.weightx = 0.0;
        this.contents.add((Component)this.btnEdit, c);
        this.setValue(this.assignedValue);
    }

    private JButton createButton(String tip, String image) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/gvsig/featureform/swing/impl/" + image);
        ImageIcon icon = new ImageIcon(url);
        JButton button = new JButton(icon);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setToolTipText(tip);
        button.setCursor(new Cursor(12));
        return button;
    }

    private void doLink() {
    }

    private void doUnlink() {
        this.clear();
    }

    private void doEdit() {
        try {
            DataManager dalmanager = DALLocator.getDataManager();
            DataSwingManager daluimanager = DALSwingLocator.getSwingManager();
            Feature feature = ((FacadeOfAFeature)this.value).getFeature();
            FeatureStore store = feature.getStore();
            FeatureQuery query = store.createFeatureQuery();
            query.addFilter(dalmanager.createExpresion(this.foreingCodeName + " = " + feature.getString(this.foreingCodeName)));
            JFeaturesForm form = daluimanager.createJFeaturesForm(store);
            form.setQuery(query);
            form.showForm(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show linked form", (Throwable)ex);
        }
    }

    private String getDescription() {
        if (StringUtils.isEmpty((CharSequence)this.foreingDescriptionMask) || this.foreingDescriptionFieldNames == null) {
            return "";
        }
        Object[] values = new Object[this.foreingDescriptionFieldNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.value.getDynValue(this.foreingDescriptionFieldNames[i]);
        }
        Formatter f = new Formatter();
        try {
            String description = f.format(this.foreingDescriptionMask, values).toString();
            return description;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public void setReadOnly(boolean readonly) {
        boolean enabled = !readonly;
        JComponent theJlabel = this.getJLabel();
        if (theJlabel != null) {
            theJlabel.setEnabled(enabled);
        }
        if (this.txtDescription == null) {
            return;
        }
        this.txtDescription.setEnabled(enabled);
        this.btnEdit.setEnabled(enabled);
        this.btnLink.setEnabled(enabled);
        this.btnUnlink.setEnabled(enabled);
    }

    public void setValue(Object value) {
        String description;
        if (value == null) {
            this.clear();
            return;
        }
        this.value = (DynObject)value;
        this.txtDescription.setText("");
        if (StringUtils.isEmpty((CharSequence)this.foreingCodeName) || StringUtils.isEmpty((CharSequence)this.foreingDescriptionMask) || this.foreingDescriptionFieldNames == null) {
            // empty if block
        }
        if ((description = this.getDescription()) != null) {
            this.txtDescription.setText(description);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void fetch(DynObject container) {
        if (StringUtils.isEmpty((CharSequence)this.codeFieldName)) {
            return;
        }
        DynObject value = (DynObject)this.getValue();
        if (value == null) {
            container.setDynValue(this.codeFieldName, null);
        } else {
            if (StringUtils.isEmpty((CharSequence)this.foreingCodeName)) {
                return;
            }
            container.setDynValue(this.codeFieldName, value.getDynValue(this.foreingCodeName));
        }
    }

    public boolean hasValidValue() {
        return true;
    }

    public void clear() {
        this.value = null;
        this.txtDescription.setText("");
    }
}

