/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.featureform.swing.impl.dynformfield.features;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.featureform.swing.FeaturesFormContext;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.complements.RelatedFeatures;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class JDynFormFieldRelatedFeatures
extends AbstractJDynFormField
implements JDynFormField {
    private List<Feature> assignedValue = null;
    private List<Feature> value = null;
    private FeatureType featureType;
    private List<String> columnNames;
    private JTable tblFeatures = null;
    private JButton btnEdit = null;
    private Dimension preferredSize = null;

    public JDynFormFieldRelatedFeatures(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        if (value != null) {
            this.assignedValue = (List)value;
        }
    }

    public void loadDefaultValuesFromTags(Tags tags) {
        super.loadDefaultValuesFromTags(tags);
        int width = tags.getInt("dynform.width", 100);
        int height = tags.getInt("dynform.height", -1);
        if (height > 100) {
            this.preferredSize = new Dimension(width, height);
        }
        this.setReadOnly(true);
    }

    public List<Feature> getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponentIfNeed() {
        if (this.contents == null) {
            this.initComponent();
        }
    }

    private RelatedFeatures getRelatedFeatures() {
        RelatedFeatures relatedFeatures = (RelatedFeatures)ToolsLocator.getComplementsManager().get("DAL.RelatedFeatures", (Object)this.getDefinition());
        return relatedFeatures;
    }

    private StoresRepository getStoresRepository() {
        JDynForm.DynFormContext context = this.getForm().getContext();
        if (!(context instanceof FeaturesFormContext)) {
            return null;
        }
        StoresRepository repository = ((FeaturesFormContext)context).getStoresRepository();
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initComponent() {
        JPanel panel = new JPanel();
        try {
            DynFormSPIManager.ComponentsFactory components = this.getComponentsFactory();
            DynFormSPIManager.ComponentsFactory.ScrolledComponent comps = components.getJTable(this.getDefinition(), null);
            JScrollPane scrollPane = comps.getScrollPane();
            if (scrollPane != null) {
                if (this.preferredSize != null) {
                    scrollPane.setPreferredSize(this.preferredSize);
                } else {
                    scrollPane.setPreferredSize(ToolsSwingUtils.rowscols2dimension((int)5, (int)60));
                }
            }
            this.tblFeatures = (JTable)comps.getComponent();
            this.btnEdit = components.getJButton(this.getDefinition(), "Edit");
            if (this.btnEdit == null) {
                this.btnEdit = new JButton();
            }
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnEdit, (String)"_See_related_item", (String)"picker-foreingkey-showform", ae -> this.doEdit(), null);
            if (!components.containsComponents(this.getDefinition())) {
                panel.setLayout(new BorderLayout());
                panel.add((Component)comps.getScrollPane(), "Center");
                JPanel panelButtons = new JPanel();
                panelButtons.setLayout(new FlowLayout(2, 4, 1));
                panelButtons.add(this.btnEdit);
                panel.add((Component)panelButtons, "South");
            }
            this.contents = panel;
            RelatedFeatures relatedFeatures = this.getRelatedFeatures();
            if (relatedFeatures == null) {
                this.problemIndicator().set("Unable to locate the related table.");
                return;
            }
            RelatedFeatures.ContextRelatedFeatures context = relatedFeatures.createContext();
            context.setStoresRepository(this.getStoresRepository());
            try {
                FeatureStore store = relatedFeatures.getFeatureStore(context);
                if (store == null) {
                    this.problemIndicator().set("Unable to locate the related table '" + relatedFeatures.getTableName() + "'.");
                    return;
                }
                this.columnNames = relatedFeatures.getColumns(context);
                this.featureType = store.getDefaultFeatureType();
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)context);
            }
            this.tblFeatures.setModel(new FeaturesTableModel(this.featureType, this.columnNames, this.assignedValue));
        }
        catch (Throwable th) {
            LOGGER.warn("Can't initialize components of '" + this.getName() + "'.", th);
        }
        this.setReadOnly(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEdit() {
        if (this.value == null) {
            return;
        }
        int selectedRow = this.tblFeatures.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        try {
            this.btnEdit.setEnabled(false);
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            RelatedFeatures relatedFeatures = this.getRelatedFeatures();
            if (relatedFeatures == null) {
                this.problemIndicator().set("Unable to locate the related table.");
                return;
            }
            RelatedFeatures.ContextRelatedFeatures context = relatedFeatures.createContext();
            context.setStoresRepository(this.getStoresRepository());
            FeatureStore store = relatedFeatures.getFeatureStore(context);
            if (store == null) {
                this.problemIndicator().set("Unable to locate the related table '" + relatedFeatures.getTableName() + "'.");
                return;
            }
            Feature f = this.value.get(selectedRow);
            FeatureQuery query = relatedFeatures.getUniqueKeyQuery(context, relatedFeatures.getUniqueKey(context, f));
            JFeaturesForm form = dataSwingManager.createJFeaturesForm(store);
            form.setQuery(query);
            form.showForm(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show linked form", (Throwable)ex);
        }
        finally {
            this.btnEdit.setEnabled(true);
        }
    }

    public void setValue(Object value) {
        this.initComponentIfNeed();
        if (value == null) {
            this.clear();
            return;
        }
        this.value = (List)value;
        this.tblFeatures.setModel(new FeaturesTableModel(this.featureType, this.columnNames, this.value));
    }

    public Object getValue() {
        return this.value;
    }

    public void fetch(DynObject container) {
    }

    public boolean hasValidValue() {
        return true;
    }

    public void clear() {
        this.initComponentIfNeed();
        this.value = null;
        this.tblFeatures.setModel(new FeaturesTableModel(this.featureType, this.columnNames, null));
    }

    public boolean isModified() {
        return false;
    }

    public String toHTML() {
        try {
            TableModel model = this.tblFeatures.getModel();
            StringBuilder builder = new StringBuilder();
            builder.append("<div>\n");
            builder.append("<table style=\"border: none;\" cellspacing=\"2\" cellpadding=\"0\">\n");
            builder.append("<tr>\n");
            for (int col = 0; col < model.getColumnCount(); ++col) {
                builder.append("<td style=\"white-space:nowrap;\">\n<i>");
                builder.append(StringEscapeUtils.escapeHtml3((String)model.getColumnName(col)));
                builder.append("</i></td>\n");
            }
            builder.append("</tr>\n");
            for (int row = 0; row < model.getRowCount(); ++row) {
                builder.append("<tr>\n");
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    builder.append("<td style=\"white-space:nowrap;\">");
                    builder.append(StringEscapeUtils.escapeHtml3((String)Objects.toString(model.getValueAt(row, col), "#ERROR#")));
                    builder.append("</td>\n");
                }
                builder.append("</tr>\n");
            }
            builder.append("</table>\n");
            builder.append("</div>\n");
            return builder.toString();
        }
        catch (Throwable t) {
            LOGGER.warn("Can't get HTML from features table.", t);
            return null;
        }
    }

    private class FeaturesTableModel
    extends AbstractTableModel {
        private final List<Feature> features;
        private final List<String> columnNames;
        private final FeatureType featureType;

        public FeaturesTableModel(FeatureType featureType, List<String> columnNames, List<Feature> features) {
            this.features = features;
            this.columnNames = columnNames;
            this.featureType = featureType;
        }

        @Override
        public int getRowCount() {
            if (this.features == null) {
                return 0;
            }
            try {
                return this.features.size();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't read row count from features.", (Throwable)ex);
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            if (this.features == null) {
                return 0;
            }
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.features == null) {
                return "";
            }
            String attrName = this.columnNames.get(columnIndex);
            if (this.featureType == null) {
                return attrName;
            }
            FeatureAttributeDescriptor attrdesc = this.featureType.getAttributeDescriptor(attrName);
            if (attrdesc == null) {
                return "C" + columnIndex;
            }
            return attrdesc.getLocalizedShortLabel();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.featureType == null) {
                return String.class;
            }
            String attrName = this.columnNames.get(columnIndex);
            FeatureAttributeDescriptor attrdesc = this.featureType.getAttributeDescriptor(attrName);
            if (attrdesc == null) {
                return String.class;
            }
            return attrdesc.getDataType().getDefaultClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.features == null) {
                return null;
            }
            Feature feature = this.features.get(rowIndex);
            String attrName = this.columnNames.get(columnIndex);
            try {
                return feature.get(attrName);
            }
            catch (Throwable th) {
                return null;
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

