/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.featureform.swing.JFeatureForm;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ValidateFeaturesException;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingNotificationManager
implements EditingNotificationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEditingNotificationManager.class);
    private static final String TAG_FORCE_SHOW_FORM_ON_INSERT = "forceShowFormOnInsert";
    private ObservableHelper helper = new ObservableHelper();
    private static final int SOURCE = 1;
    private static final int DOCUMENT = 2;
    private static final int AUXDATA = 3;
    private static final int STORE = 4;
    private static final int FEATURE = 5;
    private static final int FEATURETYPE = 6;
    private static List<String> cancelableNotifications = null;
    private static Map<String, String> event2method = null;

    public void addObserver(Observer o) {
        this.helper.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.helper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.helper.deleteObservers();
    }

    public EditingNotification notifyObservers(EditingNotification notification) {
        try {
            this.helper.notifyObservers((Observable)this, (Object)notification);
        }
        catch (Exception ex) {
            LOGGER.warn("Problems notifing to observers of DefaultEditingNotificationManager.", (Throwable)ex);
        }
        return notification;
    }

    public EditingNotification notifyObservers(Object source, String type, Object document, Object auxdata, DataStore store, Feature feature, EditableFeatureType featureType) {
        ResourcesStorage resources;
        Script script;
        String methodname;
        DefaultEditingNotification notification = new DefaultEditingNotification(type);
        notification.setValue(1, source);
        notification.setValue(2, document);
        notification.setValue(3, auxdata);
        notification.setValue(4, store);
        notification.setValue(5, feature);
        notification.setValue(6, featureType);
        if (store != null && StringUtils.isNotBlank((CharSequence)(methodname = this.event2methodname(type))) && (script = ExpressionUtils.getScript((ResourcesStorage)(resources = store.getResourcesStorage()), (String)"editsc")) != null) {
            try {
                script.invokeFunction(methodname, new Object[]{notification});
                if (notification.isCanceled()) {
                    return notification;
                }
            }
            catch (NoSuchMethodException ex) {
                LOGGER.debug("No existe el metodo '" + methodname + "' en el script.");
            }
            catch (Throwable ex) {
                LOGGER.warn("Can't call method '" + methodname + "'.");
            }
        }
        return this.notifyObservers(notification);
    }

    private String event2methodname(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        if (event2method == null) {
            event2method = new HashMap<String, String>();
            event2method.put("BEFORE_ENTER_EDITING_STORE", "beforeEnterEditing");
            event2method.put("BEFORE_EXIT_EDITING_STORE", "beforeExitEditing");
            event2method.put("BEFORE_INSERT_FEATURE", "beforeInsert");
            event2method.put("BEFORE_UPDATE_FEATURE", "beforeUpdate");
            event2method.put("BEFORE_REMOVE_FEATURE", "beforeRemove");
            event2method.put("BEFORE_UPDATE_FEATURE_TYPE", "beforeUpdateFeatureType");
            event2method.put("AFTER_ENTER_EDITING_STORE", "afterEnterEditing");
            event2method.put("AFTER_EXIT_EDITING_STORE", "afterExitEditing");
            event2method.put("AFTER_INSERT_FEATURE", "afterInsert");
            event2method.put("AFTER_UPDATE_FEATURE", "afterUpdate");
            event2method.put("AFTER_REMOVE_FEATURE", "afterRemove");
            event2method.put("AFTER_UPDATE_FEATURE_TYPE", "afterUpdateFeatureType");
        }
        return event2method.getOrDefault(type, "whenEvent");
    }

    public EditingNotification notifyObservers(Object source, String type, Object document, Object auxdata, DataStore store) {
        return this.notifyObservers(source, type, document, auxdata, store, null, null);
    }

    public EditingNotification notifyObservers(Object source, String type, Object document, Object auxdata) {
        return this.notifyObservers(source, type, document, auxdata, null, null, null);
    }

    public EditingNotification notifyObservers(Object source, String type, Object document, DataStore store) {
        return this.notifyObservers(source, type, document, null, store, null, null);
    }

    public EditingNotification notifyObservers(Object source, String type, Object document, DataStore store, Feature feature) {
        return this.notifyObservers(source, type, document, null, store, feature, null);
    }

    public EditingNotification notifyObservers(Object source, String type, Object document, DataStore store, EditableFeatureType featureType) {
        return this.notifyObservers(source, type, document, null, store, null, featureType);
    }

    public EditingNotification notifyObservers(Object source, String type, Object document, Object auxdata, DataStore store, Feature feature) {
        return this.notifyObservers(source, type, document, auxdata, store, feature, null);
    }

    public boolean validateFeature(Feature feature) {
        FeatureType featureType = feature.getType();
        Tags tags = featureType.getTags();
        boolean forceShowForm = tags != null && tags.getBoolean(TAG_FORCE_SHOW_FORM_ON_INSERT, false);
        while (true) {
            boolean validateOk = true;
            if (feature instanceof EditableFeature) {
                try {
                    for (FeatureRule rule : featureType.getRules()) {
                        if (rule == null || !rule.checkWhen(4)) continue;
                        try {
                            rule.validate((EditableFeature)feature, feature.getStore());
                        }
                        catch (ValidateFeaturesException ex) {
                            validateOk = false;
                        }
                        catch (Exception ex) {
                            FeatureReference ref = feature.getReference();
                            LOGGER.warn("Can't run validate rule '" + rule.getName() + "' on feature '" + Objects.toString(ref) + "'.", (Throwable)ex);
                        }
                    }
                }
                catch (Exception ex) {
                    FeatureReference ref = feature.getReference();
                    LOGGER.warn("Can't run validate feature '" + Objects.toString(ref) + "'.");
                }
            }
            if (validateOk && !forceShowForm && this.canWriteFeature(feature)) {
                return true;
            }
            AskRequiredAttributtes ask = new AskRequiredAttributtes();
            ask.showDialog(feature);
            if (ask.userCancel()) {
                return false;
            }
            forceShowForm = false;
        }
    }

    public boolean canWriteFeature(Feature feature) {
        FeatureAttributeDescriptor[] attributeDescriptors;
        FeatureType featureType = feature.getType();
        if (!featureType.isCheckFeaturesAtInsert()) {
            return true;
        }
        for (FeatureAttributeDescriptor attrDesc : attributeDescriptors = featureType.getAttributeDescriptors()) {
            if (attrDesc.isAutomatic() || !attrDesc.isPrimaryKey() && attrDesc.allowNull() || feature.get(attrDesc.getName()) != null) continue;
            return false;
        }
        return true;
    }

    private void setPreferredSize(JComponent c, int width, int height) {
        Dimension d = c.getPreferredSize();
        if (d.width < width) {
            d.width = width;
        }
        if (d.height > height) {
            d.height = height;
        }
        c.setPreferredSize(d);
    }

    public static final void selfRegister() {
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        dynObjectManager.registerTag(TAG_FORCE_SHOW_FORM_ON_INSERT, "String value, true/false to force show form on insert features.");
    }

    private class AskRequiredAttributtes {
        private boolean userCancelValue = true;

        private AskRequiredAttributtes() {
        }

        public boolean userCancel() {
            return this.userCancelValue;
        }

        public void showDialog(Feature feature) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(() -> this.showDialog(feature));
                    return;
                }
                catch (Exception e1) {
                    this.message("Can't show form to fill need data.", e1);
                    this.userCancelValue = true;
                    return;
                }
            }
            try {
                JFeatureForm form = DALSwingLocator.getSwingManager().createJFeatureForm(feature);
                ToolsSwingUtils.ensureRowsCols((JComponent)form.asJComponent(), (int)15, (int)80, (int)25, (int)140);
                WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
                Dialog dialog = winManager.createDialog(form.asJComponent(), form.getDynForm().getDefinition().getLabel(), ToolsLocator.getI18nManager().getTranslation("_Fill_the_required_fields"), 3);
                dialog.show(WindowManager.MODE.DIALOG);
                if (dialog.getAction() == 1) {
                    form.fetch((EditableFeature)feature);
                    this.userCancelValue = false;
                } else {
                    this.userCancelValue = true;
                }
            }
            catch (Exception ex) {
                this.message("Can't show form to fill need data.", ex);
                this.userCancelValue = true;
            }
        }

        private void message(String msg, Throwable ex) {
            if (ex == null) {
                LOGGER.warn(msg);
            } else {
                LOGGER.warn(msg, ex);
            }
        }
    }

    public class DefaultEditingNotification
    extends BaseNotification
    implements EditingNotification {
        private boolean validateTheFeature;

        DefaultEditingNotification(String type) {
            super(type, 7);
            this.validateTheFeature = true;
        }

        public Object getSource() {
            return this.getValue(1);
        }

        public Object getDocument() {
            return this.getValue(2);
        }

        public Object getAuxData() {
            return this.getValue(3);
        }

        public DataStore getStore() {
            return (DataStore)this.getValue(4);
        }

        public FeatureStore getFeatureStore() {
            return (FeatureStore)this.getValue(4);
        }

        public Feature getFeature() {
            return (Feature)this.getValue(5);
        }

        public EditableFeatureType getFeatureType() {
            return (EditableFeatureType)this.getValue(6);
        }

        public boolean isCancelable() {
            if (cancelableNotifications == null) {
                String[] nn = new String[]{"BEFORE_ENTER_EDITING_STORE", "BEFORE_EXIT_EDITING_STORE", "BEFORE_INSERT_FEATURE", "BEFORE_REMOVE_FEATURE", "BEFORE_UPDATE_FEATURE", "BEFORE_UPDATE_FEATURE_TYPE"};
                cancelableNotifications = Arrays.asList(nn);
            }
            return cancelableNotifications.contains(this.getType());
        }

        public void setSkipFeatureValidation(boolean skipTheFeatureValidation) {
            this.validateTheFeature = !skipTheFeatureValidation;
        }

        public boolean shouldValidateTheFeature() {
            return this.validateTheFeature;
        }
    }
}

