/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.app.gui.panels.CRSSelectPanelFactory;
import org.gvsig.app.gui.panels.crs.ISelectCrsPanel;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class ProjectionPickerControllerImpl
extends AbstractPickerController<IProjection>
implements ProjectionPickerController {
    private final JTextField txtProjection;
    private final JButton btnSelectProjection;
    private IProjection projection;

    public ProjectionPickerControllerImpl(JTextField txtProjection, JButton btnSelectProjection) {
        this.txtProjection = txtProjection;
        this.btnSelectProjection = btnSelectProjection;
        this.projection = null;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.txtProjection.setEditable(false);
        this.txtProjection.setText("");
        toolsSwingManager.addClearButton((JTextComponent)this.txtProjection, e -> this.set(null));
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtProjection);
        this.btnSelectProjection.addActionListener(e -> this.doSelectProjection());
        if (StringUtils.equals((CharSequence)this.btnSelectProjection.getText(), (CharSequence)"...") && this.existsIcon("picker-crs")) {
            this.btnSelectProjection.setText("");
            this.btnSelectProjection.setIcon(this.getIcon("picker-crs"));
        }
    }

    private void doSelectProjection() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ISelectCrsPanel crsSelectPanel = CRSSelectPanelFactory.getUIFactory().getSelectCrsPanel(this.projection, true);
        WindowManager winManager = ToolsSwingLocator.getWindowManager();
        winManager.showWindow((JComponent)crsSelectPanel, i18n.getTranslation("selecciona_sistema_de_referencia"), WindowManager.MODE.DIALOG);
        if (crsSelectPanel.isOkPressed()) {
            this.set(crsSelectPanel.getProjection());
            this.fireChangeEvent();
        }
    }

    public ICoordTrans getCoordinateTransformation() {
        return null;
    }

    public IProjection get() {
        return this.projection;
    }

    public void set(IProjection projection) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.set(projection));
            return;
        }
        this.projection = projection;
        if (this.projection == null) {
            this.txtProjection.setText("");
        } else {
            this.txtProjection.setText(this.projection.getAbrev());
        }
    }

    public void coerceAndSet(Object o) {
        this.set((IProjection)this.coerce(65, o, null));
    }

    public void setEnabled(boolean bln) {
        this.btnSelectProjection.setEnabled(bln);
    }

    public boolean isEnabled() {
        return this.btnSelectProjection.isEnabled();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.btnSelectProjection.setEnabled(editable);
    }

    public boolean isEmpty() {
        return this.projection == null;
    }

    public static void selfRegister() {
        boolean n = ToolsSwingUtils.registerIcons(ProjectionPickerControllerImpl.class, (String)"projectionpicker", (String)"DataAccessSwingLibrary", (String[][])new String[][]{{"picker", "picker-crs", "picker-crs"}});
    }
}

