/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.impl.actions.ShowFormAction;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphAction
extends AbstractAction
implements ListSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowFormAction.class);
    private final DALActionFactory.DALActionContext context;
    private boolean showFormSingleElement;

    public GraphAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "Graph");
        this.putValue("ShortDescription", i18n.getTranslation("_Show_graph"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("chart"));
        try {
            this.showFormSingleElement = true;
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            FeatureAttributeDescriptor[] pks = featureStore.getDefaultFeatureType().getPrimaryKey();
            if (pks == null || pks.length < 1) {
                this.showFormSingleElement = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.setEnabled(false);
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            FeatureQuery query = this.context.getQuery();
            svDefaultCategoryDataset dataset = new svDefaultCategoryDataset();
            FeatureSet features = featureStore.getFeatureSet(query);
            Iterable orderMembers = query.getOrder().members();
            ArrayList<String> fields = new ArrayList<String>();
            for (FeatureQueryOrder.FeatureQueryOrderMember orderMember : orderMembers) {
                fields.add(orderMember.getAttributeName());
            }
            if (fields.size() < 2) {
                return;
            }
            fields.add((String)this.context.getQuery().getAggregateFunctions().keySet().toArray()[0]);
            String field1 = (String)fields.get(0);
            String field2 = (String)fields.get(1);
            String fieldValue = (String)fields.get(2);
            for (Feature feature : features) {
                Object value = feature.get(fieldValue);
                if (!(value instanceof Number)) continue;
                String valueField1 = feature.getType().getAttributeDescriptor(field1) != null ? feature.getLabelOfValue(field1) : feature.get(field1).toString();
                String valueField2 = feature.getType().getAttributeDescriptor(field2) != null ? feature.getLabelOfValue(field2) : feature.get(field1).toString();
                dataset.addValue((Number)value, (Comparable)((Object)valueField1), (Comparable)((Object)valueField2));
            }
            JFreeChart barChart = ChartFactory.createBarChart((String)(field1 + " " + field2), (String)field2, (String)fieldValue, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            ChartPanel chartPanel = new ChartPanel(barChart);
            chartPanel.setPreferredSize(new Dimension(360, 200));
            ToolsSwingLocator.getWindowManager().showWindow((JComponent)chartPanel, "action", WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show form", (Throwable)ex);
        }
        finally {
            this.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.context.getSelectedsCount() == 0) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(this.showFormSingleElement);
    }

    public static class GraphActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "Graph";

        public GraphActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new GraphAction(context);
        }

        public boolean isApplicable(Object ... args) {
            return false;
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new GraphActionFactory());
        }
    }

    private class svDefaultCategoryDataset
    extends DefaultCategoryDataset {
    }
}

