/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.impl.actions.ReportUtils;
import org.gvsig.fmap.dal.swing.report.ReportAction;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportStoreAction
extends AbstractAction {
    public static String ACTION_NAME = "Reports";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportStoreAction.class);
    private final DALActionFactory.DALActionContext context;
    private final ReportStoreActionFactory factory;

    public ReportStoreAction(ReportStoreActionFactory factory, DALActionFactory.DALActionContext context) {
        this.factory = factory;
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", ACTION_NAME);
        this.putValue("ShortDescription", i18n.getTranslation("_Reports"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("storeaction-reports-select"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            List<ReportAction> actions = ReportUtils.getReportActions(store, null, this.context, e);
            JPopupMenu popup = new JPopupMenu();
            for (ReportAction reportAction : actions) {
                popup.add(new JMenuItem((Action)reportAction));
            }
            for (Pair pair : this.factory.getCustomActions().values()) {
                Action action = ((ReportActionFactory.ReportCustomActionFactory)pair.getLeft()).createCustomAction(e, this.context);
                if (action == null) continue;
                if (((Boolean)pair.getRight()).booleanValue() && popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(action);
            }
            JComponent button = this.context.getActionButton(ACTION_NAME);
            popup.show(button, 0, button.getHeight());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show form", (Throwable)ex);
        }
    }

    @Override
    public boolean isEnabled() {
        try {
            Map<String, Pair<ReportActionFactory.ReportCustomActionFactory, Boolean>> customActions;
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return false;
            }
            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
            List<JsonObject> reports = ReportUtils.getReports((FeatureStore)store);
            if (reports != null && !reports.isEmpty()) {
                for (JsonObject json : reports) {
                    for (ReportActionFactory thefactory : dataSwingManager.getReportActionFactories()) {
                        if (!thefactory.isApplicable(new Object[]{json, this.context})) continue;
                        return true;
                    }
                }
            }
            return (customActions = this.factory.getCustomActions()) != null && !customActions.isEmpty();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check isEnabled", (Throwable)ex);
            return false;
        }
    }

    public static class ReportStoreActionFactory
    implements DALActionFactory {
        private final Map<String, Pair<ReportActionFactory.ReportCustomActionFactory, Boolean>> customActions = new LinkedHashMap<String, Pair<ReportActionFactory.ReportCustomActionFactory, Boolean>>();

        public String getName() {
            return ACTION_NAME;
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new ReportStoreAction(this, context);
        }

        public boolean isApplicable(Object ... args) {
            return true;
        }

        public void registerCustomAction(ReportActionFactory.ReportCustomActionFactory factory, boolean insertSeparator) {
            this.customActions.put(factory.getName(), (Pair<ReportActionFactory.ReportCustomActionFactory, Boolean>)new ImmutablePair((Object)factory, (Object)insertSeparator));
        }

        public Map<String, Pair<ReportActionFactory.ReportCustomActionFactory, Boolean>> getCustomActions() {
            return this.customActions;
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new ReportStoreActionFactory());
            ToolsSwingUtils.registerIcons(ReportStoreAction.class, (String)"images", (String)"DataAccessSwingLibrary", (String[][])new String[][]{{"storeaction", "storeaction-reports-select"}});
        }
    }
}

