/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionSetAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionSetAction.class);
    private final DALActionFactory.DALActionContext context;

    public SelectionSetAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "SelectionSet");
        this.putValue("ShortDescription", i18n.getTranslation("_New_selection"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("storeaction-select"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        FeatureSet selection = null;
        try {
            Expression filter;
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            FeatureSelection currentSelection = this.context.getSelecteds();
            if (currentSelection != null) {
                featureStore.setSelection((FeatureSet)currentSelection);
                return;
            }
            FeatureQuery query = null;
            FeatureQuery contextQuery = this.context.getQuery();
            if (contextQuery != null && (filter = contextQuery.getExpressionFilter()) != null) {
                query = featureStore.createFeatureQuery();
                query.setFilter(filter);
                for (EditableFeatureAttributeDescriptor extraColumn : contextQuery.getExtraColumns()) {
                    if (!this.expressionUseIdentifier(filter, extraColumn.getName())) continue;
                    query.getExtraColumns().getColumns().add(extraColumn);
                }
            }
            currentSelection = featureStore.getFeatureSelection();
            if (query == null) {
                currentSelection.selectAll();
                return;
            }
            selection = featureStore.getFeatureSet(query);
            currentSelection.deselectAll();
            currentSelection.select(selection);
            DisposeUtils.disposeQuietly((Disposable)selection);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build selection.", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly(selection);
        }
    }

    private boolean expressionUseIdentifier(Expression filter, final String name) {
        final MutableBoolean res = new MutableBoolean(false);
        try {
            filter.getCode().accept(new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    Code.Constant p1;
                    Code.Callable callable;
                    if (((Code)obj).code() == 1) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)((Code.Identifier)obj).name())) {
                            res.setTrue();
                            throw new VisitCanceledException();
                        }
                    } else if (((Code)obj).code() == 2 && StringUtils.equalsIgnoreCase((CharSequence)"GETATTR", (CharSequence)(callable = (Code.Callable)obj).name()) && callable.parameters().size() == 2 && ((Code)callable.parameters().get(1)).code() == 0 && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)Objects.toString((p1 = (Code.Constant)callable.parameters().get(1)).value(), null))) {
                        res.setTrue();
                        throw new VisitCanceledException();
                    }
                }
            });
        }
        catch (VisitCanceledException visitCanceledException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Can't check if '" + name + "' is in '" + filter.getPhrase() + "'", e);
        }
        return res.booleanValue();
    }

    public static class SelectionSetActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "SelectionSet";

        public SelectionSetActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new SelectionSetAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new SelectionSetActionFactory());
        }
    }
}

