/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFormAction
extends AbstractAction
implements ListSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowFormAction.class);
    private final DALActionFactory.DALActionContext context;
    private boolean showFormSingleElement;

    public ShowFormAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "ShowForm");
        this.putValue("ShortDescription", i18n.getTranslation("_Show_form"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("common-showform"));
        try {
            this.showFormSingleElement = true;
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            FeatureAttributeDescriptor[] pks = featureStore.getDefaultFeatureType().getPrimaryKey();
            if (pks == null || pks.length < 1) {
                this.showFormSingleElement = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            FeatureQuery query;
            this.setEnabled(false);
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            Expression filter = this.context.getFilterForSelecteds();
            if (filter == null && (query = this.context.getQuery()) != null) {
                filter = query.getExpressionFilter();
            }
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            FeatureQuery query2 = featureStore.createFeatureQuery();
            query2.setFilter(filter);
            query2.retrievesAllAttributes();
            JFeaturesForm form = dataSwingManager.createJFeaturesForm(featureStore);
            form.setQuery(query2);
            form.showForm(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show form", (Throwable)ex);
        }
        finally {
            this.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.context.getSelectedsCount() == 0) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(this.showFormSingleElement);
    }

    public static class ShowFormActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "ShowForm";

        public ShowFormActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new ShowFormAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new ShowFormActionFactory());
        }
    }
}

