/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.expressionevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.fmap.dal.swing.impl.expressionevaluator.FeatureAttributeElement;
import org.gvsig.tools.ToolsLocator;

public class DefaultFeatureStoreElement
extends AbstractElement
implements FeatureStoreElement,
Element.SimpleElement {
    private FeatureStore store;
    private List<Element> elements;
    private String myName;
    private boolean useFullyQualifiedNames = false;

    public DefaultFeatureStoreElement(FeatureStore store) {
        super("store", (Object)"store", "featurestore-table");
        this.setFeatureStore(store);
    }

    public Element get(int index) {
        return this.buildElements().get(index);
    }

    public String getLabel() {
        return this.getName();
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getName() {
        if (!StringUtils.isBlank((CharSequence)this.myName)) {
            return this.myName;
        }
        if (this.store == null) {
            return super.getName();
        }
        return this.store.getName();
    }

    public int size() {
        return this.buildElements().size();
    }

    public Iterator<Element> iterator() {
        return this.buildElements().iterator();
    }

    public void addElement(Element element) {
    }

    public void addElement(Function function) {
    }

    public List<Element> getElements() {
        return Collections.unmodifiableList(this.buildElements());
    }

    public void setFeatureStore(FeatureStore store) {
        this.store = store;
        if (store == null) {
            this.elements = null;
        }
        this.buildElements();
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public Element setConfig(ExpressionBuilderConfig config) {
        super.setConfig(config);
        this.buildElements();
        return this;
    }

    private List<Element> buildElements() {
        if (this.elements == null) {
            if (this.store == null || this.getConfig() == null) {
                return Collections.EMPTY_LIST;
            }
            try {
                FeatureType type = this.store.getDefaultFeatureType();
                this.elements = new ArrayList<Element>();
                Search search = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)type);
                List attributes = search.getOrderedAttributes(FeatureType.ALL_FILTER, Search.LABEL_ORDER, -1);
                for (Search.OrderedAttribute attrdesc : attributes) {
                    FeatureAttributeElement element = new FeatureAttributeElement((Element)this, this.store, attrdesc.getDescriptor());
                    element.setConfig(this.getConfig());
                    this.elements.add((Element)element);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.elements;
    }

    public void setUseFullyQualifiedNames(boolean useFullyQualifiedNames) {
        this.useFullyQualifiedNames = useFullyQualifiedNames;
    }

    public boolean getUseFullyQualifiedNames() {
        return this.useFullyQualifiedNames;
    }
}

