/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.expressionevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.expressionevaluator.TableAttributeHandler;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.fmap.dal.swing.impl.expressionevaluator.FeatureAttributeElement;
import org.gvsig.fmap.dal.swing.impl.featuretype.FeatureAttributeTreeModel;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;

public class DefaultFeatureStoreElement2
extends AbstractElement
implements Element.SimpleElement,
Element.GroupElement,
FeatureStoreElement {
    private static final String DEFAULT_ELEMENT_NAME = "store";
    private boolean useFullyQualifiedNames = false;
    private List<Element> elements;
    private FeatureStore store;
    private FeatureAttributeTreeModel treemodel;
    private boolean useHostVariable;

    public DefaultFeatureStoreElement2(FeatureStore store, String name, boolean useHostVariable) {
        super(name, (Object)DEFAULT_ELEMENT_NAME, "featurestore-table");
        this.setFeatureStore(store);
        this.useHostVariable = useHostVariable;
    }

    public DefaultFeatureStoreElement2(FeatureStore store, String name) {
        this(store, DEFAULT_ELEMENT_NAME, false);
    }

    public DefaultFeatureStoreElement2(FeatureStore store) {
        this(store, DEFAULT_ELEMENT_NAME);
    }

    public Element get(int index) {
        return this.getElements().get(index);
    }

    public int size() {
        return this.getElements().size();
    }

    public Iterator<Element> iterator() {
        return this.getElements().iterator();
    }

    public void addElement(Element element) {
    }

    public void addElement(Function function) {
    }

    public Collection<Element> getValues() {
        return this.getElements();
    }

    public List<Element> getElements() {
        if (this.treemodel == null) {
            return null;
        }
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
            FeatureAttributeTreeModel.Node root = (FeatureAttributeTreeModel.Node)this.treemodel.getRoot();
            List<FeatureAttributeTreeModel.Node> children = root.getChildren();
            for (FeatureAttributeTreeModel.Node child : children) {
                FeatureAttributeDescriptor attrdesc = (FeatureAttributeDescriptor)child.getValue();
                FeatureAttributeElement e = attrdesc.isForeingKey() ? new ForeingKeyElement((Element)this, child, this.useHostVariable) : new FeatureAttributeElement((Element)this, child.getFeatureStore(), attrdesc, this.useHostVariable);
                e.setConfig(this.getConfig());
                this.elements.add((Element)e);
            }
        }
        return this.elements;
    }

    public String getLabel() {
        if (this.store == null) {
            return super.getLabel();
        }
        return this.store.getName();
    }

    public String getRenderedValue() {
        if (this.store == null) {
            return super.getRenderedValue();
        }
        return this.store.getName();
    }

    public void setName(String name) {
        super.setName(name);
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public final void setFeatureStore(FeatureStore store) {
        this.store = store;
        this.init();
    }

    public Element setConfig(ExpressionBuilderConfig config) {
        super.setConfig(config);
        this.init();
        return this;
    }

    private void init() {
        Feature sampleFeature;
        SymbolTable previewSymbolTable;
        DisposeUtils.disposeQuietly((Disposable)this.treemodel);
        this.treemodel = null;
        this.elements = null;
        if (this.store == null || this.getConfig() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DEFAULT_ELEMENT_NAME, (CharSequence)this.store.getName())) {
            this.setName(this.store.getName());
        }
        if (!((previewSymbolTable = this.getConfig().getPreviewSymbolTable()) != null && this.containsThisStore(previewSymbolTable) || (sampleFeature = this.store.getSampleFeature()) == null)) {
            FeatureSymbolTable featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
            featureSymbolTable.setFeature(sampleFeature);
            this.getConfig().setPreviewSymbolTable((SymbolTable)featureSymbolTable.createParent());
        }
        this.treemodel = new FeatureAttributeTreeModel(this.store, this.store.getDefaultFeatureTypeQuietly(), true, Search.ALL_FILTER);
    }

    private boolean containsThisStore(SymbolTable previewSymbolTable) {
        TableAttributeHandler table = (TableAttributeHandler)previewSymbolTable.value("$TABLE");
        if (table == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)this.store.getName(), (CharSequence)table.getName());
    }

    public void reload() {
        if (this.elements != null) {
            for (Element element : this.elements) {
                element.reload();
            }
        }
    }

    public void setUseFullyQualifiedNames(boolean useFullyQualifiedNames) {
        this.useFullyQualifiedNames = useFullyQualifiedNames;
    }

    public boolean getUseFullyQualifiedNames() {
        return this.useFullyQualifiedNames;
    }

    public void dispose() {
        DisposeUtils.disposeQuietly((Disposable)this.treemodel);
        this.treemodel = null;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultFeatureStoreElement2 other = (DefaultFeatureStoreElement2)((Object)super.clone());
        other.treemodel = null;
        other.init();
        return other;
    }

    private class ForeingKeyElement
    extends FeatureAttributeElement
    implements Element.SimpleElement,
    Element.GroupElement {
        private final FeatureAttributeTreeModel.Node node;
        private List<Element> elements;
        boolean useHostVariable;

        public ForeingKeyElement(Element parent, FeatureAttributeTreeModel.Node node, boolean useHostVariable) {
            super(parent, node.getFeatureStore(), (FeatureAttributeDescriptor)node.getValue(), "featurestore-foreing-key", useHostVariable);
            this.useHostVariable = useHostVariable;
            this.node = node;
        }

        @Override
        public String getLabel() {
            FeatureAttributeDescriptor attribute = (FeatureAttributeDescriptor)this.node.getValue();
            if (attribute != null && attribute.isForeingKey()) {
                ForeingKey foreingKey = attribute.getForeingKey();
                if (this.getConfig().getPreferences().getShowLabelsOfElements()) {
                    if (!StringUtils.equals((CharSequence)this.attrdesc.getName(), (CharSequence)this.attrdesc.getLabel())) {
                        return String.format("<html>%s<br><font size=\"2\"><i>(%s[%s])</i></font></html>", this.attrdesc.getLocalizedLabel(), this.attrdesc.getName(), foreingKey.getTableName());
                    }
                    return String.format("<html>%s<br><font size=\"2\"><i>([%s])</i></font></html>", this.attrdesc.getLocalizedLabel(), foreingKey.getTableName());
                }
                return String.format("<html>%s<br><font size=\"2\"><i>([%s])</i></font></html>", this.attrdesc.getName(), foreingKey.getTableName());
            }
            return super.getLabel();
        }

        public Element get(int index) {
            return this.getElements().get(index);
        }

        public int size() {
            return this.getElements().size();
        }

        public Iterator<Element> iterator() {
            return this.getElements().iterator();
        }

        public void addElement(Element element) {
        }

        public void addElement(Function function) {
        }

        public List<Element> getElements() {
            if (this.elements == null) {
                this.elements = new ArrayList<Element>();
                List<FeatureAttributeTreeModel.Node> children = this.node.getChildren();
                for (FeatureAttributeTreeModel.Node child : children) {
                    FeatureAttributeDescriptor theAttrdesc = (FeatureAttributeDescriptor)child.getValue();
                    FeatureAttributeElement e = theAttrdesc.isForeingKey() ? new ForeingKeyElement((Element)this, child, this.useHostVariable) : new FeatureAttributeElement((Element)this, child.getFeatureStore(), theAttrdesc, this.useHostVariable);
                    e.setConfig(this.getConfig());
                    this.elements.add((Element)e);
                }
            }
            return this.elements;
        }

        public Element setConfig(ExpressionBuilderConfig config) {
            super.setConfig(config);
            if (this.elements != null) {
                for (Element element : this.elements) {
                    element.setConfig(config);
                }
            }
            return this;
        }

        public void dispose() {
            super.dispose();
            if (this.elements != null) {
                for (Element element : this.elements) {
                    DisposeUtils.disposeQuietly((Disposable)element);
                }
                this.elements.clear();
            }
        }
    }
}

