/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featurequery;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.featurequery.FeatureQueryCalculatedColumnsPanel;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypeAttributePanel;
import org.gvsig.fmap.dal.swing.impl.featurequery.DefaultFeatureQueryCalculatedColumnsPanelView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.DataTypePickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureQueryCalculatedColumnsPanel
extends DefaultFeatureQueryCalculatedColumnsPanelView
implements FeatureQueryCalculatedColumnsPanel {
    private ColumnController columnController = null;
    private FeatureStore store;
    private FeatureType featureType;
    private FeatureQuery query;
    private static final String COLUMN_DEFAULT_NAME = "Field";
    private EditableFeatureAttributeDescriptor actualEditableAttribute;
    private DefaultListModel lstAttributesModel;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureQueryCalculatedColumnsPanel.class);

    public DefaultFeatureQueryCalculatedColumnsPanel() {
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public void setStore(FeatureStore store) {
        try {
            this.featureType = store.getDefaultFeatureType();
            this.store = store;
            this.query = store.createFeatureQuery();
            this.columnController.setStore(store);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't assign store", ex);
        }
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        ImageIcon icon = theme.get("picker-datatype");
        this.btnColumnDataType.setIcon(icon);
        toolsSwingManager.translate(this.lblExpression);
        toolsSwingManager.translate(this.lblName);
        toolsSwingManager.translate(this.lblType);
        toolsSwingManager.translate(this.lblSize);
        toolsSwingManager.translate(this.lblPrecision);
        toolsSwingManager.translate(this.lblScale);
        toolsSwingManager.translate((AbstractButton)this.btnApplyChanges);
        toolsSwingManager.translate((AbstractButton)this.btnColumnMore);
        this.columnController = new ColumnController(this.txtColumnName, this.cboColumnDataType, this.btnColumnDataType, this.txtColumnExpression, this.btnColumnExpression, this.btnColumnExpressionHistory, this.btnColumnExpressionBookmarks, this.txtColumnSize, this.txtColumnPrecision, this.txtColumnScale, this.btnApplyChanges, this.btnColumnMore);
        this.lstAttributes.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doSelectAttribute();
        });
        Dimension sz = this.getPreferredSize();
        if (sz.width < 700) {
            sz.width = 700;
        }
        if (sz.height < 320) {
            sz.height = 320;
        }
        this.setPreferredSize(sz);
        this.lstAttributesModel = new DefaultListModel();
        this.lstAttributes.setModel(this.lstAttributesModel);
        this.lstAttributes.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (DefaultFeatureQueryCalculatedColumnsPanel.this.checkColumnControllerHasChangesWithUser()) {
                    super.setSelectionInterval(index0, index1);
                    DefaultFeatureQueryCalculatedColumnsPanel.this.doSelectAttribute();
                }
            }
        });
        this.btnAdd.addActionListener(e -> {
            if (this.checkColumnControllerHasChangesWithUser()) {
                this.doAdd();
            }
        });
        this.btnRemove.addActionListener(e -> this.doRemove());
        this.btnUp.addActionListener(e -> this.doUp(this.lstAttributes));
        this.btnDown.addActionListener(e -> this.doDown(this.lstAttributes));
        this.btnApplyChanges.addActionListener(e -> this.doApplyChanges());
        this.btnColumnMore.addActionListener(e -> this.doColumnMore());
    }

    private boolean checkColumnControllerHasChangesWithUser() {
        if (this.hasChanges()) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            String message = i18n.getTranslation("_Changes_has_not_been_saved_Are_you_sure_you_want_to_continue");
            String title = i18n.getTranslation("_Changes_not_saved");
            int r = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(message, title, 0, 3);
            if (r == 1) {
                return false;
            }
        }
        return true;
    }

    private void doColumnMore() {
        if (this.columnController == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        FeatureTypeAttributePanel panel = DALSwingLocator.getSwingManager().createFeatureTypeAttributePanel();
        panel.clean();
        panel.setFeatureType(this.featureType);
        panel.put((FeatureAttributeDescriptor)this.actualEditableAttribute);
        panel.setMode(100);
        Dialog dialog = winManager.createDialog(panel.asJComponent(), i18n.getTranslation("_Extra_column"), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() != 1) {
                return;
            }
            try {
                FeatureAttributeDescriptor prev = this.actualEditableAttribute.getCopy();
                panel.fetch(this.actualEditableAttribute);
                this.columnController.put(this.actualEditableAttribute);
                if (!prev.equals(this.actualEditableAttribute)) {
                    this.columnController.doHasChanges();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Problems updating feature descriptor.", (Throwable)ex);
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public boolean checkPanel(StringBuilder msg) {
        int r;
        I18nManager i18n = ToolsLocator.getI18nManager();
        return !this.hasChanges() || (r = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(i18n.getTranslation("_Changes_has_not_been_saved_Are_you_sure_you_want_to_continue"), i18n.getTranslation("_Changes_not_saved"), 0, 3)) != 1;
    }

    public boolean hasChanges() {
        return this.columnController.hasChanges();
    }

    private void doSelectAttribute() {
        ListElement selectedValue;
        int index = this.lstAttributes.getSelectedIndex();
        DefaultListModel model = this.lstAttributesModel;
        this.btnUp.setEnabled(index >= 1);
        this.btnDown.setEnabled(index >= 0 && index < this.lstAttributesModel.getSize() - 1);
        EditableFeatureAttributeDescriptor value = null;
        if (this.lstAttributes.getSelectedValue() != null && (selectedValue = (ListElement)this.lstAttributes.getSelectedValue()) != null) {
            value = (EditableFeatureAttributeDescriptor)selectedValue.getValue();
        }
        if (value == null) {
            this.columnController.clean();
            this.columnController.setEnabled(false);
            this.actualEditableAttribute = null;
        } else {
            this.actualEditableAttribute = value;
            this.columnController.setEnabled(true);
            this.columnController.put(value);
        }
    }

    public FeatureQuery fetch(FeatureQuery query) {
        if (this.hasChanges()) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            String message = i18n.getTranslation("_Changes_has_not_been_saved_Do_you_want_to_save_them_before_continue");
            String title = i18n.getTranslation("_Changes_not_saved");
            int r = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(message, title, 0, 3);
            if (r == 0) {
                this.doApplyChanges();
            }
        }
        if (query == null) {
            return this.query.getCopy();
        }
        this.query.getExtraColumn().clear();
        for (int i = 0; i < this.lstAttributesModel.getSize(); ++i) {
            ListElement element = (ListElement)this.lstAttributesModel.get(i);
            EditableFeatureAttributeDescriptor newExtraColumn = this.query.getExtraColumn().add(((EditableFeatureAttributeDescriptor)element.getValue()).getName(), ((EditableFeatureAttributeDescriptor)element.getValue()).getType());
            newExtraColumn.copyFrom((DynField)element.getValue());
        }
        query.copyFrom(this.query);
        return query;
    }

    public FeatureQuery fetch() {
        return this.fetch(null);
    }

    public void put(FeatureQuery query) {
        this.query.copyFrom(query);
        this.addExtraColumns(this.query);
    }

    private void addExtraColumns(FeatureQuery query) {
        List cols = query.getExtraColumn().getColumns();
        if (cols == null || cols.isEmpty()) {
            return;
        }
        for (EditableFeatureAttributeDescriptor col : cols) {
            AttributeListElement lf = new AttributeListElement((FeatureAttributeDescriptor)col);
            this.lstAttributesModel.addElement(lf);
        }
        if (this.lstAttributesModel.getSize() > 0) {
            this.lstAttributes.setSelectedIndex(0);
        }
    }

    public static void selfRegister() {
    }

    private void doAdd() {
        int id = 0;
        String newName = COLUMN_DEFAULT_NAME;
        while (this.checkIfValueExistInModel(newName, this.lstAttributesModel)) {
            newName = "Field_" + id;
            ++id;
        }
        EditableFeatureAttributeDescriptor newAttr = DALLocator.getDataManager().createFeatureAttributeDescriptor(newName, 8);
        if (newAttr.getDataType().supportSize()) {
            newAttr.setSize(newAttr.getDataType().getDefaultSize());
        }
        this.columnController.put(newAttr);
        this.columnController.setEnabled(true);
        this.lstAttributesModel.addElement(new AttributeListElement((FeatureAttributeDescriptor)newAttr));
        ListElement.setSelected((JList)this.lstAttributes, (Object)newAttr);
        this.lstAttributes.revalidate();
        this.lstAttributes.repaint();
        this.actualEditableAttribute = newAttr;
    }

    private boolean checkIfValueExistInModel(String name, ListModel<ListElement<EditableFeatureAttributeDescriptor>> model) {
        for (int i = 0; i < model.getSize(); ++i) {
            EditableFeatureAttributeDescriptor element = (EditableFeatureAttributeDescriptor)model.getElementAt(i).getValue();
            if (!StringUtils.equals((CharSequence)element.getLabel(), (CharSequence)name)) continue;
            return true;
        }
        return false;
    }

    private void doRemove() {
        int n;
        ThreadSafeDialogsManager dialogs;
        AttributeListElement selectedValue = (AttributeListElement)((Object)this.lstAttributes.getSelectedValue());
        if (selectedValue == null) {
            return;
        }
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)selectedValue.getValue();
        if (attr == null) {
            return;
        }
        boolean removeFromAggregateFunctions = false;
        boolean removeFromOrder = false;
        boolean removeFromGroupByColums = false;
        if (this.query.getAggregateFunctions().containsKey(attr.getName())) {
            dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            n = dialogs.confirmDialog("El campo '" + attr.getName() + "' se esta usando en una funcion de agregado. \u00bf Dese borrarlo igualmente ?", "Eliminar campo", 0, 3, "_FeatureQueryCalculatedColumns_remove_used_column");
            if (n != 0) {
                return;
            }
            n = dialogs.confirmDialog("\u00bf Desea eliminar la funcion de agregado donde se esta usando el campo '" + attr.getName() + "' ?", "Eliminar campo", 0, 3, "_FeatureQueryCalculatedColumns_remove_aggregate_function_when_remove_column");
            if (n == 0) {
                removeFromAggregateFunctions = true;
            } else {
                LOGGER.info("It has been decided not to delete the aggregate function of a deleted field");
            }
        }
        if (this.query.getGroupByColumns().contains(attr.getName())) {
            dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            n = dialogs.confirmDialog("El campo '" + attr.getName() + "' se esta usando como campo de agrupacion. \u00bf Dese borrarlo igualmente ?", "Eliminar campo", 0, 3, "_FeatureQueryCalculatedColumns_remove_used_column");
            if (n != 0) {
                return;
            }
            n = dialogs.confirmDialog("\u00bf Desea eliminar la agrupacion por el campo '" + attr.getName() + "' ?", "Eliminar campo", 0, 3, "_FeatureQueryCalculatedColumns_remove_group_by_column_when_remove_column");
            if (n == 0) {
                removeFromGroupByColums = true;
            } else {
                LOGGER.info("It has been decided not to delete the group by a deleted field");
            }
        }
        if (this.query.getOrder().contains(attr.getName())) {
            dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            n = dialogs.confirmDialog("El campo '" + attr.getName() + "' se esta usando para establecer el orden. \u00bf Dese borrarlo igualmente ?", "Eliminar campo", 0, 3, "_FeatureQueryCalculatedColumns_remove_used_column");
            if (n != 0) {
                return;
            }
            n = dialogs.confirmDialog("\u00bf Desea eliminar el uso del campo '" + attr.getName() + "' en la ordenacion ?", "Eliminar campo", 0, 3, "_FeatureQueryCalculatedColumns_remove_order_when_remove_column");
            if (n == 0) {
                removeFromOrder = true;
            } else {
                LOGGER.info("It has been decided not to delete the order by a deleted field");
            }
        }
        if (removeFromAggregateFunctions) {
            this.query.removeAggregateFunction(attr.getName());
        }
        if (removeFromOrder) {
            int index = this.query.getOrder().getIndex(attr.getName());
            this.query.getOrder().remove(index);
        }
        if (removeFromGroupByColums) {
            this.query.removeGroupByColumn(attr.getName());
        }
        ListSelectionModel lsm = this.lstAttributes.getSelectionModel();
        DefaultListModel model = (DefaultListModel)this.lstAttributes.getModel();
        int actualIndex = lsm.getMinSelectionIndex();
        this.lstAttributesModel.removeElement((Object)selectedValue);
        this.columnController.clean();
        int size = model.size();
        if (size != 0 && model.getSize() != 0) {
            if (actualIndex >= model.getSize()) {
                this.lstAttributes.setSelectedIndex(model.getSize() - 1);
            } else {
                this.lstAttributes.setSelectedIndex(actualIndex);
            }
        }
    }

    private void doApplyChanges() {
        this.columnController.fetch(this.actualEditableAttribute);
        this.lstAttributes.invalidate();
        this.lstAttributes.repaint();
    }

    private void doUp(JList lstColumns) {
        int moveMe = lstColumns.getSelectedIndex();
        if (moveMe != 0) {
            this.swap(lstColumns, moveMe, moveMe - 1);
            lstColumns.setSelectedIndex(moveMe - 1);
            lstColumns.ensureIndexIsVisible(moveMe - 1);
        }
    }

    private void doDown(JList lstColumns) {
        int moveMe = lstColumns.getSelectedIndex();
        if (moveMe != lstColumns.getModel().getSize() - 1) {
            this.swap(lstColumns, moveMe, moveMe + 1);
            lstColumns.setSelectedIndex(moveMe + 1);
            lstColumns.ensureIndexIsVisible(moveMe + 1);
        }
    }

    private void swap(JList lstColumns, int a, int b) {
        DefaultListModel model = (DefaultListModel)lstColumns.getModel();
        Object aObject = model.getElementAt(a);
        Object bObject = model.getElementAt(b);
        model.set(a, bObject);
        model.set(b, aObject);
    }

    private class ColumnController
    implements DocumentListener,
    ChangeListener,
    ActionListener {
        private final JTextComponent txtName;
        private final JComboBox cboDataType;
        private final JButton btnDataType;
        private final JButton btnExpressionBookmarks;
        private final JButton btnExpressionHistory;
        private final JButton btnExpression;
        private final JTextComponent txtExpression;
        private ExpressionPickerController expPicker;
        private DataTypePickerController pickerDataType;
        private boolean hasChanges;
        private final JTextComponent txtSize;
        private final JTextComponent txtPrecision;
        private final JTextComponent txtScale;
        private final Logger LOGGER = LoggerFactory.getLogger(ColumnController.class);
        private final JButton btnColumnMore;
        private final JButton btnApplyChanges;

        public ColumnController(JTextComponent txtName, JComboBox cboDataType, JButton btnDataType, JTextComponent txtExpression, JButton btnExpression, JButton btnExpressionHistory, JButton btnExpressionBookmarks, JTextComponent txtSize, JTextComponent txtPrecision, JTextComponent txtScale, JButton btnApplyChanges, JButton btnColumnMore) {
            this.txtName = txtName;
            this.cboDataType = cboDataType;
            this.btnDataType = btnDataType;
            this.txtExpression = txtExpression;
            this.btnExpression = btnExpression;
            this.btnExpressionHistory = btnExpressionHistory;
            this.btnExpressionBookmarks = btnExpressionBookmarks;
            this.txtSize = txtSize;
            this.txtPrecision = txtPrecision;
            this.txtScale = txtScale;
            this.btnApplyChanges = btnApplyChanges;
            this.btnColumnMore = btnColumnMore;
            this.hasChanges = false;
            this.initComponents();
            this.setEnabled(false);
        }

        public void initComponents() {
            this.pickerDataType = ToolsSwingLocator.getToolsSwingManager().createDataTypePickerController(this.cboDataType, this.btnDataType, false);
            ExpressionEvaluatorSwingManager managerExpSwing = ExpressionEvaluatorSwingLocator.getManager();
            this.expPicker = managerExpSwing.createExpressionPickerController(this.txtExpression, this.btnExpression, this.btnExpressionBookmarks, this.btnExpressionHistory);
            this.txtName.getDocument().addDocumentListener(this);
            this.cboDataType.addActionListener(this);
            this.txtExpression.getDocument().addDocumentListener(this);
            this.txtSize.getDocument().addDocumentListener(this);
            this.txtPrecision.getDocument().addDocumentListener(this);
            this.txtScale.getDocument().addDocumentListener(this);
            this.cboDataType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ColumnController.this.doSetDefaultValuesForDataType();
                    ColumnController.this.doEnabledByDataType();
                }
            });
        }

        public void doEnabledByDataType() {
            JComboBox comboBox = this.cboDataType;
            if (comboBox.getSelectedItem() == null) {
                return;
            }
            DataType dataType = (DataType)comboBox.getSelectedItem();
            this.txtSize.setEnabled(dataType.supportSize());
            this.txtPrecision.setEnabled(dataType.supportPrecision());
            this.txtScale.setEnabled(dataType.supportScale());
        }

        public void doSetDefaultValuesForDataType() {
            if (this.cboDataType.getSelectedItem() == null) {
                return;
            }
            DataType dataType = (DataType)this.cboDataType.getSelectedItem();
            if (dataType.supportSize() && this.txtSize.getText().isEmpty()) {
                this.txtSize.setText(String.valueOf(dataType.getDefaultSize()));
            } else if (!dataType.supportSize()) {
                this.txtSize.setText("");
            }
            if (dataType.supportPrecision() && this.txtPrecision.getText().isEmpty()) {
                this.txtPrecision.setText(String.valueOf(dataType.getDefaultPrecision()));
            } else if (!dataType.supportPrecision()) {
                this.txtPrecision.setText("");
            }
            if (dataType.supportScale() && this.txtScale.getText().isEmpty()) {
                this.txtScale.setText(String.valueOf(dataType.getDefaultScale()));
            } else if (!dataType.supportScale()) {
                this.txtScale.setText("");
            }
        }

        public boolean hasChanges() {
            return this.hasChanges;
        }

        public void setEnabled(boolean enabled) {
            this.txtName.setEnabled(enabled);
            this.expPicker.setEnabled(enabled);
            this.cboDataType.setEnabled(enabled);
            this.txtSize.setEnabled(enabled);
            this.txtPrecision.setEnabled(enabled);
            this.txtScale.setEnabled(enabled);
            this.btnApplyChanges.setEnabled(enabled);
            this.btnColumnMore.setEnabled(enabled);
        }

        public void clean() {
            this.txtName.setText("");
            this.expPicker.set(null);
            this.cboDataType.setSelectedIndex(0);
            this.txtSize.setText("");
            this.txtPrecision.setText("");
            this.txtScale.setText("");
            this.btnApplyChanges.setEnabled(false);
            this.btnColumnMore.setEnabled(false);
            this.hasChanges = false;
        }

        public void put(EditableFeatureAttributeDescriptor attr) {
            this.clean();
            this.txtName.setText(attr.getName());
            FeatureAttributeEmulatorExpression emu = (FeatureAttributeEmulatorExpression)attr.getFeatureAttributeEmulator();
            if (emu != null) {
                try {
                    this.expPicker.set((Object)emu.getExpression().clone());
                }
                catch (CloneNotSupportedException ex) {
                    this.LOGGER.warn("Not able to clone expression.", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            this.pickerDataType.set((Object)attr.getDataType());
            Coercion coerceString = ToolsLocator.getDataTypesManager().get(8).getCoercion();
            this.txtSize.setEnabled(attr.getDataType().supportSize());
            if (attr.getDataType().supportSize()) {
                try {
                    this.txtSize.setText((String)coerceString.coerce((Object)attr.getSize()));
                }
                catch (CoercionException ex) {
                    this.LOGGER.warn("Not able to coerce text to integer from size box.", (Throwable)ex);
                }
            }
            this.txtPrecision.setEnabled(attr.getDataType().supportPrecision());
            if (attr.getDataType().supportPrecision()) {
                try {
                    this.txtPrecision.setText((String)coerceString.coerce((Object)attr.getPrecision()));
                }
                catch (CoercionException ex) {
                    this.LOGGER.warn("Not able to coerce text to integer from precision box.", (Throwable)ex);
                }
            }
            this.txtScale.setEnabled(attr.getDataType().supportScale());
            if (attr.getDataType().supportScale()) {
                try {
                    this.txtScale.setText((String)coerceString.coerce((Object)attr.getScale()));
                }
                catch (CoercionException ex) {
                    this.LOGGER.warn("Not able to coerce text to integer from scale box.", (Throwable)ex);
                }
            }
            this.btnColumnMore.setEnabled(true);
            this.btnApplyChanges.setEnabled(false);
            this.hasChanges = false;
        }

        public EditableFeatureAttributeDescriptor fetch(EditableFeatureAttributeDescriptor attr) {
            attr.setName(this.txtName.getText());
            try {
                Expression exp = this.expPicker.get();
                if (exp != null) {
                    attr.setFeatureAttributeEmulator(exp.clone());
                } else {
                    attr.setFeatureAttributeEmulator((Expression)null);
                }
            }
            catch (CloneNotSupportedException ex) {
                this.LOGGER.warn("Not able to clone expression.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            attr.setDataType((DataType)this.pickerDataType.get());
            Coercion coerceInteger = ToolsLocator.getDataTypesManager().get(4).getCoercion();
            try {
                if (attr.getDataType().supportSize()) {
                    attr.setSize(((Integer)coerceInteger.coerce((Object)this.txtSize.getText())).intValue());
                }
            }
            catch (CoercionException ex) {
                this.LOGGER.warn("Not able to coerce text to integer from size box.", (Throwable)ex);
            }
            try {
                if (attr.getDataType().supportPrecision()) {
                    attr.setPrecision(((Integer)coerceInteger.coerce((Object)this.txtPrecision.getText())).intValue());
                }
            }
            catch (CoercionException ex) {
                this.LOGGER.warn("Not able to coerce text to integer from precision box.", (Throwable)ex);
            }
            try {
                if (attr.getDataType().supportScale()) {
                    attr.setScale(((Integer)coerceInteger.coerce((Object)this.txtScale.getText())).intValue());
                }
            }
            catch (CoercionException ex) {
                this.LOGGER.warn("Not able to coerce text to integer from scale box.", (Throwable)ex);
            }
            this.hasChanges = false;
            this.btnColumnMore.setEnabled(true);
            this.btnApplyChanges.setEnabled(false);
            return attr;
        }

        private void doHasChanges() {
            this.btnColumnMore.setEnabled(false);
            this.btnApplyChanges.setEnabled(true);
            this.hasChanges = true;
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.doHasChanges();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.doHasChanges();
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            this.doHasChanges();
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.doHasChanges();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.doHasChanges();
        }

        public void setStore(FeatureStore store) {
            DALSwingLocator.getManager().configureExpressionBuilder(this.expPicker.getConfig(), store);
        }
    }

    private class AttributeListElement
    extends ListElement<FeatureAttributeDescriptor> {
        public AttributeListElement(FeatureAttributeDescriptor value) {
            super(value.getLabel(), (Object)value);
        }

        public String getLabel() {
            return ((FeatureAttributeDescriptor)this.getValue()).getName();
        }
    }
}

