/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featurequery;

import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featurequery.FeatureQueryPickerController;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class DefaultFeatureQueryPickerController
extends AbstractPickerController<FeatureQuery>
implements FeatureQueryPickerController {
    private final JButton button;
    private final JTextComponent text;
    private FeatureStore store;
    private SearchParameters panelParams;

    public DefaultFeatureQueryPickerController(JTextComponent text, JButton button) {
        this(text, button, null, null);
    }

    public DefaultFeatureQueryPickerController(JTextComponent text, JButton button, JButton btnHistory, JButton btnBookmarks) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.text = text == null ? new JTextField() : text;
        this.text.setEditable(false);
        this.button = button;
        this.button.setCursor(Cursor.getPredefinedCursor(12));
        this.button.setIcon(this.getIcon("common-filter"));
        if (this.button.getText().equals("...")) {
            this.button.setText("");
        }
        if (StringUtils.isBlank((CharSequence)this.button.getToolTipText())) {
            this.button.setToolTipText(i18n.getTranslation("_Query_dialog"));
        }
        for (ActionListener l : this.button.getActionListeners()) {
            this.button.removeActionListener(l);
        }
        this.button.addActionListener(e -> this.doShowDialog());
        this.panelParams = dataSwingManager.createFeatureStoreSearchPanelParameters();
    }

    public void setStore(FeatureStore store) {
        if (this.store != null) {
            DisposeUtils.disposeQuietly((Disposable)this.store);
            this.store = null;
        }
        this.store = store;
        if (this.store != null) {
            DisposeUtils.bind((Disposable)this.store);
        }
        this.panelParams.clear();
    }

    public FeatureQuery get() {
        return this.panelParams.getQuery();
    }

    public void set(FeatureQuery query) {
        FeatureQueryOrder orderBy;
        List groupBy;
        this.panelParams.setQuery(query);
        if (query == null) {
            this.text.setText("");
            return;
        }
        StringBuilder builder = new StringBuilder();
        Expression filter = query.getExpressionFilter();
        if (!ExpressionUtils.isEmpty((Expression)filter)) {
            builder.append(filter.getPhrase());
            builder.append(" ");
        }
        if (CollectionUtils.isNotEmpty((Collection)(groupBy = query.getGroupByColumns()))) {
            builder.append("GROUP BY ");
            boolean first = true;
            for (String colname : groupBy) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("\"");
                builder.append(colname);
                builder.append("\"");
            }
            builder.append(" ");
        }
        if (!(orderBy = query.getOrder()).isEmpty()) {
            builder.append("ORDER BY ");
            boolean first = true;
            for (FeatureQueryOrder.FeatureQueryOrderMember col : orderBy) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("\"");
                builder.append(col.getAttributeName());
                builder.append("\"");
                if (col.getAscending()) {
                    builder.append(" ASC");
                    continue;
                }
                builder.append(" DESC");
            }
            builder.append(" ");
        }
        this.text.setText(builder.toString());
    }

    public void coerceAndSet(Object query) {
        if (query instanceof FeatureQuery) {
            this.set((FeatureQuery)query);
            return;
        }
        this.set(null);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    private void doShowDialog() {
        SearchParameters params;
        if (this.store == null) {
            return;
        }
        try {
            params = (SearchParameters)this.panelParams.clone();
        }
        catch (Exception ex) {
            LOG.warn("Can't show dialog", (Throwable)ex);
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        FeatureStoreSearchPanel panel = dataSwingManager.createFeatureStoreSearchPanel(this.store);
        panel.setFilterOnlyMode(true);
        panel.setGroupByEnabled(true);
        panel.put(params);
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog(panel.asJComponent(), i18n.getTranslation("_Filter") + ": " + this.store.getName(), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                panel.fetch(this.panelParams);
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public static void selfRegister() {
    }
}

