/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.paging.FacadeOfAFeaturePagingHelper;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.featuretable.SimpleFeaturesTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFeaturesTableModelImpl
extends AbstractTableModel
implements SimpleFeaturesTableModel {
    private static final String TAG_FEATURETABLEMODEL_IMAGE_WIDTH = "featuretablemodel.image.width";
    private static final String TAG_FEATURETABLEMODEL_IMAGE_HEIGHT = "featuretablemodel.image.height";
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFeaturesTableModelImpl.class);
    private List<Feature> features;
    private final List<String> columnNames;
    private final FeatureType featureType;
    private FilteredLogger logger = new FilteredLogger(LOGGER, "SimpleFeaturesTableModel", 10);
    private boolean errors;

    public SimpleFeaturesTableModelImpl(FeatureStore store) throws DataException {
        this(store.getDefaultFeatureType(), null, store.getFeatures());
    }

    public SimpleFeaturesTableModelImpl(FeatureStore store, Expression filter) throws DataException {
        this(store.getDefaultFeatureType(), null, store.getFeatures(filter));
    }

    public SimpleFeaturesTableModelImpl(FeatureType featureType) {
        this(featureType, null, null);
        this.logger = new FilteredLogger(LOGGER, "SimpleFeaturesTableModel", 10);
    }

    public SimpleFeaturesTableModelImpl(FeatureType featureType, List<String> columnNames, List<Feature> features) {
        this.features = features;
        this.featureType = featureType;
        this.errors = false;
        if (columnNames == null || columnNames.isEmpty()) {
            this.columnNames = new ArrayList<String>();
            Search search = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)featureType);
            List attributos = search.getOrderedAttributes(Search.BASIC_TYPES_FILTER, Search.STR_INT_LONG_LABEL_ORDER, 12);
            for (Search.OrderedAttribute attrdesc : attributos) {
                this.columnNames.add(attrdesc.getDescriptor().getName());
            }
        } else {
            this.columnNames = columnNames;
        }
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    private int getColumnHeaderWidth(JTable table, TableColumn tableColumn) {
        String value = Objects.toString(tableColumn.getHeaderValue());
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        JComponent c = (JComponent)renderer.getTableCellRendererComponent(table, value, false, false, -1, tableColumn.getModelIndex());
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        int w = fm.stringWidth(value);
        Insets insets = c.getInsets(null);
        int dx = insets.left + insets.right;
        return w + dx;
    }

    public void setCellRenderers(JTable table) {
        this.setCellRenderers(table, Collections.EMPTY_MAP);
    }

    public void setCellRenderers(JTable table, Map<String, TableCellRenderer> renderers) {
        TableColumn columnModel;
        if (table.getModel() != this) {
            return;
        }
        table.setAutoResizeMode(0);
        DefaultTableColumnModel columnsModel = new DefaultTableColumnModel();
        int n = 0;
        I18nManager i18n = ToolsLocator.getI18nManager();
        FeatureAttributeDescriptor descriptor = null;
        for (String columnName : this.columnNames) {
            try {
                descriptor = this.featureType.getAttributeDescriptor(columnName);
                if (descriptor == null) {
                    descriptor = this.featureType.getExtraColumns().get(columnName);
                }
                columnModel = new TableColumn();
                columnModel.setModelIndex(n);
                columnModel.setHeaderValue(DALSwingLocator.getDataSwingManager().getAttributeDescriptorLabel(descriptor));
                TableCellRenderer renderer = renderers.get(columnName);
                if (renderer == null) {
                    renderer = new FeatureAttributeCellRenderer(descriptor);
                }
                columnModel.setCellRenderer(renderer);
                if (descriptor.getDisplaySize() > 0) {
                    int displaySize = ToolsSwingUtils.cols2px((int)descriptor.getDisplaySize());
                    columnModel.setPreferredWidth(displaySize);
                }
                columnsModel.addColumn(columnModel);
                ++n;
            }
            catch (Exception ex) {
                throw new RuntimeException("Not able to get type of descriptor for column", ex);
            }
        }
        if (descriptor != null && descriptor.getType() == 8) {
            table.getTableHeader().setResizingColumn(columnsModel.getColumn(n - 1));
        }
        table.setColumnModel(columnsModel);
        n = 0;
        for (String columnName : this.columnNames) {
            try {
                descriptor = this.featureType.getAttributeDescriptor(columnName);
                if (descriptor == null) {
                    descriptor = this.featureType.getExtraColumns().get(columnName);
                }
                columnModel = columnsModel.getColumn(n);
                if (descriptor.getDisplaySize() <= 0) {
                    columnModel.setPreferredWidth(this.getColumnHeaderWidth(table, columnModel));
                }
                ++n;
            }
            catch (Exception ex) {
                throw new RuntimeException("Not able to get type of descriptor for column", ex);
            }
        }
        table.setColumnModel(columnsModel);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void dispose() {
        if (this.features != null) {
            if (this.features instanceof FacadeOfAFeaturePagingHelper) {
                DisposeUtils.disposeQuietly((Disposable)((FacadeOfAFeaturePagingHelper)this.features).getFeaturePagingHelper());
            } else {
                DisposeUtils.disposeQuietly(this.features);
            }
            this.features = null;
        }
        this.features = null;
    }

    @Override
    public int getRowCount() {
        if (this.getFeatures() == null) {
            return 0;
        }
        try {
            return this.getFeatures().size();
        }
        catch (Throwable ex) {
            this.errors = true;
            LOGGER.warn("Can't calculate row count.", ex);
            return 0;
        }
    }

    public boolean hasErrors() {
        return this.errors;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String attrName = this.columnNames.get(columnIndex);
        if (this.featureType == null) {
            return attrName;
        }
        FeatureAttributeDescriptor attrdesc = this.featureType.getAttributeDescriptor(attrName);
        if (attrdesc == null) {
            EditableFeatureAttributeDescriptor extraCol = this.featureType.getExtraColumns().get(attrName);
            if (extraCol != null) {
                return extraCol.getLocalizedShortLabel();
            }
            if (attrName == null) {
                return "Column" + columnIndex;
            }
            return attrName;
        }
        return attrdesc.getLocalizedShortLabel();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.featureType == null) {
            return String.class;
        }
        try {
            int extraIndex;
            String attrName = this.columnNames.get(columnIndex);
            FeatureAttributeDescriptor attrdesc = this.featureType.getAttributeDescriptor(attrName);
            if (attrdesc == null && (extraIndex = this.featureType.getExtraColumns().getIndexOf(attrName)) != -1) {
                attrdesc = this.featureType.getExtraColumns().get(extraIndex);
            }
            if (attrdesc == null) {
                return String.class;
            }
            if (attrdesc.isForeingKey() && attrdesc.getForeingKey().isClosedList()) {
                return String.class;
            }
            Class theClass = attrdesc.getDataType().getDefaultClass();
            if (theClass == null) {
                return String.class;
            }
            return theClass;
        }
        catch (Exception ex) {
            return String.class;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public FeatureAttributeDescriptor getFeatureDescriptor(int columnIndex) {
        String attrName = this.columnNames.get(columnIndex);
        if (this.featureType == null) {
            return null;
        }
        for (FeatureAttributeDescriptor attr : this.featureType.getAllAttributeDescriptors()) {
            if (!StringUtils.equals((CharSequence)attrName, (CharSequence)attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public Feature get(int position) {
        if (this.getFeatures() == null) {
            return null;
        }
        Feature feature = this.getFeatures().get(position);
        return feature;
    }

    public Feature getFeatureAt(int rowIndex) {
        if (this.getFeatures() == null || rowIndex < 0) {
            return null;
        }
        try {
            Feature feature = this.getFeatures().get(rowIndex);
            return feature;
        }
        catch (Throwable th) {
            this.errors = true;
            this.logger.warn("Can't get feature at row " + rowIndex + ".", th);
            return null;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getFeatures() == null) {
            return null;
        }
        try {
            Feature feature = this.getFeatures().get(rowIndex);
            return this.getValueAt(feature, columnIndex);
        }
        catch (Throwable th) {
            this.errors = true;
            this.logger.warn("Can't get cell value at " + rowIndex + ", " + columnIndex + ".", th);
            return null;
        }
    }

    public Object getValueAt(Feature feature, int columnIndex) {
        String attrName = this.columnNames.get(columnIndex);
        Object value = null;
        value = feature.get(attrName);
        FeatureAttributeDescriptor attrdesc = this.featureType.getAttributeDescriptor(attrName);
        if (attrdesc == null && this.featureType.getExtraColumns().get(attrName) != null) {
            attrdesc = this.featureType.getExtraColumns().get(attrName);
        }
        if (attrdesc != null) {
            if (value == null) {
                return null;
            }
            if (attrdesc.isForeingKey() && attrdesc.getForeingKey().isClosedList()) {
                value = attrdesc.getForeingKey().getLabelForValue(value);
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public List<Feature> toList() {
        return this.getFeatures();
    }

    public boolean isEmpty() {
        return this.getFeatures().isEmpty();
    }

    public int size() {
        return this.getFeatures().size();
    }

    public Iterator<Feature> iterator() {
        return this.getFeatures().iterator();
    }

    public static void selfRegister() {
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        dynObjectManager.registerTag(TAG_FEATURETABLEMODEL_IMAGE_HEIGHT, "Height to use when images have to be represented in a table, by default 48.");
        dynObjectManager.registerTag(TAG_FEATURETABLEMODEL_IMAGE_WIDTH, "Width to use when images have to be represented in a table, by default 48.");
    }

    public Expression getFeaturesFilter(int[] rows) {
        if (ArrayUtils.isEmpty((int[])rows)) {
            return null;
        }
        ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
        for (int row : rows) {
            ExpressionBuilder filter;
            Feature feature = this.getFeatureAt(row);
            if (feature == null || (filter = feature.createBuilderFilter()) == null) continue;
            builder.or(filter.value());
        }
        if (builder.value() == null) {
            return null;
        }
        Expression filter = ExpressionUtils.createExpression((String)builder.toString());
        return filter;
    }

    private static class FeatureAttributeCellRenderer
    extends DefaultTableCellRenderer {
        private final FeatureAttributeDescriptor descriptor;
        private final JCheckBox check;

        public FeatureAttributeCellRenderer(FeatureAttributeDescriptor descriptor) {
            this.descriptor = descriptor;
            this.check = new JCheckBox();
            this.check.setHorizontalAlignment(0);
            this.check.setBackground(UIManager.getColor("Table.background"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setText("");
            label.setIcon(null);
            int type = this.descriptor.getType();
            if (value instanceof Boolean && type == 1) {
                this.check.setSelected((Boolean)value);
                this.check.setBackground(label.getBackground());
                return this.check;
            }
            if (type == 12) {
                ImageIcon icon;
                Tags tags;
                DataProfile profile;
                SimpleImage image;
                label.setText("(binary)");
                label.setHorizontalAlignment(0);
                if (value == null) {
                    label.setText("null");
                } else if (value instanceof SimpleImage) {
                    SimpleImage image2 = (SimpleImage)value;
                    Tags tags2 = this.descriptor.getTags();
                    ImageIcon icon2 = this.createImageIcon(tags2, image2);
                    if (icon2 != null) {
                        label.setIcon(icon2);
                        label.setText("");
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"image", (CharSequence)this.descriptor.getDataProfileName()) && (image = (SimpleImage)(profile = this.descriptor.getDataProfile()).createData(value, tags = this.descriptor.getTags())) != null && (icon = this.createImageIcon(tags, image)) != null) {
                    label.setIcon(icon);
                    label.setText("");
                }
            } else {
                label.setText(this.descriptor.format(value));
                if (this.descriptor.getAvailableValues() == null && (this.descriptor.getDataType().isNumeric() || type == 11 || type == 10 || type == 9)) {
                    label.setHorizontalAlignment(4);
                } else if (type == 1) {
                    label.setHorizontalAlignment(0);
                    label.setText("null");
                } else {
                    label.setHorizontalAlignment(2);
                }
            }
            return label;
        }

        public FeatureAttributeDescriptor getDescriptor() {
            return this.descriptor;
        }

        private ImageIcon createImageIcon(Tags tags, SimpleImage image) {
            if (image == null) {
                return null;
            }
            try {
                int h = tags.getInt(SimpleFeaturesTableModelImpl.TAG_FEATURETABLEMODEL_IMAGE_HEIGHT, 16);
                int w = tags.getInt(SimpleFeaturesTableModelImpl.TAG_FEATURETABLEMODEL_IMAGE_WIDTH, image.getWidth() * h / image.getHeight());
                image = image.resize(w, h);
                if (image == null) {
                    return null;
                }
                BufferedImage bufferedImage = image.getBufferedImage();
                if (bufferedImage == null) {
                    return null;
                }
                return new ImageIcon(bufferedImage);
            }
            catch (Throwable t) {
                LOGGER.debug("Can't create image", t);
                return null;
            }
        }
    }

    public static class ColorRangeRenderer
    extends FeatureAttributeCellRenderer {
        private final double max;
        private final double min;

        public ColorRangeRenderer(FeatureAttributeDescriptor descriptor, double min, double max) {
            super(descriptor);
            this.min = min;
            this.max = max;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.getDescriptor().getDataType().isNumeric()) {
                double myvalue = 0.0;
                myvalue = value == null ? 0.0 : DataTypeUtils.toDouble((Object)value);
                Color color = this.getColor(myvalue);
                label.setBackground(color);
            }
            return label;
        }

        public Color getColor(double n) {
            Color color;
            if (n <= this.min) {
                n = 0.0;
            } else if (n >= this.max) {
                n = this.max - this.min;
            }
            int per = DataTypeUtils.toInteger((Object)(100.0 * (n - this.min) / (this.max - this.min)));
            int R = 255 * per / 100;
            int G = 255 * (100 - per) / 100;
            int B = 0;
            try {
                color = new Color(R, G, B, 100);
            }
            catch (Exception ex) {
                color = Color.GRAY;
            }
            return color;
        }
    }
}

