/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable.table.renders;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.BitSet;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.gvsig.fmap.dal.swing.impl.featuretable.FeatureTable;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.notification.ColumnHeaderSelectionChangeNotification;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;

public class JToggleButtonHeaderCellRenderer
extends BaseWeakReferencingObservable
implements TableCellRenderer,
MouseListener {
    private BitSet selectedColumns = new BitSet();
    private JToggleButton button;
    private FeatureTable table;

    public JToggleButtonHeaderCellRenderer(FeatureTable table) {
        this.table = table;
        JTableHeader header = table.getTableHeader();
        header.addMouseListener(this);
        this.button = new JToggleButton();
        this.button.setMargin(new Insets(0, 0, 0, 0));
    }

    public int[] getSelectedColumns() {
        int[] columns = new int[this.selectedColumns.cardinality()];
        int pos = 0;
        int i = this.selectedColumns.nextSetBit(0);
        while (i >= 0) {
            columns[pos] = i;
            ++pos;
            i = this.selectedColumns.nextSetBit(i + 1);
        }
        return columns;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int columnModel = table.convertColumnIndexToModel(column);
        this.button.setText(table.getColumnName(column));
        this.button.setSelected(this.selectedColumns.get(columnModel));
        return this.button;
    }

    public void deselectAll() {
        this.selectedColumns.clear();
        this.notifyObservers(new ColumnHeaderSelectionChangeNotification(this.table));
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int columnViewIndex;
        JTable jtable = ((JTableHeader)event.getSource()).getTable();
        if (jtable.equals(this.table) && (columnViewIndex = this.table.columnAtPoint(event.getPoint())) >= 0) {
            int columnModelIndex = this.table.convertColumnIndexToModel(columnViewIndex);
            if (this.ctrlKeyPressed(event)) {
                this.reverseSelection(columnModelIndex);
            } else {
                this.setSelection(columnModelIndex);
            }
            this.table.fireColumnSelection(new ActionEvent(this.table, 1, "ColumnSelection"));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private boolean ctrlKeyPressed(MouseEvent event) {
        int ctrlDownMask = 128;
        return (event.getModifiersEx() & 0x80) == 128;
    }

    private void setSelection(int column) {
        this.selectedColumns.clear();
        this.selectedColumns.set(column);
        this.notifyObservers(new ColumnHeaderSelectionChangeNotification(this.table));
    }

    private void reverseSelection(int column) {
        this.selectedColumns.flip(column);
        this.notifyObservers(new ColumnHeaderSelectionChangeNotification(this.table));
    }
}

