/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.AttributesLayoutPanelView;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.DefaultAggregateController;
import org.gvsig.fmap.dal.swing.impl.featuretype.availablevalues.AvailableValuesController;
import org.gvsig.fmap.dal.swing.impl.featuretype.availablevalues.AvailableValuesItemController;
import org.gvsig.fmap.dal.swing.impl.featuretype.availablevalues.AvailableValuesModel;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.Tag;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.TagItemController;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.TagsModel;
import org.gvsig.texteditor.JTextEditor;
import org.gvsig.texteditor.TextEditorManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;
import org.gvsig.tools.swing.api.documentfilters.PositiveIntegerDocumentFilter;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesLayoutPanel
extends AttributesLayoutPanelView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributesLayoutPanel.class);
    private FeatureType featureType;
    private FieldsInfo fields = null;
    private FieldInfo currentField = null;
    private FormInfo form;
    private DefaultAggregateController<Tag> tagsAttrController;
    private JListWithCheckbox lchkFieldDependentFields;
    private DefaultAggregateController<Tag> tagsFormController;
    private AvailableValuesController availableValuesController;
    private Map<String, String> codeEventsTemplates;
    private JSplitPane splFields1;
    private JSplitPane splFields2;
    private JTextEditor codeEditor;

    public AttributesLayoutPanel() {
        this.initCodeEventsTemplates();
        this.initComponents();
    }

    private void initCodeEventsTemplates() {
        this.codeEventsTemplates = new HashMap<String, String>();
        this.codeEventsTemplates.put("onSetvalues".toLowerCase(), "\nCREATE PROCEDURE form_onSetvalues form, values AS\nBEGIN\n  -- PRINT('form_onSetvalues');\n  PASS\nEND\n");
        this.codeEventsTemplates.put("onFieldEnter".toLowerCase(), "\nCREATE PROCEDURE form_onFieldEnter form, field AS\nBEGIN\n  -- PRINT('form_onFieldEnter ' || field.getName());\n  -- CASE\n  --   WHEN field.getName() = '?????' THEN\n  --       BEGIN\n  --       END\n  -- END\n  PASS\nEND\n");
        this.codeEventsTemplates.put("onFieldExit".toLowerCase(), "\nCREATE PROCEDURE form_onFieldExit form, field AS\nBEGIN\n  -- PRINT('form_onFieldExit ' || field.getName());\n  -- CASE\n  --   WHEN field.getName() = '?????' THEN\n  --       BEGIN\n  --       END\n  -- END\n  PASS\nEND\n");
        this.codeEventsTemplates.put("onFieldChanged".toLowerCase(), "\nCREATE PROCEDURE form_onFieldChanged form, field AS\nBEGIN\n  -- PRINT('form_onFieldChanged ' || field.getName());\n  -- CASE\n  --   WHEN field.getName() = '?????' THEN\n  --       BEGIN\n  --       END\n  -- END\n  PASS;\nEND\n");
        this.codeEventsTemplates.put("validate".toLowerCase(), "\nCREATE FUNCTION form_validate form AS\nBEGIN\n  -- PRINT('form_validate');\n  RETURN TRUE;\nEND\n");
        this.codeEventsTemplates.put("onLoad".toLowerCase(), "\nCREATE PROCEDURE form_onLoad form AS\nBEGIN\n  -- PRINT('form_onLoad');\n  PASS;\nEND\n");
        this.codeEventsTemplates.put("clear".toLowerCase(), "\nCREATE PROCEDURE form_clear form AS\nBEGIN\n  -- PRINT('form_clear');\n  PASS;\nEND\n");
        this.codeEventsTemplates.put("clear".toLowerCase(), "\nCREATE FUNCTION form_isReadOnly form AS\nBEGIN\n  -- PRINT('form_isReadOnly');\n  RETURN FALSE;\nEND\n");
        this.codeEventsTemplates.put("compute_click".toLowerCase(), "\nCREATE PROCEDURE ${FIELDNAME}_compute_click form, field AS\n  -- PRINT('${FIELDNAME}_compute_click');\n  -- feature := form.getContext().getCurrentFeature();\n  PASS;\nEXCEPT\n  PASS;\nEND\n");
        this.codeEventsTemplates.put("compute_click".toLowerCase(), "\nCREATE PROCEDURE ${FIELDNAME}_compute_click form, field AS\n  -- PRINT('${FIELDNAME}_compute_click');\n  -- feature := form.getContext().getCurrentFeature();\n  PASS;\nEXCEPT\n  PASS;\nEND\n");
        this.codeEventsTemplates.put("compute_config".toLowerCase(), "\nCREATE PROCEDURE ${FIELDNAME}_compute_config form, field AS\n  -- PRINT('${FIELDNAME}_compute_config');\n  RETURN to_json( {\n    'enabled': true,\n    'tip': NULL\n  } );\nEND\n");
    }

    private String getCodeEventTemplate(String event) {
        String template = this.codeEventsTemplates.get(event.toLowerCase());
        return template;
    }

    private String getCodeEventTemplate(String event, String fieldname) {
        String template = this.codeEventsTemplates.get(event.toLowerCase());
        template = StringUtils.replace((String)template, (String)"${FIELDNAME}", (String)fieldname);
        return template;
    }

    private void initComponents() {
        TextEditorManager textEditorManager = ToolsSwingLocator.getTextEditorManager();
        this.codeEditor = textEditorManager.createTextEditor();
        this.pnlCodeEditor.setLayout(new BorderLayout());
        this.pnlCodeEditor.add((Component)this.codeEditor.asJComponent(), "Center");
        this.codeEditor.setEnabled(false);
        this.splFields2 = ToolsSwingUtils.createHorizontalSplit((JPanel)this.gridFieldsRight, (JPanel)this.gridFieldsFields, (boolean)false, (JPanel)this.gridFieldDetail, (boolean)false);
        this.splFields1 = ToolsSwingUtils.createHorizontalSplit((JPanel)this.gridFields, (JPanel)this.gridFieldsGroups, (boolean)false, (JPanel)this.gridFieldsRight, (boolean)false);
        this.lstFieldGroups.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doChangeGroup();
        });
        this.lstFieldFields.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doChangeField();
        });
        this.btnFieldDown.addActionListener(e -> this.fields_down());
        this.btnFieldUp.addActionListener(e -> this.fields_up());
        this.btnFieldGroupAdd.addActionListener(e -> this.group_add());
        this.btnFieldGroupRemove.addActionListener(e -> this.group_remove());
        PositiveIntegerDocumentFilter.install((JTextField)this.txtFieldNumberOfRows);
        IntegerDocumentFilter.install((JTextField)this.txtFormWidth);
        IntegerDocumentFilter.install((JTextField)this.txtFormHeight);
        DefaultComboBoxModel<String> layoutComboModel = new DefaultComboBoxModel<String>();
        layoutComboModel.addElement("plain");
        layoutComboModel.addElement("tabs");
        layoutComboModel.addElement("separators");
        this.cboFormLayoutMode.setModel(layoutComboModel);
        this.tagsAttrController = new DefaultAggregateController<Tag>(this.tblAttrTagsItems, this.btnAttrTagsModify, this.btnAttrTagsDiscard, this.btnAttrTagsAccept, this.btnAttrTagsNew, this.btnAttrTagsDelete, new TagItemController(this.cboAttrTagsItemName, this.cboAttrTagsItemValue, this.lblAttrTagsItemNotesValue));
        this.tagsFormController = new DefaultAggregateController<Tag>(this.tblTagsItems, this.btnTagsModify, this.btnTagsDiscard, this.btnTagsAccept, this.btnTagsNew, this.btnTagsDelete, new TagItemController(this.cboTagsItemName, this.cboTagsItemValue, this.lblTagsItemNotesValue));
        this.availableValuesController = new AvailableValuesController(this.tblAvailableValuesItems, this.btnAvailableValuesModify, this.btnAvailableValuesDiscard, this.btnAvailableValuesAccept, this.btnAvailableValuesNew, this.btnAvailableValuesDelete, new AvailableValuesItemController(this.txtAvailableValuesItemLabel, this.txtAvailableValuesItemValue));
        this.spnFieldResizeWeight.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.lchkFieldDependentFields = ToolsSwingLocator.getToolsSwingManager().createJListWithCheckbox(this.lstFieldDependentFields);
        this.cboCodeComponent.addActionListener(e -> this.doCodeCompomentChanged());
        this.cboCodeEvents.addActionListener(e -> this.doCodeEventChanged());
        this.btnCodeGo.addActionListener(e -> this.doCodeGo());
        this.btnCodeCreate.addActionListener(e -> this.doCodeInsertTemplate());
        this.btnCargarRecurso.addActionListener(e -> this.doLoadResorce());
        this.btnGuardarRecurso.addActionListener(e -> this.doSaveResource());
    }

    public void put(FeatureType featureType) {
        try {
            this.fields = new FieldsInfo();
            for (FeatureAttributeDescriptor descriptor : featureType) {
                FieldInfo field = new FieldInfo(descriptor);
                this.fields.add(field);
            }
            this.form = new FormInfo(featureType.getLabel(), featureType.getTags());
            this.form_put(this.form);
            this.fields_put(this.fields);
            DefaultComboBoxModel<Object> componentsModel = new DefaultComboBoxModel<Object>();
            componentsModel.addElement(new LabeledValueImpl("<html><b>Form</b></html>", (Object)this.form));
            for (FieldInfo field : this.fields) {
                componentsModel.addElement(field);
            }
            this.cboCodeComponent.setModel(componentsModel);
            this.cboCodeEvents.setModel(new DefaultComboBoxModel());
            ListElement.setSelected((JComboBox)this.cboCodeComponent, (Object)this.form);
            this.featureType = featureType.getCopy();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't put values in the panel from the feature type", (Throwable)ex);
        }
    }

    public FeatureType fetch(EditableFeatureType featureType) {
        if (featureType == null) {
            featureType = this.featureType.getCopy().getEditable();
        }
        this.fields_fetch(this.fields);
        this.field_fetch(this.currentField);
        this.form_fetch(this.form);
        for (FieldInfo field : this.fields) {
            EditableFeatureAttributeDescriptor descriptor = featureType.getEditableAttributeDescriptor(field.name);
            descriptor.setLabel(field.label);
            descriptor.setOrder(field.order);
            descriptor.setHidden(field.hiden);
            descriptor.getTags().removeAll();
            descriptor.getTags().add(field.tags);
        }
        featureType.setLabel(this.form.label);
        featureType.getTags().removeAll();
        featureType.getTags().add(this.form.tags);
        return featureType;
    }

    private void form_put(FormInfo form) {
        this.cboFormLayoutMode.setSelectedItem(form.layoutMode);
        this.txtFormHeight.setText(String.valueOf(form.height));
        this.txtFormWidth.setText(String.valueOf(form.width));
        this.tagsFormController.setModel(new TagsModel(form.tags));
        this.chkFormReadonly.setSelected(form.readonly);
        this.chkFormUseScrollbars.setSelected(form.useScrollbars);
    }

    private void form_fetch(FormInfo form) {
        this.tagsFormController.getModel().fetch(form.tags);
        form.layoutMode = (String)this.cboFormLayoutMode.getSelectedItem();
        form.height = PositiveIntegerDocumentFilter.getValue((JTextField)this.txtFormHeight);
        form.width = PositiveIntegerDocumentFilter.getValue((JTextField)this.txtFormWidth);
        form.readonly = this.chkFormReadonly.isSelected();
        form.useScrollbars = this.chkFormUseScrollbars.isSelected();
        form.label = (String)StringUtils.defaultIfBlank((CharSequence)this.txtFormLabel.getText(), null);
        form.tags.set("dynform.layoutmode", (Object)form.layoutMode);
        form.tags.set("dynform.height", (Object)form.height);
        form.tags.set("dynform.width", (Object)form.width);
        form.tags.set("dynform.rows", (Object)form.readonly);
        form.tags.set("dynform.useScrollBars", (Object)form.useScrollbars);
    }

    private void doChangeField() {
        FieldInfo field = (FieldInfo)this.lstFieldFields.getSelectedValue();
        if (field == null) {
            return;
        }
        if (this.currentField != null) {
            this.field_fetch(this.currentField);
        }
        this.field_put(field);
    }

    private void fields_put(FieldsInfo fields) {
        fields.sort();
        DefaultComboBoxModel<String> groupComboModel = new DefaultComboBoxModel<String>();
        DefaultListModel<String> groupListModel = new DefaultListModel<String>();
        for (String group : fields.getGroups()) {
            groupListModel.addElement(group);
            groupComboModel.addElement(group);
        }
        this.cboFieldGroup.setModel(groupComboModel);
        this.lstFieldGroups.setModel(groupListModel);
        this.lstFieldFields.setModel(new DefaultListModel());
        DefaultListModel<String> dependentFieldsModel = new DefaultListModel<String>();
        for (FieldInfo field : fields) {
            dependentFieldsModel.addElement(field.getName());
        }
        this.lchkFieldDependentFields.setModel(dependentFieldsModel);
        this.lstFieldGroups.setSelectedIndex(0);
    }

    private void fields_fetch(FieldsInfo fields) {
        DefaultListModel fmodel = (DefaultListModel)this.lstFieldFields.getModel();
        for (int i = 0; i < fmodel.getSize(); ++i) {
            FieldInfo field = (FieldInfo)fmodel.get(i);
            field.setOrder((i + 1) * 10);
        }
        fields.sort();
    }

    private void group_put(String groupName) {
        DefaultListModel<FieldInfo> fmodel = new DefaultListModel<FieldInfo>();
        for (FieldInfo field : this.fields) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)groupName, (CharSequence)field.getGroup())) continue;
            fmodel.addElement(field);
        }
        this.lstFieldFields.setModel(fmodel);
        this.lstFieldFields.setSelectedIndex(0);
    }

    private void doChangeGroup() {
        String gname = (String)this.lstFieldGroups.getSelectedValue();
        if (gname == null) {
            return;
        }
        this.fields_fetch(this.fields);
        this.group_put(gname);
    }

    private void fields_up() {
        int n = this.lstFieldFields.getSelectedIndex();
        if (n < 1) {
            return;
        }
        FieldInfo field = (FieldInfo)this.lstFieldFields.getSelectedValue();
        if (field == null) {
            return;
        }
        DefaultListModel fmodel = (DefaultListModel)this.lstFieldFields.getModel();
        fmodel.remove(n);
        fmodel.add(n - 1, field);
        this.lstFieldFields.setModel(fmodel);
        this.lstFieldFields.setSelectedIndex(n - 1);
    }

    private void fields_down() {
        DefaultListModel fmodel = (DefaultListModel)this.lstFieldFields.getModel();
        int n = this.lstFieldFields.getSelectedIndex();
        if (n > fmodel.getSize() - 1) {
            return;
        }
        FieldInfo field = (FieldInfo)this.lstFieldFields.getSelectedValue();
        if (field == null) {
            return;
        }
        fmodel.remove(n);
        fmodel.add(n + 1, field);
        this.lstFieldFields.setModel(fmodel);
        this.lstFieldFields.setSelectedIndex(n + 1);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    private void field_fetch(FieldInfo field) {
        if (field == null) {
            return;
        }
        this.tagsAttrController.getModel().fetch(field.tags);
        field.setGroup((String)this.cboFieldGroup.getSelectedItem());
        field.setLabel((String)StringUtils.defaultIfBlank((CharSequence)this.txtFieldLabel.getText(), null));
        field.setHiden(this.chkFieldHiden.isSelected());
        field.setLabelEmpty(this.chkFieldLabelEmpty.isSelected());
        field.setReadonly(this.chkFieldReadonly.isSelected());
        field.setResizeWeight((Integer)this.spnFieldResizeWeight.getValue());
        ListSelectionModel checkModel = this.lchkFieldDependentFields.getCheckedModel();
        ArrayList<String> dependentFields = new ArrayList<String>();
        if (!checkModel.isSelectionEmpty()) {
            ListModel dataModel = this.lchkFieldDependentFields.getModel();
            for (int i = 0; i < dataModel.getSize(); ++i) {
                if (!checkModel.isSelectedIndex(i)) continue;
                dependentFields.add(Objects.toString(this.lchkFieldDependentFields.getModel().getElementAt(i), null));
            }
        }
        field.setDependentFields(dependentFields);
        this.availableValuesController.getModel().fetch(field.getAvailableValues(), field.getCoercion(), field.getCoercionContext());
    }

    private void field_put(FieldInfo field) {
        this.currentField = field;
        this.cboFieldGroup.setSelectedItem(field.getGroup());
        this.txtFieldLabel.setText(field.getFieldLabel());
        this.chkFieldHiden.setSelected(field.isHiden());
        this.tagsAttrController.setModel(new TagsModel(field.getTags()));
        this.chkFieldLabelEmpty.setSelected(field.isLabelEmpty());
        this.chkFieldReadonly.setSelected(field.isReadonly());
        this.spnFieldResizeWeight.setValue(field.getResizeWeight());
        ListSelectionModel checkModel = this.lchkFieldDependentFields.getCheckedModel();
        checkModel.clearSelection();
        ListModel dataModel = this.lchkFieldDependentFields.getModel();
        for (String fieldName : field.getDependentFields()) {
            for (int i = 0; i < dataModel.getSize(); ++i) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)((CharSequence)dataModel.getElementAt(i)))) continue;
                checkModel.addSelectionInterval(i, i);
            }
        }
        this.availableValuesController.setModel(new AvailableValuesModel(field.getAvailableValues()));
    }

    private void group_add() {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        String groupName = dialogs.inputDialog("Group name", "FeatureType layout editor");
        if (groupName == null) {
            return;
        }
        String currentGroup = (String)this.lstFieldGroups.getSelectedValue();
        ArrayList<String> ggroups = new ArrayList<String>();
        ggroups.add(groupName);
        DefaultListModel<String> groupListModel = (DefaultListModel<String>)this.lstFieldGroups.getModel();
        for (int i = 0; i < groupListModel.getSize(); ++i) {
            groupName = (String)groupListModel.getElementAt(i);
            if (ContainerUtils.contains(ggroups, (Object)groupName, (Comparator)CompareUtils.EQUALS_IGNORECASE_COMPARATOR)) continue;
            ggroups.add(groupName);
        }
        Collections.sort(ggroups, CompareUtils.EQUALS_IGNORECASE_COMPARATOR);
        DefaultComboBoxModel<String> groupComboModel = new DefaultComboBoxModel<String>();
        groupListModel = new DefaultListModel<String>();
        for (String group : ggroups) {
            groupListModel.addElement(group);
            groupComboModel.addElement(group);
        }
        this.lstFieldGroups.setModel(groupListModel);
        this.cboFieldGroup.setModel(groupComboModel);
        this.lstFieldGroups.setSelectedValue(currentGroup, true);
        this.cboFieldGroup.setSelectedItem(this.currentField.group);
    }

    private void group_remove() {
    }

    private void preview() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DynFormManager dynFormManager = DynFormLocator.getDynFormManager();
        FeatureType ft = this.fetch(null);
        DynFormDefinition definitionForm = dynFormManager.createDefinition((DynStruct)ft);
        Tags tags = definitionForm.getTags();
        int layoutMode = 1;
        String layoutMode_s = (String)tags.get("dynform.layoutmode", 8, (Object)"plain");
        if (!StringUtils.isEmpty((CharSequence)layoutMode_s)) {
            if (layoutMode_s.equalsIgnoreCase("0") || layoutMode_s.equalsIgnoreCase("plain")) {
                layoutMode = 0;
            } else if (layoutMode_s.equalsIgnoreCase("1") || layoutMode_s.equalsIgnoreCase("tabs")) {
                layoutMode = 1;
            } else if (layoutMode_s.equalsIgnoreCase("2") || layoutMode_s.equalsIgnoreCase("separators")) {
                layoutMode = 2;
            }
        }
        int formWidth = tags.getInt("dynform.width", -1);
        int formHeight = tags.getInt("dynform.height", -1);
        boolean readOnly = tags.getBoolean("dynform.readonly", false);
        boolean useScrollBars = tags.getBoolean("dynform.useScrollBars", true);
        JDynForm lform = dynFormManager.createJDynForm(definitionForm);
        lform.setReadOnly(readOnly);
        List theGroups = definitionForm.getGroups();
        if ((lform.getLayoutMode() == 1 || lform.getLayoutMode() == 2) && theGroups.size() == 1 && theGroups.get(0) == null) {
            lform.setLayoutMode(0);
        } else {
            lform.setLayoutMode(layoutMode);
        }
        if (useScrollBars && formHeight > -1 && formWidth > -1) {
            lform.setFormSize(formWidth, formHeight);
        }
        lform.setUseScrollBars(useScrollBars);
        String title = i18n.getTranslation("_Form") + ": " + definitionForm.getLabel();
        windowManager.showWindow(lform.asJComponent(), title, WindowManager.MODE.WINDOW);
    }

    private void doCodeCompomentChanged() {
        LabeledValue item = (LabeledValue)this.cboCodeComponent.getSelectedItem();
        if (item == null) {
            return;
        }
        ArrayList<String> events = new ArrayList<String>();
        if (item.getValue() instanceof FormInfo) {
            FormInfo lform = (FormInfo)item.getValue();
            events.add("onLoad");
            events.add("onSetvalues");
            events.add("onFieldEnter");
            events.add("onFieldExit");
            events.add("onFieldChanged");
            events.add("validate");
            events.add("clear");
            events.add("isReadOnly");
            events.add("isModified");
        } else {
            FieldInfo lfield = (FieldInfo)item.getValue();
            events.add("compute_click");
            events.add("compute_config");
        }
        Collections.sort(events, CompareUtils.EQUALS_IGNORECASE_COMPARATOR);
        DefaultComboBoxModel<String> eventsModel = new DefaultComboBoxModel<String>();
        for (String event : events) {
            eventsModel.addElement(event);
        }
        this.cboCodeEvents.setModel(eventsModel);
    }

    private void doCodeEventChanged() {
    }

    private void doCodeInsertTemplate() {
        LabeledValue component = (LabeledValue)this.cboCodeComponent.getSelectedItem();
        String event = (String)this.cboCodeEvents.getSelectedItem();
        if (component == null || event == null) {
            return;
        }
        try {
            String template;
            if (component.getValue() instanceof FormInfo) {
                FormInfo lform = (FormInfo)component.getValue();
                template = this.getCodeEventTemplate(event);
            } else {
                FieldInfo lfield = (FieldInfo)component.getValue();
                template = this.getCodeEventTemplate(event, lfield.getName());
            }
            this.codeEditor.insert(-1, template);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't insert template of event", (Throwable)ex);
        }
    }

    private void doCodeGo() {
    }

    private void doSaveResource() {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        dialogs.messageDialog("Opcion guardar script no implementada", "Form editor", 2);
    }

    private void doLoadResorce() {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        dialogs.messageDialog("Opcion cargar script no implementada", "Form editor", 2);
    }

    private static class FormInfo {
        private final Tags tags;
        private String layoutMode;
        private int height;
        private int width;
        private boolean useScrollbars;
        private boolean readonly;
        private String label;

        private FormInfo(String label, Tags tags) {
            this.label = label;
            this.tags = Tags.cloneQuietly((Tags)tags);
            this.layoutMode = tags.getString("dynform.layoutmode", "tabs");
            this.height = tags.getInt("dynform.height", -1);
            this.width = tags.getInt("dynform.width", -1);
            this.readonly = tags.getBoolean("dynform.readonly", false);
            this.useScrollbars = tags.getBoolean("dynform.useScrollBars", true);
        }
    }

    private static class FieldsInfo
    extends ArrayList<FieldInfo> {
        public FieldInfo get(String name) {
            for (FieldInfo field : this) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)field.name)) continue;
                return field;
            }
            return null;
        }

        public Set<String> getGroups() {
            HashSet<String> ggroups = new HashSet<String>();
            for (FieldInfo field : this) {
                ggroups.add(field.group);
            }
            return ggroups;
        }

        public void sort() {
            Collections.sort(this, (o1, o2) -> CompareUtils.compare((String)(((FieldInfo)o1).group + "|" + ((FieldInfo)o1).order), (String)(((FieldInfo)o2).group + "|" + ((FieldInfo)o2).order)));
            int n = 0;
            HashMap<String, Integer> groupIndex = new HashMap<String, Integer>();
            for (String group : this.getGroups()) {
                groupIndex.put(group, n++ * 1000);
            }
            for (FieldInfo field : this) {
                field.order = (Integer)groupIndex.get(field.group) + 10;
                groupIndex.put(field.group, field.order);
            }
        }
    }

    private static class FieldInfo
    implements LabeledValue<FieldInfo> {
        private String name;
        private String group;
        private String label;
        private boolean hiden;
        private int order;
        private Tags tags;
        private final List<DynObjectValueItem> availableValues;
        private final Coercion coercion;
        private final CoercionContext coercionContext;

        public FieldInfo(FeatureAttributeDescriptor descriptor) {
            DynObjectValueItem[] v;
            this.name = descriptor.getName();
            this.group = StringUtils.isBlank((CharSequence)descriptor.getGroup()) ? "-Default-" : descriptor.getGroup();
            this.label = descriptor.getLabel();
            this.hiden = descriptor.isHidden();
            try {
                this.tags = descriptor.getTags().clone();
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.warn("Can't clone tags of field '" + this.name + "'.", (Throwable)ex);
            }
            this.order = descriptor.getOder();
            this.availableValues = descriptor.isAvailableValuesCalculated() ? null : ((v = descriptor.getAvailableValues()) == null ? new ArrayList<DynObjectValueItem>() : Arrays.asList(v));
            this.coercion = descriptor.getCoercion();
            this.coercionContext = descriptor.getCoercionContext();
        }

        public Coercion getCoercion() {
            return this.coercion;
        }

        public CoercionContext getCoercionContext() {
            return this.coercionContext;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFieldLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public boolean isHiden() {
            return this.hiden;
        }

        public void setHiden(boolean hiden) {
            this.hiden = hiden;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public List<DynObjectValueItem> getAvailableValues() {
            return this.availableValues;
        }

        public Tags getTags() {
            return this.tags;
        }

        public boolean isLabelEmpty() {
            return this.tags.getBoolean("dynform.label.empty", false);
        }

        public void setLabelEmpty(boolean labelEmpty) {
            this.tags.set("dynform.label.empty", (Object)labelEmpty);
        }

        public boolean isReadonly() {
            return this.tags.getBoolean("dynform.readonly", false);
        }

        public void setReadonly(boolean readonly) {
            this.tags.set("dynform.readonly", (Object)readonly);
        }

        public int getResizeWeight() {
            return this.tags.getInt("dynform.resizeWeight", 0);
        }

        public void setResizeWeight(int resizeWeight) {
            this.tags.set("dynform.resizeWeight", (Object)resizeWeight);
        }

        public List<String> getDependentFields() {
            String s = this.tags.getString("dynform.dependentFields", null);
            if (StringUtils.isBlank((CharSequence)s)) {
                return Collections.EMPTY_LIST;
            }
            String[] ss = StringUtils.split((String)s, (String)",");
            return Arrays.asList(ss);
        }

        public void setDependentFields(List<String> dependentFields) {
            if (CollectionUtils.isEmpty(dependentFields)) {
                this.tags.set("dynform.dependentFields", null);
            } else {
                String s = StringUtils.join(dependentFields, (String)",");
                this.tags.set("dynform.dependentFields", (Object)s);
            }
        }

        public String toString() {
            return this.name;
        }

        public FieldInfo getValue() {
            return this;
        }

        public String getLabel() {
            return this.name;
        }
    }

    public static class AttributesLayoutAction
    extends AbstractAction {
        public AttributesLayoutAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Form_editor") + "  (en construccion)");
            this.putValue("ActionCommandKey", "FormEditor");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Form_editor") + "  (en construccion)";
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FeatureTypePanel featureTypePanel = (FeatureTypePanel)e.getSource();
            EditableFeatureType ftype = featureTypePanel.fetch(null);
            AttributesLayoutPanel panel = new AttributesLayoutPanel();
            panel.put((FeatureType)ftype);
            WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dialog = windowManager.createDialog((JComponent)panel, "_Form_editor", "", 7);
            dialog.setAutoclose(false);
            dialog.setButtonLabel(4, "_Preview");
            dialog.addActionListener(e1 -> {
                switch (dialog.getAction()) {
                    case 1: {
                        panel.fetch(ftype);
                        featureTypePanel.put((FeatureType)ftype);
                    }
                    case 2: {
                        dialog.hideDialog();
                        break;
                    }
                    case 4: {
                        panel.preview();
                    }
                }
            });
            dialog.show(WindowManager.MODE.WINDOW);
        }
    }
}

