/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributeSelectionPanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributeSelectionPanelView;
import org.gvsig.fmap.dal.swing.impl.featuretype.FeatureAttributeTreeCellRenderer;
import org.gvsig.fmap.dal.swing.impl.featuretype.FeatureAttributeTreeModel;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.swing.api.FilteredTreeController;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;

public class DefaultFeatureAttributeSelectionPanel
extends DefaultFeatureAttributeSelectionPanelView
implements FeatureAttributeSelectionPanel {
    private final FeatureStore store;
    private FilteredTreeController controllerFilter;
    private final FeatureType ftype;
    private FeatureQuery query;

    public DefaultFeatureAttributeSelectionPanel(FeatureStore store, FeatureType ftype, FeatureQuery query) {
        this.store = store;
        this.ftype = ftype;
        this.query = query;
        this.initComponents();
    }

    public DefaultFeatureAttributeSelectionPanel(FeatureStore store, FeatureType ftype) {
        this(store, ftype, null);
    }

    private void initComponents() {
        FeatureAttributeTreeModel treeModel = new FeatureAttributeTreeModel(this.store, this.ftype, true, Search.BASIC_TYPES_FILTER.or(t -> t.getType() == 34).or(t -> t.getType() == 66), this.query);
        this.treeFields.setCellRenderer(new FeatureAttributeTreeCellRenderer());
        this.treeFields.setModel(treeModel);
        try {
            this.treeFields.setSelectionRow(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Dimension sz = this.getPreferredSize();
        if (sz.width < 500) {
            sz.width = 500;
        }
        if (sz.height < 400) {
            sz.height = 400;
        }
        this.controllerFilter = ToolsSwingLocator.getToolsSwingManager().createFilteredTreeController(this.treeFields, (JTextComponent)this.txtFilter, this.btnFilter);
        this.setPreferredSize(sz);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent ce) {
                super.componentHidden(ce);
                if (DefaultFeatureAttributeSelectionPanel.this.treeFields instanceof Disposable) {
                    ((Disposable)DefaultFeatureAttributeSelectionPanel.this.treeFields).dispose();
                }
            }
        });
    }

    public FeatureAttributeDescriptor[] getSelectedPath() {
        TreePath path = this.treeFields.getSelectionPath();
        FeatureAttributeDescriptor[] attrs = new FeatureAttributeDescriptor[path.getPathCount() - 1];
        for (int i = 0; i < attrs.length; ++i) {
            FeatureAttributeTreeModel.Node node = (FeatureAttributeTreeModel.Node)path.getPathComponent(i + 1);
            attrs[i] = (FeatureAttributeDescriptor)node.getValue();
        }
        return attrs;
    }

    public FeatureAttributeDescriptor getSelectedAttributeDescriptor() {
        FeatureAttributeTreeModel.Node node = (FeatureAttributeTreeModel.Node)this.treeFields.getSelectionPath().getLastPathComponent();
        FeatureAttributeDescriptor attrdesc = (FeatureAttributeDescriptor)node.getValue();
        return attrdesc;
    }

    public FeatureStore getSelectedStore() {
        FeatureAttributeTreeModel.Node node = (FeatureAttributeTreeModel.Node)this.treeFields.getSelectionPath().getLastPathComponent();
        FeatureStore theStore = node.getFeatureStore();
        return theStore;
    }

    public String getSelectedName() {
        return this.getSelectedAttributeDescriptor().getName();
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public static void selfRegister() {
    }
}

