/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributeListCellRenderer;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributesSelectionPanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributesSelectionPanelView;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.LabeledValue;

public class DefaultFeatureAttributesSelectionPanel
extends DefaultFeatureAttributesSelectionPanelView
implements FeatureAttributesSelectionPanel {
    private static final String ATTR_IS_EXPRESSION = "DefaultFeatureAttributesSelectionPanel_isExpression";
    private FeatureType featureType;
    private final ActionListenerSupport actionListenerSupport = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
    private FilteredListController availableFieldsController;
    private final List<FeatureAttributeDescriptor> selecteds = new ArrayList<FeatureAttributeDescriptor>();
    private ExpressionPickerController expressionPicker = null;
    private boolean allowCalculatedAttributes = false;
    private List<EditableFeatureAttributeDescriptor> extraColumns;
    private List<String> selectedNames;

    public DefaultFeatureAttributesSelectionPanel() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        FeatureAttributeListCellRenderer renderer = DALSwingLocator.getDataSwingManager().createDefaultFeatureAttributeListCellRenderer();
        this.lstAvailableColumns.setCellRenderer(renderer);
        this.lstSelectedColumns.setCellRenderer(renderer);
        this.lstAvailableColumns.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doSelectAvailableColumn();
        });
        this.lstAvailableColumns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultFeatureAttributesSelectionPanel.this.doColumnAdd();
                }
            }
        });
        this.lstSelectedColumns.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doSelectColumn();
        });
        this.txtExpression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DefaultFeatureAttributesSelectionPanel.this.doSelectAvailableColumn();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                DefaultFeatureAttributesSelectionPanel.this.doSelectAvailableColumn();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                DefaultFeatureAttributesSelectionPanel.this.doSelectAvailableColumn();
            }
        });
        this.txtExpression.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DefaultFeatureAttributesSelectionPanel.this.lstAvailableColumns.getSelectionModel().clearSelection();
            }
        });
        this.btnColumnAdd.addActionListener(e -> this.doColumnAdd());
        this.btnColumnRemove.addActionListener(e -> this.doColumnRemove());
        this.btnColumnDown.addActionListener(e -> this.doColumnDown());
        this.btnColumnUp.addActionListener(e -> this.doColumnUp());
        this.availableFieldsController = toolsSwingManager.createFilteredListController(this.lstAvailableColumns, (JTextComponent)this.txtColumnsFilter, this.btnColumnsFilter);
        Dimension sz = this.getPreferredSize();
        if (sz.width < 450) {
            sz.width = 450;
        }
        if (sz.height < 320) {
            sz.height = 320;
        }
        this.setPreferredSize(sz);
    }

    public List<String> getSelectedNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (FeatureAttributeDescriptor selected : this.selecteds) {
            names.add(selected.getName());
        }
        return names;
    }

    public void setSelectedNames(List<String> names) {
        this.selecteds.clear();
        if (names != null) {
            this.selectedNames = new ArrayList<String>(names);
            for (String name : names) {
                FeatureAttributeDescriptor attr = this.getAttributeDescriptor(name);
                if (attr == null) {
                    if (!this.allowCalculatedAttributes || ExpressionUtils.isValidIdentifier((String)name)) continue;
                    attr = this.createAttributeFromExpression(name);
                }
                if (this.selectedContains(attr)) continue;
                this.selecteds.add(attr);
            }
        } else {
            this.selectedNames = new ArrayList<String>();
        }
        this.updateControls();
    }

    private boolean selectedContains(FeatureAttributeDescriptor attr) {
        for (FeatureAttributeDescriptor selected : this.selecteds) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)selected.getName(), (CharSequence)attr.getName())) continue;
            return true;
        }
        return false;
    }

    private void doSelectAvailableColumn() {
        if (this.lstAvailableColumns.getSelectedIndex() >= 0 || !this.expressionPicker.isEmpty()) {
            this.btnColumnAdd.setEnabled(true);
            return;
        }
        this.btnColumnAdd.setEnabled(false);
    }

    private void doSelectColumn() {
        int indexSelecteds = this.lstSelectedColumns.getSelectedIndex();
        ListModel modelSelecteds = this.lstSelectedColumns.getModel();
        this.btnColumnUp.setEnabled(indexSelecteds >= 1);
        this.btnColumnDown.setEnabled(indexSelecteds >= 0 && indexSelecteds < modelSelecteds.getSize() - 1);
        if (this.lstSelectedColumns.getSelectedIndex() >= 0) {
            this.btnColumnRemove.setEnabled(true);
            return;
        }
        this.btnColumnRemove.setEnabled(false);
    }

    private void doColumnUp() {
        LabeledValue attr = (LabeledValue)this.lstSelectedColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        int n = this.selecteds.indexOf(attr.getValue());
        if (n < 1) {
            return;
        }
        Collections.swap(this.selecteds, n, n - 1);
        this.lstSelectedColumns.setSelectedIndex(n - 1);
        this.updateControls();
    }

    private void doColumnDown() {
        LabeledValue attr = (LabeledValue)this.lstSelectedColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        int n = this.selecteds.indexOf(attr.getValue());
        if (n < 0 || n >= this.selecteds.size() - 1) {
            return;
        }
        Collections.swap(this.selecteds, n, n + 1);
        this.lstSelectedColumns.setSelectedIndex(n + 1);
        this.updateControls();
    }

    private boolean checkIfAttributeInFeatureType(String myAttr) {
        for (FeatureAttributeDescriptor attr : this.featureType) {
            if (!attr.getName().equalsIgnoreCase(myAttr)) continue;
            return true;
        }
        List columns = this.featureType.getExtraColumns().getColumns();
        if (columns != null && !columns.isEmpty()) {
            for (EditableFeatureAttributeDescriptor extraCol : columns) {
                if (!extraCol.getName().equalsIgnoreCase(myAttr)) continue;
                return true;
            }
        }
        if (this.extraColumns != null && !this.extraColumns.isEmpty()) {
            for (EditableFeatureAttributeDescriptor extraCol : this.extraColumns) {
                if (!extraCol.getName().equalsIgnoreCase(myAttr)) continue;
                return true;
            }
        }
        return false;
    }

    private void doColumnRemove() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstSelectedColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        int n = this.selecteds.indexOf(attr);
        if (n < 0) {
            return;
        }
        if (attr.getTags().getBoolean(ATTR_IS_EXPRESSION, false)) {
            Expression toExp = ExpressionEvaluatorLocator.getManager().createExpression();
            toExp.setPhrase(attr.getLabel());
            this.expressionPicker.set((Object)toExp);
        }
        this.selecteds.remove(n);
        this.updateControls();
    }

    private void doColumnAdd() {
        if (this.lstAvailableColumns.getSelectedIndex() >= 0) {
            FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstAvailableColumns.getSelectedValue();
            if (attr == null) {
                return;
            }
            int n = this.selecteds.indexOf(attr);
            if (n >= 0) {
                return;
            }
            this.selecteds.add(attr);
        } else if (!this.expressionPicker.isEmpty() && this.expressionPicker.isValid()) {
            Expression exp = this.expressionPicker.get();
            String expressionField = exp.getPhrase();
            FeatureAttributeDescriptor attr = this.createAttributeFromExpression(expressionField);
            for (FeatureAttributeDescriptor selected : this.selecteds) {
                if (!StringUtils.equals((CharSequence)attr.getName(), (CharSequence)selected.getName())) continue;
                return;
            }
            this.selecteds.add(attr);
            this.expressionPicker.set(null);
        }
        this.updateControls();
    }

    private FeatureAttributeDescriptor createAttributeFromExpression(String expressionField) {
        EditableFeatureAttributeDescriptor attr = DALLocator.getDataManager().createFeatureAttributeDescriptor(expressionField, 8);
        attr.getTags().set(ATTR_IS_EXPRESSION, (Object)true);
        attr.setLabel(expressionField);
        return attr;
    }

    public void setStore(FeatureStore store) {
        try {
            this.setFeatureType(store.getDefaultFeatureType());
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't assign store", ex);
        }
    }

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
        if (this.selectedNames != null) {
            this.setSelectedNames(this.selectedNames);
        } else {
            this.updateControls();
        }
    }

    public void setExtraColumns(List<EditableFeatureAttributeDescriptor> extraColumns) {
        this.extraColumns = extraColumns;
        if (this.selectedNames != null) {
            this.setSelectedNames(this.selectedNames);
        } else {
            this.updateControls();
        }
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void addActionListener(ActionListener al) {
        this.actionListenerSupport.addActionListener(al);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListenerSupport.getActionListeners();
    }

    public void removeActionListener(ActionListener al) {
        this.actionListenerSupport.removeActionListener(al);
    }

    public void removeAllActionListener() {
        this.actionListenerSupport.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent ae) {
        this.actionListenerSupport.fireActionEvent(ae);
    }

    public boolean hasActionListeners() {
        return this.actionListenerSupport.hasActionListeners();
    }

    private void updateControls() {
        if (this.expressionPicker == null) {
            this.expressionPicker = DALSwingLocator.getDataSwingManager().createExpressionPickerController(this.featureType.getStore(), (JTextComponent)this.txtExpression, this.btnExpression, this.btnBookmarks, this.btnHistory);
        }
        int indexAvailables = this.lstAvailableColumns.getSelectedIndex();
        int indexSelecteds = this.lstSelectedColumns.getSelectedIndex();
        FilteredListModel modelAvailables = ToolsSwingLocator.getToolsSwingManager().createFilteredListModel();
        FilteredListModel modelSelecteds = ToolsSwingLocator.getToolsSwingManager().createFilteredListModel();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        ArrayList<Object> availables = new ArrayList<Object>();
        for (Object attr : this.featureType) {
            if (this.selectedContains((FeatureAttributeDescriptor)attr)) continue;
            availables.add(attr);
        }
        List columns = this.featureType.getExtraColumns().getColumns();
        if (columns != null && !columns.isEmpty()) {
            for (EditableFeatureAttributeDescriptor extraCol : columns) {
                if (this.selectedContains((FeatureAttributeDescriptor)extraCol)) continue;
                availables.add(extraCol);
            }
        }
        if (this.extraColumns != null && !this.extraColumns.isEmpty()) {
            for (EditableFeatureAttributeDescriptor extraCol : this.extraColumns) {
                if (this.selectedContains((FeatureAttributeDescriptor)extraCol)) continue;
                availables.add(extraCol);
            }
        }
        DataSwingManager dalSwingManager = DALSwingLocator.getDataSwingManager();
        Collections.sort(availables, (o1, o2) -> StringUtils.compare((String)dalSwingManager.getAttributeDescriptorLabel(o1), (String)dalSwingManager.getAttributeDescriptorLabel(o2)));
        for (FeatureAttributeDescriptor featureAttributeDescriptor : availables) {
            modelAvailables.addElement((LabeledValue)featureAttributeDescriptor);
        }
        modelAvailables.setFilter(this.txtColumnsFilter.getText());
        modelAvailables.sort(true);
        for (FeatureAttributeDescriptor featureAttributeDescriptor : this.selecteds) {
            modelSelecteds.addElement((LabeledValue)featureAttributeDescriptor);
        }
        modelAvailables.sort(true);
        this.lstAvailableColumns.setModel(modelAvailables);
        this.lstSelectedColumns.setModel(modelSelecteds);
        if (indexAvailables >= 0 && modelAvailables.getSize() > 0) {
            if (indexAvailables >= modelAvailables.getSize()) {
                indexAvailables = modelAvailables.getSize() - 1;
            }
            this.lstAvailableColumns.setSelectedIndex(indexAvailables);
            this.btnColumnAdd.setEnabled(true);
        } else if (!this.expressionPicker.isEmpty()) {
            this.btnColumnAdd.setEnabled(true);
        } else {
            this.btnColumnAdd.setEnabled(false);
        }
        this.btnColumnUp.setEnabled(indexSelecteds >= 1);
        this.btnColumnDown.setEnabled(indexSelecteds >= 0 && indexSelecteds < modelSelecteds.getSize() - 1);
        if (indexSelecteds >= 0 && modelSelecteds.getSize() > 0) {
            if (indexSelecteds >= modelSelecteds.getSize()) {
                indexSelecteds = modelSelecteds.getSize() - 1;
            }
            this.lstSelectedColumns.setSelectedIndex(indexSelecteds);
            this.lstSelectedColumns.ensureIndexIsVisible(indexSelecteds);
            this.btnColumnRemove.setEnabled(true);
        } else {
            this.btnColumnRemove.setEnabled(false);
        }
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public static void selfRegister() {
    }

    public void allowCalculatedAttributes(boolean allowCalculatedAttributes) {
        this.allowCalculatedAttributes = allowCalculatedAttributes;
        this.btnBookmarks.setVisible(this.allowCalculatedAttributes);
        this.btnHistory.setVisible(this.allowCalculatedAttributes);
        this.btnExpression.setVisible(this.allowCalculatedAttributes);
        this.txtExpression.setVisible(this.allowCalculatedAttributes);
    }

    private FeatureAttributeDescriptor getAttributeDescriptor(String name) {
        if (this.featureType == null) {
            return null;
        }
        FeatureAttributeDescriptor attr = this.featureType.getAttributeDescriptorFromAll(name);
        if (attr != null) {
            return attr;
        }
        if (this.extraColumns == null) {
            return null;
        }
        for (EditableFeatureAttributeDescriptor extraColumn : this.extraColumns) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)extraColumn.getName(), (CharSequence)name)) continue;
            return extraColumn;
        }
        return null;
    }
}

