/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.featureform.swing.impl.DefaultJFeatureForm;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.AttributesLayoutPanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributePanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureTypePanelView;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.DefaultAggregateController;
import org.gvsig.fmap.dal.swing.impl.featuretype.featurerule.FeatureRuleItemController;
import org.gvsig.fmap.dal.swing.impl.featuretype.featurerule.FeatureRulesModel;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.Tag;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.TagItemController;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.TagsModel;
import org.gvsig.texteditor.JTextEditor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureTypePanel
extends DefaultFeatureTypePanelView
implements FeatureTypePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureTypePanel.class);
    private static final int COLUMN_ORDER = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_DATATYPE = 2;
    private static final int COLUMN_SIZE = 3;
    private static final int COLUMN_PRECISION = 4;
    private static final int COLUMN_SCALE = 5;
    private static final int COLUMN_DEFAULTVALUE = 6;
    private static final int COLUMN_ISCOMPUTED = 7;
    private static final int COLUMN_PK_FK = 8;
    private static final int COLUMN_ALLOWNULL = 9;
    private static final int COLUMN_HIDDEN = 10;
    private static final int COLUMN_RELATIONTYPE = 11;
    private FeatureType originalFeatureType = null;
    private JSplitPane splRules;
    private JSplitPane splAttributes;
    private FeatureRuleItemController ruleController;
    private JSplitPane splTags;
    private IProjection defaultProjection;
    private AttributeDescriptorPickerController defaultGeometryController;
    private DefaultFeatureAttributePanel descriptorPanel;
    private EditableFeatureType featureType;
    private int mode = 2;
    private FeatureTypeTableModel tableModel;
    private FeatureStore store;
    private int currentRow = -1;
    private boolean fieldSelectionAllowed = true;
    private AggregateController<Tag> tagsController;
    private ChangeListenerHelper changeListenerHelper;
    private AggregateController<FeatureRule> rulesController;

    public DefaultFeatureTypePanel() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        JComponent c = cfgActionsManager.getConfigurableActionsComponent("FeatureTypePanel", (Object)this);
        this.pnlCfgActions.setLayout(new BorderLayout(0, 0));
        this.pnlCfgActions.add((Component)c, "Center");
        this.splRules = ToolsSwingUtils.createVerticalSplit((JPanel)this.gridRules, (JPanel)this.gridRulesTable, (boolean)false, (JPanel)this.gridRulesDetail, (boolean)true);
        this.splAttributes = ToolsSwingUtils.createVerticalSplit((JPanel)this.gridAttributes, (JPanel)this.gridAttributesTable, (boolean)false, (JPanel)this.gridAttributesDetail, (boolean)true);
        this.splTags = ToolsSwingUtils.createVerticalSplit((JPanel)this.gridTags, (JPanel)this.gridTagsItems, (boolean)false, (JPanel)this.gridTagsItem, (boolean)true);
        this.changeListenerHelper = swingManager.createChangeListenerHelper();
        swingManager.translate((AbstractButton)this.btnDelete);
        swingManager.translate((AbstractButton)this.btnFormFieldAccept);
        swingManager.translate((AbstractButton)this.btnFormFieldDiscard);
        swingManager.translate((AbstractButton)this.btnFormFieldModify);
        swingManager.translate((AbstractButton)this.btnNew);
        swingManager.translate(this.lblLabel);
        swingManager.translate(this.lblDescription);
        swingManager.translate(this.lblTags);
        swingManager.translate(this.tabFeatureType);
        swingManager.translate((JComponent)this.lblRulesDefaultRules);
        swingManager.translate((JComponent)this.lblRulesCustomRules);
        swingManager.translate((AbstractButton)this.chkRulesValidateFeatureBeforeInsert);
        swingManager.translate((AbstractButton)this.chkRulesValidateFeaturesAtFinishEditing);
        swingManager.translate(this.lblRuleName);
        swingManager.translate(this.lblRuleDescription);
        swingManager.translate(this.lblRuleCheckAtFinishEditing);
        swingManager.translate(this.lblRuleCheckAtUpdate);
        swingManager.translate(this.lblRuleCheckAtEditFeature);
        swingManager.translate(this.lblRuleValidation);
        swingManager.translate((AbstractButton)this.btnRulesNew);
        swingManager.translate((AbstractButton)this.btnRulesDelete);
        swingManager.translate((AbstractButton)this.btnRuleFormFieldModify);
        swingManager.translate((AbstractButton)this.btnRuleFormFieldAccept);
        swingManager.translate((AbstractButton)this.btnRuleFormFieldDiscard);
        swingManager.translate((AbstractButton)this.btnRuleValidation);
        swingManager.translate((AbstractButton)this.btnRuleValidationBookmarks);
        swingManager.translate((AbstractButton)this.btnRuleValidationHistory);
        swingManager.translate(this.lblTagsItemName);
        swingManager.translate(this.lblTagsItemValue);
        swingManager.translate(this.lblTagsItemNotes);
        this.tableModel = new FeatureTypeTableModel();
        this.tblFields.setModel(this.tableModel);
        this.tblFields.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DefaultFeatureTypePanel.this.doChangeFieldSelection();
            }
        });
        this.tblFields.setAutoCreateRowSorter(true);
        this.descriptorPanel = new DefaultFeatureAttributePanel();
        this.descriptorPanel.setDefaultProjection(this.defaultProjection);
        this.pnlField.setLayout(new BorderLayout());
        this.pnlField.add((Component)this.descriptorPanel, "Center");
        this.descriptorPanel.setEnabled(false);
        this.btnFormFieldModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultFeatureTypePanel.this.doFormFieldModify();
            }
        });
        this.btnFormFieldDiscard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultFeatureTypePanel.this.doFormFieldDiscard();
            }
        });
        this.btnFormFieldAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultFeatureTypePanel.this.doFormFieldAccept();
            }
        });
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultFeatureTypePanel.this.doNewField();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultFeatureTypePanel.this.doDeleteField();
            }
        });
        this.tagsController = new DefaultAggregateController<Tag>(this.tblTagsItems, this.btnTagsModify, this.btnTagsDiscard, this.btnTagsAccept, this.btnTagsNew, this.btnTagsDelete, new TagItemController(this.cboTagsItemName, this.cboTagsItemValue, this.lblTagsItemNotesValue));
        this.ruleController = new FeatureRuleItemController(this.txtRuleName, this.txtRuleDescription, this.chkRuleCheckAtFinishEditing, this.chkRuleCheckAtUpdate, this.chkRuleCheckAtEditFeature, this.txtRuleValidation, this.btnRuleValidation, this.btnRuleValidationBookmarks, this.btnRuleValidationHistory);
        this.rulesController = new DefaultAggregateController<FeatureRule>(this.tblRules, this.btnRuleFormFieldModify, this.btnRuleFormFieldDiscard, this.btnRuleFormFieldAccept, this.btnRulesNew, this.btnRulesDelete, this.ruleController);
        if (this.tblFields.getRowCount() > 0) {
            this.tblFields.getSelectionModel().setSelectionInterval(0, 0);
            this.doFormFieldPut();
        }
        this.tabFeatureType.setSelectedIndex(1);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)30, (int)120, (int)45, (int)150);
        SwingUtilities.invokeLater(() -> this.splAttributes.setDividerLocation(0.3));
    }

    private boolean doFormFieldFetch() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return true;
        }
        FeatureAttributeDescriptor descriptor = this.featureType.getAttributeDescriptor(row);
        int previousType = descriptor.getType();
        if (descriptor instanceof EditableFeatureAttributeDescriptor) {
            if (this.descriptorPanel.fetch((EditableFeatureAttributeDescriptor)descriptor) == null) {
                return false;
            }
            this.tableModel.fireUpdateEvent();
        }
        FeatureAttributeDescriptor oldDescriptor = null;
        if (this.originalFeatureType != null) {
            oldDescriptor = this.originalFeatureType.getAttributeDescriptor(descriptor.getName());
        }
        if (oldDescriptor != null && oldDescriptor.getDataType() != descriptor.getDataType() && previousType != descriptor.getType()) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18manager = ToolsLocator.getI18nManager();
            StringBuilder message = new StringBuilder();
            String[] messageArgs = new String[]{oldDescriptor.getName()};
            message.append(i18manager.getTranslation("_Already_existed_a_field_named_XfieldnameX_but_with_different_data_type", messageArgs));
            message.append(".\n");
            message.append(i18manager.getTranslation("_Values_of_data_will_try_to_coerce_to_this_type"));
            dialogs.messageDialog(message.toString(), null, i18manager.getTranslation("_Values_will_change"), 1, "feature-type-manager-field-already-exist-in-previous-schema");
        }
        return true;
    }

    private void doFormFieldPut() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return;
        }
        FeatureAttributeDescriptor descriptor = this.featureType.getAttributeDescriptor(row);
        this.currentRow = row;
        this.descriptorPanel.put(descriptor);
        this.updateButtonState();
        if (descriptor instanceof EditableFeatureAttributeDescriptor) {
            this.btnFormFieldModify.setEnabled((this.mode == 1 || this.mode == 0) && this.tblFields.getSelectedRowCount() == 1);
        } else {
            this.btnFormFieldModify.setEnabled(false);
        }
    }

    private void updateButtonState() {
        this.descriptorPanel.setEnabled(true);
        this.descriptorPanel.setMode(2);
        this.btnFormFieldAccept.setEnabled(false);
        this.btnFormFieldDiscard.setEnabled(false);
        switch (this.mode) {
            case 1: {
                this.btnDelete.setEnabled(true);
                this.btnFormFieldModify.setEnabled(true);
                this.btnNew.setEnabled(true);
                this.tagsController.setEnabled(true);
                this.rulesController.setEnabled(true);
                this.txtLabel.setEditable(true);
                this.txtDescription.setEditable(true);
                break;
            }
            case 0: {
                this.btnDelete.setEnabled(this.descriptorPanel.isVirtualField());
                this.btnFormFieldModify.setEnabled(true);
                this.btnNew.setEnabled(true);
                this.tagsController.setEnabled(true);
                this.rulesController.setEnabled(true);
                this.txtLabel.setEditable(true);
                this.txtDescription.setEditable(true);
                break;
            }
            case 2: {
                this.btnDelete.setEnabled(false);
                this.btnFormFieldModify.setEnabled(false);
                this.btnNew.setEnabled(false);
                this.tagsController.setEnabled(false);
                this.rulesController.setEnabled(false);
                this.txtLabel.setEditable(false);
                this.txtDescription.setEditable(false);
            }
        }
    }

    private void doFormFieldModify() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return;
        }
        FeatureAttributeDescriptor descriptor = this.featureType.getAttributeDescriptor(row);
        this.descriptorPanel.put(descriptor);
        this.descriptorPanel.setEnabled(this.mode == 1 || this.mode == 0);
        this.btnFormFieldAccept.setEnabled(this.mode == 1 || this.mode == 0);
        this.btnFormFieldDiscard.setEnabled(this.mode == 1 || this.mode == 0);
        this.btnFormFieldModify.setEnabled(false);
        this.btnNew.setEnabled(false);
        this.btnDelete.setEnabled(false);
        if (descriptor instanceof EditableFeatureAttributeDescriptor) {
            this.descriptorPanel.setMode(this.mode);
        } else {
            this.descriptorPanel.setMode(2);
        }
        this.fieldSelectionAllowed = false;
        this.changeListenerHelper.fireEvent();
    }

    public boolean isEditing() {
        return this.btnFormFieldAccept.isEnabled() || this.rulesController.isEditing();
    }

    private void doFormFieldAccept() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return;
        }
        FeatureAttributeDescriptor descriptor = this.featureType.getAttributeDescriptor(row);
        if (this.doFormFieldFetch()) {
            row = this.getRowTableOfDescriptor(descriptor);
            this.updateButtonState();
            this.tblFields.getSelectionModel().setSelectionInterval(row, row);
            this.tblFields.scrollRectToVisible(this.tblFields.getCellRect(row, 0, true));
            this.fieldSelectionAllowed = true;
        }
        this.changeListenerHelper.fireEvent();
    }

    private void doFormFieldDiscard() {
        this.doFormFieldPut();
        this.updateButtonState();
        this.fieldSelectionAllowed = true;
        this.changeListenerHelper.fireEvent();
    }

    private void doChangeFieldSelection() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return;
        }
        if (!this.fieldSelectionAllowed) {
            if (row != this.currentRow) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                JOptionPane.showMessageDialog(this, i18n.getTranslation("_Before_changing_field_accept_or_discard_the_changes"), i18n.getTranslation("_Warning"), 2);
                this.tblFields.getSelectionModel().setSelectionInterval(this.currentRow, this.currentRow);
            }
            return;
        }
        this.doFormFieldPut();
    }

    public JComponent asJComponent() {
        return this;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.updateButtonState();
    }

    public EditableFeatureType fetch(EditableFeatureType type) {
        if (type == null) {
            type = (EditableFeatureType)this.featureType.getCopy();
        } else {
            type.removeAll();
            type.copyFrom((FeatureType)this.featureType);
        }
        type.setLabel((String)StringUtils.defaultIfBlank((CharSequence)this.txtLabel.getText(), null));
        type.setDescription((String)StringUtils.defaultIfBlank((CharSequence)this.txtDescription.getText(), null));
        this.tagsController.getModel().fetch(type.getTags());
        type.setCheckFeaturesAtInsert(this.chkRulesValidateFeatureBeforeInsert.isSelected());
        type.setCheckFeaturesAtFinishEditing(this.chkRulesValidateFeaturesAtFinishEditing.isSelected());
        if (type.getDefaultGeometryAttribute() == null && StringUtils.isNotBlank((CharSequence)this.defaultGeometryController.getName())) {
            throw new RuntimeException("Default geometry is '" + this.defaultGeometryController.getName() + "' but there is no geometry field defined.");
        }
        type.setDefaultGeometryAttributeName(this.defaultGeometryController.getName());
        return type;
    }

    public void put(FeatureType type) {
        this.featureType = null;
        this.originalFeatureType = null;
        if (type == null) {
            this.store = null;
            this.rulesController.clean();
            this.tagsController.clean();
            this.chkRulesValidateFeatureBeforeInsert.setSelected(true);
            this.chkRulesValidateFeaturesAtFinishEditing.setSelected(false);
        } else {
            FeatureType ftypeToCompare = type.getOriginalFeatureType();
            if (ftypeToCompare == null) {
                ftypeToCompare = type;
            }
            this.originalFeatureType = ftypeToCompare.getCopy();
            this.featureType = (EditableFeatureType)type.getCopy();
            this.rulesController.setModel(new FeatureRulesModel(this.featureType.getRules()));
            this.chkRulesValidateFeatureBeforeInsert.setSelected(type.isCheckFeaturesAtInsert());
            this.chkRulesValidateFeaturesAtFinishEditing.setSelected(type.isCheckFeaturesAtFinishEditing());
            this.store = type.getStore();
            this.ruleController.setFeatureStore(this.store);
            this.txtLabel.setText((String)StringUtils.defaultIfBlank((CharSequence)type.getLabel(), (CharSequence)""));
            this.txtDescription.setText((String)StringUtils.defaultIfBlank((CharSequence)type.getDescription(), (CharSequence)""));
            this.tagsController.setModel(new TagsModel(type.getTags()));
        }
        if (!(type instanceof EditableFeatureType)) {
            this.setMode(2);
        }
        this.tableModel = new FeatureTypeTableModel((FeatureType)this.featureType);
        this.tblFields.setModel(this.tableModel);
        if (type != null && !type.isEmpty()) {
            this.tblFields.getSelectionModel().setSelectionInterval(0, 0);
        }
        SwingUtilities.invokeLater(() -> this.splAttributes.setDividerLocation(0.3));
        this.defaultGeometryController = DALSwingLocator.getDataSwingManager().createAttributeDescriptorPickerController(this.cboDefaultGeometry, (Predicate)new Predicate<FeatureAttributeDescriptor>(){

            @Override
            public boolean test(FeatureAttributeDescriptor t) {
                return t.getType() == 66;
            }
        });
        this.defaultGeometryController.setFeatureType((FeatureType)this.featureType);
        this.defaultGeometryController.set(this.featureType.getDefaultGeometryAttributeName());
        this.updateButtonState();
        this.doFormFieldPut();
    }

    private void doNewField() {
        EditableFeatureType eft = this.featureType;
        EditableFeatureAttributeDescriptor descriptor = eft.add(this.featureType.getNewFieldName(), 8, 50);
        if (this.mode == 0) {
            descriptor.setFeatureAttributeEmulator(ExpressionUtils.createExpression((String)"NULL"));
        }
        this.tableModel.fireUpdateEvent();
        int row = this.getRowTableOfDescriptor((FeatureAttributeDescriptor)descriptor);
        this.tblFields.getSelectionModel().addSelectionInterval(row, row);
        this.tblFields.scrollRectToVisible(this.tblFields.getCellRect(row, 0, true));
        this.updateButtonState();
        this.descriptorPanel.put((FeatureAttributeDescriptor)descriptor);
        this.descriptorPanel.setEnabled(this.mode == 1 || this.mode == 0);
        this.btnFormFieldAccept.setEnabled(this.mode == 1 || this.mode == 0);
        this.btnFormFieldDiscard.setEnabled(this.mode == 1 || this.mode == 0);
        this.btnFormFieldModify.setEnabled(false);
        this.btnNew.setEnabled(false);
        this.btnDelete.setEnabled(false);
        if (descriptor instanceof EditableFeatureAttributeDescriptor) {
            if (this.mode == 0) {
                this.descriptorPanel.setMode(100);
            } else {
                this.descriptorPanel.setMode(this.mode);
            }
        } else {
            this.descriptorPanel.setMode(2);
        }
        this.fieldSelectionAllowed = false;
        this.changeListenerHelper.fireEvent();
    }

    private void doDeleteField() {
        int row = this.getSelectedRow();
        int[] rows = this.tblFields.getSelectedRows();
        ArrayList<String> descriptors = new ArrayList<String>();
        for (int rowDescriptor : rows) {
            if (rowDescriptor < 0) continue;
            rowDescriptor = this.tblFields.convertRowIndexToModel(rowDescriptor);
            descriptors.add(this.featureType.getAttributeDescriptor(rowDescriptor).getName());
        }
        Object object = descriptors.iterator();
        while (object.hasNext()) {
            String descriptor = (String)object.next();
            this.featureType.remove(descriptor);
        }
        this.tableModel.fireUpdateEvent();
        if (row >= this.tblFields.getRowCount()) {
            row = this.tblFields.getRowCount() - 1;
        }
        this.tblFields.getSelectionModel().addSelectionInterval(row, row);
        this.updateButtonState();
        this.doFormFieldPut();
        this.changeListenerHelper.fireEvent();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    public static void selfRegister() {
        ConfigurableActionsMamager cfgActionsManager;
        try {
            cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        }
        catch (ReferenceNotRegisteredException ex) {
            return;
        }
        cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new ViewAsJsonAction());
        cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new ForceSynchronizeAction());
        cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new AttributesLayoutPanel.AttributesLayoutAction());
    }

    public void setDefaultProjection(IProjection projection) {
        this.defaultProjection = projection;
        if (this.descriptorPanel != null) {
            this.descriptorPanel.setDefaultProjection(projection);
        }
    }

    private int getSelectedRow() {
        int x1 = this.tblFields.getSelectedRow();
        if (x1 < 0) {
            return -1;
        }
        int x2 = this.tblFields.convertRowIndexToModel(x1);
        return x2;
    }

    public int getRowTableOfDescriptor(FeatureAttributeDescriptor descriptor) {
        String searchname = descriptor.getName();
        for (int i = 0; i < this.featureType.size(); ++i) {
            FeatureAttributeDescriptor curdescriptor = this.featureType.getAttributeDescriptor(i);
            String curname = curdescriptor.getName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)curname, (CharSequence)searchname)) continue;
            return this.tblFields.convertRowIndexToView(i);
        }
        return -1;
    }

    public static class ForceSynchronizeAction
    extends AbstractAction {
        public ForceSynchronizeAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Force_synchronize"));
            this.putValue("ActionCommandKey", "ForceSynchronize");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Force_synchronize");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultFeatureTypePanel featureTypePanel = (DefaultFeatureTypePanel)e.getSource();
            featureTypePanel.featureType.forceStrongChanges();
        }
    }

    public static class PreviewFormAction
    extends AbstractAction {
        public PreviewFormAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Preview_form"));
            this.putValue("ActionCommandKey", "PreviewForm");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Preview_form");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultFeatureTypePanel featureTypePanel = (DefaultFeatureTypePanel)e.getSource();
            EditableFeatureType featureType = featureTypePanel.fetch(null);
            DefaultJFeatureForm form = new DefaultJFeatureForm();
            form.setFeatureType((FeatureType)featureType);
            WindowManager winmanager = ToolsSwingLocator.getWindowManager();
            winmanager.showWindow(form.asJComponent(), ToolsSwingUtils.makeTitle((String)"Form preview", (String)featureType.getName(), null), WindowManager.MODE.WINDOW);
        }
    }

    public static class ViewAsJsonAction
    extends AbstractAction {
        public ViewAsJsonAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_View_as_Json"));
            this.putValue("ActionCommandKey", "ViewAsJson");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_View_as_Json");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultFeatureTypePanel featureTypePanel = (DefaultFeatureTypePanel)e.getSource();
            EditableFeatureType featureType = featureTypePanel.fetch(null);
            JTextEditor editor = ToolsSwingLocator.getTextEditorManager().createTextEditor();
            editor.setContents((Object)featureType.toJsonBuilder().toString());
            WindowManager winmanager = ToolsSwingLocator.getWindowManager();
            winmanager.showWindow(editor.asJComponent(), "FeatureType - " + featureType.getName(), WindowManager.MODE.WINDOW);
        }
    }

    private class FeatureTypeTableModel
    extends AbstractTableModel {
        private final FeatureType featureType;
        private final String[] columnNames = new String[]{"Order", "Name", "Type", "Size", "Precision", "Scale", "Default", "Calculated", "Key", "Nulls", "Hidden", "Relation"};
        private final Class[] columnClasses = new Class[]{Integer.class, String.class, String.class, Integer.class, Integer.class, Integer.class, String.class, Boolean.class, String.class, Boolean.class, Boolean.class, Integer.class};

        public FeatureTypeTableModel() {
            this.featureType = null;
        }

        public FeatureTypeTableModel(FeatureType featureType) {
            this.featureType = featureType;
        }

        @Override
        public int getRowCount() {
            if (this.featureType == null) {
                return 0;
            }
            return this.featureType.size();
        }

        @Override
        public int getColumnCount() {
            if (this.featureType == null) {
                return 0;
            }
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.featureType == null) {
                return "";
            }
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.featureType == null) {
                return String.class;
            }
            return this.columnClasses[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.featureType == null) {
                return "";
            }
            FeatureAttributeDescriptor descriptor = this.featureType.getAttributeDescriptor(rowIndex);
            DataType dataType = descriptor.getDataType();
            switch (columnIndex) {
                case 0: {
                    return descriptor.getOder();
                }
                case 1: {
                    return descriptor.getName();
                }
                case 2: {
                    return descriptor.getDataTypeName();
                }
                case 3: {
                    if (dataType.supportSize()) {
                        return descriptor.getSize();
                    }
                    return null;
                }
                case 4: {
                    if (dataType.supportPrecision()) {
                        return descriptor.getPrecision();
                    }
                    return null;
                }
                case 5: {
                    if (dataType.supportScale()) {
                        return descriptor.getScale();
                    }
                    if (dataType.isNumeric()) {
                        return 0;
                    }
                    return null;
                }
                case 6: {
                    return Objects.toString(descriptor.getDefaultValue(), "");
                }
                case 7: {
                    return descriptor.isComputed();
                }
                case 8: {
                    if (descriptor.isPrimaryKey()) {
                        return "Pk";
                    }
                    if (descriptor.isForeingKey()) {
                        return "Fk";
                    }
                    return "";
                }
                case 9: {
                    return descriptor.allowNull();
                }
                case 10: {
                    return descriptor.isHidden();
                }
                case 11: {
                    return descriptor.getRelationType();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void fireUpdateEvent() {
            this.fireTableChanged(new TableModelEvent(this));
        }
    }
}

