/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributeListCellRenderer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.LabeledValue;

public class FeatureAttributeListCellRendererImpl
extends DefaultListCellRenderer
implements FeatureAttributeListCellRenderer {
    private final IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
    private Integer useLabels = null;
    private final DataSwingManager dalSwingManager = DALSwingLocator.getDataSwingManager();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value == null) {
            return label;
        }
        FeatureAttributeDescriptor attrdesc = value instanceof LabeledValue ? (FeatureAttributeDescriptor)((LabeledValue)value).getValue() : (FeatureAttributeDescriptor)value;
        String theLabel = "";
        String iconName = null;
        try {
            if (attrdesc != null) {
                if (this.useLabels == null) {
                    theLabel = this.dalSwingManager.getAttributeDescriptorLabel(attrdesc);
                } else {
                    switch (this.useLabels) {
                        case 1: {
                            theLabel = attrdesc.getName();
                            break;
                        }
                        case 0: {
                            if (attrdesc.hasLabel()) {
                                theLabel = attrdesc.getLocalizedLabel();
                                break;
                            }
                            theLabel = attrdesc.getName();
                            break;
                        }
                        default: {
                            theLabel = attrdesc.hasLabel() ? String.format("%s [%s]", attrdesc.getLocalizedLabel(), attrdesc.getName()) : attrdesc.getName();
                        }
                    }
                }
                iconName = attrdesc.getDataType().getIconName();
            }
            label.setText(theLabel);
            if (this.iconTheme.exists(iconName)) {
                label.setIcon(this.iconTheme.get(iconName));
            } else {
                label.setIcon(null);
            }
        }
        catch (Exception ex) {
            label.setText("#ERROR#");
        }
        return label;
    }

    public void setUseLabels(Integer useLabels) {
        this.useLabels = useLabels;
    }

    public Integer getUseLabels() {
        return this.useLabels;
    }
}

