/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.swing.impl.featuretype.FeatureAttributeTreeModel;
import org.gvsig.tools.swing.api.CompoundIcon;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class FeatureAttributeTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private final Icon iconTable;
    private final Icon iconColumn;
    private final Icon iconForeingKey;
    private final IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
    private final ImageIcon iconColumnQueryCalculated;
    private final ImageIcon iconColumnTableCalculated;

    public FeatureAttributeTreeCellRenderer() {
        this.iconTable = this.iconTheme.get("featurestore-table");
        this.iconColumn = this.iconTheme.get("featurestore-column");
        this.iconColumnTableCalculated = this.iconTheme.get("featurestore-calculated-column");
        this.iconColumnQueryCalculated = this.iconTheme.get("featurestore-query-calculated-column");
        this.iconForeingKey = this.iconTheme.get("featurestore-foreing-key");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel theLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!(value instanceof FeatureAttributeTreeModel.Node)) {
            return theLabel;
        }
        FeatureAttributeTreeModel.Node node = (FeatureAttributeTreeModel.Node)value;
        FeatureAttributeDescriptor attrdesc = (FeatureAttributeDescriptor)node.getValue();
        Icon iconElement = node.isRoot() ? this.iconTable : (attrdesc == null ? (leaf ? this.iconColumn : this.iconForeingKey) : (attrdesc.isForeingKey() ? this.iconForeingKey : (attrdesc.isComputed() ? (attrdesc.getStore() == null ? this.iconColumnQueryCalculated : this.iconColumnTableCalculated) : this.iconColumn)));
        ImageIcon iconDataType = null;
        try {
            if (!node.isRoot()) {
                String iconName = ((FeatureAttributeDescriptor)node.getValue()).getDataType().getIconName();
                iconDataType = this.iconTheme.get(iconName);
            }
        }
        catch (Exception iconName) {
            // empty catch block
        }
        String s = node.getLabel();
        if (StringUtils.isBlank((CharSequence)s)) {
            s = "???";
        }
        theLabel.setText(s);
        if (iconDataType != null) {
            CompoundIcon compoundIcon = ToolsSwingLocator.getToolsSwingManager().createCompoundIcon(new Icon[]{iconElement, iconDataType});
            theLabel.setIcon((Icon)compoundIcon);
        } else {
            theLabel.setIcon(iconElement);
        }
        return theLabel;
    }
}

