/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureTypePanel;
import org.gvsig.json.Json;
import org.gvsig.tools.swing.api.viewer.AbstractJViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;

public class FeatureTypeEditor
extends AbstractJViewer {
    private static final int FORMAT_JSONSTR = 0;
    private static final int FORMAT_JSONFILE = 1;
    private static final int FORMAT_DALFILE = 2;
    private static final int FORMAT_DALBYTES = 3;
    private static final int FORMAT_FEATURETYPE = 4;
    private static final int FORMAT_JSONBYTES = 5;
    private final DefaultFeatureTypePanel component = new DefaultFeatureTypePanel();
    private int format = 4;

    public FeatureTypeEditor(ViewerFactory factory) {
        super(factory);
    }

    public JComponent asJComponent() {
        return this.component;
    }

    public void setContents(Object data) {
        try {
            if (data instanceof FeatureType) {
                this.component.put((FeatureType)data);
                this.format = 4;
                return;
            }
            if (data instanceof byte[]) {
                DataManager dataManager = DALLocator.getDataManager();
                List ftypes = dataManager.getFeatureTypesFromDAL((byte[])data);
                if (!CollectionUtils.isEmpty((Collection)ftypes)) {
                    this.component.setMode(1);
                    this.component.put((FeatureType)((FeatureType)ftypes.get(0)).getEditable());
                    this.format = 3;
                    return;
                }
                Object ft = Json.toObject((String)new String((byte[])data, StandardCharsets.UTF_8));
                if (ft instanceof FeatureType) {
                    this.component.put((FeatureType)((FeatureType)ft).getEditable());
                    this.format = 5;
                    return;
                }
            } else {
                Object ft;
                if (data instanceof File) {
                    byte[] bytes;
                    DataManager dataManager = DALLocator.getDataManager();
                    List ftypes = dataManager.getFeatureTypesFromDAL(bytes = FileUtils.readFileToByteArray((File)((File)data)));
                    if (!CollectionUtils.isEmpty((Collection)ftypes)) {
                        this.component.put((FeatureType)((FeatureType)ftypes.get(0)).getEditable());
                        this.format = 2;
                        return;
                    }
                    String fcontents = FileUtils.readFileToString((File)((File)data), (Charset)StandardCharsets.UTF_8);
                    Object ft2 = Json.toObject((String)fcontents);
                    if (ft2 instanceof FeatureType) {
                        this.component.put((FeatureType)((FeatureType)ft2).getEditable());
                        this.format = 1;
                    }
                    return;
                }
                if (data instanceof String && (ft = Json.toObject((String)((String)data))) instanceof FeatureType) {
                    this.component.put((FeatureType)((FeatureType)ft).getEditable());
                    this.format = 0;
                    return;
                }
            }
        }
        catch (Exception ex) {
            this.format = -1;
        }
        super.setContents(data);
    }

    public Object getContents() {
        switch (this.format) {
            case 0: {
                return this.component.fetch(null).toJson().toString();
            }
            case 5: {
                return this.component.fetch(null).toJson().toString().getBytes(StandardCharsets.UTF_8);
            }
            case 3: {
                DataManager dataManager = DALLocator.getDataManager();
                return dataManager.getDALBytesFromFeatureType((FeatureType)this.component.fetch(null));
            }
        }
        return this.component.fetch(null);
    }

    public byte[] getBytes() {
        switch (this.format) {
            case 2: 
            case 3: {
                DataManager dataManager = DALLocator.getDataManager();
                return dataManager.getDALBytesFromFeatureType((FeatureType)this.component.fetch(null));
            }
        }
        return this.component.fetch(null).toJson().toString().getBytes(StandardCharsets.UTF_8);
    }
}

