/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype.tags;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.Tag;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.impl.DefaultTags;
import org.gvsig.tools.i18n.I18nManager;

public class TagsModel
extends AbstractTableModel
implements AggregateController.AggregateModel<Tag> {
    private List<Tag> tagList;
    private final String[] columnNames;

    public TagsModel(Tags tags) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.setTags(tags);
        this.columnNames = new String[]{i18n.getTranslation("_Name"), i18n.getTranslation("_Value")};
    }

    public final Tags getTags() {
        DefaultTags theTags = new DefaultTags();
        for (Tag tag : this.tagList) {
            theTags.set(tag.getName(), tag.getValue());
        }
        return theTags;
    }

    public final void setTags(Tags tags) {
        this.tagList = new ArrayList<Tag>();
        if (tags == null) {
            return;
        }
        for (String tagName : tags) {
            Tag tag = new Tag();
            tag.setName(tagName);
            tag.setValue(tags.get(tagName));
            this.tagList.add(tag);
        }
    }

    @Override
    public void fetch(Object container) {
        Tags theTags = (Tags)container;
        theTags.removeAll();
        for (Tag tag : this.tagList) {
            theTags.set(tag.getName(), tag.getValue());
        }
    }

    @Override
    public int getRowCount() {
        return this.tagList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Tag tag = this.tagList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return tag.getName();
            }
            case 1: {
                return Objects.toString(tag.getValue());
            }
        }
        return "";
    }

    @Override
    public Tag createItem() {
        return new Tag();
    }

    @Override
    public int addItem(Tag item) {
        this.tagList.add(item);
        this.fireTableDataChanged();
        return this.tagList.size() - 1;
    }

    @Override
    public void itemUpdated(int position) {
        this.fireTableDataChanged();
    }

    public Tag get(int position) {
        return this.tagList.get(position);
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tagList.iterator();
    }
}

