/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.fmap.dal.swing.impl.dataStoreParameters.DataStoreDynObjectParametersPanel;
import org.gvsig.fmap.dal.swing.impl.jdbc.DefaultJDBCConnectionDialogView;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionDialog;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJDBCConnectionDialog
extends DefaultJDBCConnectionDialogView
implements JDBCConnectionDialog {
    private static final long serialVersionUID = -5493563028200403559L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJDBCConnectionDialog.class);
    private boolean isCanceled = true;
    private JDBCConnectionPanel jdbcServerExplorer;
    private DropDown ddnMore;

    public DefaultJDBCConnectionDialog() {
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.btnAcept.setText(i18n.getTranslation("ok"));
        this.btnAcept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultJDBCConnectionDialog.this.doAcept();
            }
        });
        this.btnCancel.setText(i18n.getTranslation("cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultJDBCConnectionDialog.this.doCancel();
            }
        });
        toolsSwingManager.translate((AbstractButton)this.btnMore);
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        model.addElement(new LabeledValueImpl(i18n.getTranslation("advanced"), (Object)"advanced"));
        model.addElement(new LabeledValueImpl(i18n.getTranslation("delete"), (Object)"delete"));
        model.addElement(new LabeledValueImpl(i18n.getTranslation("load"), (Object)"load"));
        model.addElement(new LabeledValueImpl(i18n.getTranslation("save"), (Object)"save"));
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_Test_connection"), (Object)"test"));
        this.ddnMore = toolsSwingManager.createDropDown((AbstractButton)this.btnMore);
        this.ddnMore.setModel(model);
        this.ddnMore.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LabeledValue selectedItem = (LabeledValue)DefaultJDBCConnectionDialog.this.ddnMore.getSelectedItem();
                switch ((String)selectedItem.getValue()) {
                    case "advanced": {
                        DefaultJDBCConnectionDialog.this.doAdvanced();
                        break;
                    }
                    case "delete": {
                        DefaultJDBCConnectionDialog.this.doDelete();
                        break;
                    }
                    case "load": {
                        DefaultJDBCConnectionDialog.this.doLoad();
                        break;
                    }
                    case "save": {
                        DefaultJDBCConnectionDialog.this.doSave();
                        break;
                    }
                    case "test": {
                        DefaultJDBCConnectionDialog.this.doTest();
                    }
                }
            }
        });
        this.jdbcServerExplorer = DALSwingLocator.getSwingManager().createJDBCConnectionPanel();
        this.containerJDBCConnectionPanel.setLayout(new BorderLayout());
        this.containerJDBCConnectionPanel.add((Component)this.jdbcServerExplorer.asJComponent(), "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoad() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        DataManager dataManager = DALLocator.getDataManager();
        File initialPath = folderManager.getLastPath("CONNECTIONS", null);
        Object[] f = dialogs.showChooserDialog(i18n.getTranslation("_Load_connection"), 0, 0, false, initialPath, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || Objects.toString(f, "").toLowerCase().endsWith(".gvdbcon");
            }

            @Override
            public String getDescription() {
                return "Database connection (gvdbcon)";
            }
        }, true);
        if (ArrayUtils.isEmpty((Object[])f) || f[0] == null) {
            return;
        }
        folderManager.setLastPath("CONNECTIONS", ((File)f[0]).getParentFile());
        FileInputStream in = null;
        try {
            in = new FileInputStream((File)f[0]);
            PersistenceManager persistence = ToolsLocator.getPersistenceManager();
            DataServerExplorerPoolEntry entry = (DataServerExplorerPoolEntry)persistence.getObject((InputStream)in);
            LabeledValueImpl parameters = new LabeledValueImpl(entry.getName(), (Object)((JDBCServerExplorerParameters)entry.getExplorerParameters()));
            this.jdbcServerExplorer.setLabeledServerExplorerParameters((LabeledValue)parameters);
        }
        catch (Throwable th) {
            try {
                LOG.warn("Problems loading connection", th);
                dialogs.messageDialog(i18n.getTranslation("_Problems_loading_the_connection"), i18n.getTranslation("_Load_connection"), 2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        DataManager dataManager = DALLocator.getDataManager();
        String problems = this.jdbcServerExplorer.getParametersProblems();
        if (!StringUtils.isBlank((CharSequence)problems)) {
            dialogs.messageDialog(i18n.getTranslation("_Some_values_are_invalids") + "\n\n" + problems, i18n.getTranslation("_Save_connection"), 2);
            return;
        }
        LabeledValue<JDBCServerExplorerParameters> parameters = this.getLabeledServerExplorerParameters();
        if (parameters == null || parameters.getValue() == null) {
            dialogs.messageDialog(i18n.getTranslation("_There_is_no_connection_to_save"), i18n.getTranslation("_Save_connection"), 1);
            return;
        }
        File initialPath = folderManager.getLastPath("CONNECTIONS", null);
        Object[] f = dialogs.showChooserDialog(i18n.getTranslation("_Save_connection"), 1, 0, false, initialPath, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || Objects.toString(f, "").toLowerCase().endsWith(".gvdbcon");
            }

            @Override
            public String getDescription() {
                return "Database connection (gvdbcon)";
            }
        }, true);
        if (ArrayUtils.isEmpty((Object[])f) || f[0] == null) {
            return;
        }
        folderManager.setLastPath("CONNECTIONS", ((File)f[0]).getParentFile());
        Object paramsFile = f[0];
        if (!((File)f[0]).toString().toLowerCase().endsWith(".gvdbcon")) {
            paramsFile = new File(((File)f[0]).toString() + ".gvdbcon");
        }
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        DataServerExplorerPoolEntry entry = pool.createEntry(parameters.getLabel(), null, (DataServerExplorerParameters)parameters.getValue());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream((File)paramsFile);
            PersistenceManager persistence = ToolsLocator.getPersistenceManager();
            PersistentState state = persistence.getState((Object)entry);
            persistence.saveState(state, (OutputStream)out);
        }
        catch (Throwable th) {
            try {
                LOG.warn("Problems saving connection", th);
                dialogs.messageDialog(i18n.getTranslation("_Problems_saving_the_connection"), i18n.getTranslation("_Save_connection"), 2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    protected void doTest() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        try {
            String problems = this.jdbcServerExplorer.getParametersProblems();
            if (StringUtils.isBlank((CharSequence)problems)) {
                JDBCServerExplorerParameters params = this.jdbcServerExplorer.getServerExplorerParametersWithoutRegister();
                JDBCServerExplorer server = (JDBCServerExplorer)DALLocator.getDataManager().openServerExplorer(params.getProviderName(), (DataServerExplorerParameters)params);
                List tables = server.list();
                if (tables != null) {
                    if (CollectionUtils.isEmpty((Collection)tables)) {
                        dialogs.messageDialog(i18n.getTranslation("_Database_connection_established_but_table_list_could_not_be_retrieved") + "\n" + i18n.getTranslation("_In_the_case_that_the_database_contains_tables_it_is_possible_that_some_connection_parameter_is_not_correct"), i18n.getTranslation("_Connection"), 2);
                    } else {
                        dialogs.messageDialog(i18n.getTranslation("_Connection_ok"), i18n.getTranslation("_Connection"), 1);
                    }
                    return;
                }
            }
            dialogs.messageDialog(i18n.getTranslation("_Test_connection_failed") + (problems == null ? "" : "\n\n" + problems), i18n.getTranslation("_Connection"), 2);
        }
        catch (Throwable ex) {
            dialogs.messageDialog("<html>" + i18n.getTranslation("_Test_connection_failed") + "<br>\n<br>\n" + BaseException.getHTMLMessageStack((Throwable)ex) + "</html>", i18n.getTranslation("_Connection"), 2);
        }
    }

    protected void doAdvanced() {
        JDBCServerExplorerParameters myParams = this.jdbcServerExplorer.getServerExplorerParametersWithoutRegister();
        try {
            myParams.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataStoreParametersPanelManager paramsManager = DALSwingLocator.getDataStoreParametersPanelManager();
        DataStoreDynObjectParametersPanel panel = new DataStoreDynObjectParametersPanel((DynObject)myParams);
        paramsManager.showPropertiesDialog((DynObject)myParams, (DataStoreParametersPanel)panel);
        this.jdbcServerExplorer.setServerExplorerParameters(myParams);
    }

    protected void doAcept() {
        this.isCanceled = false;
        String problems = this.jdbcServerExplorer.getParametersProblems();
        if (!StringUtils.isBlank((CharSequence)problems)) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Some_values_are_invalids") + "\n\n" + problems, i18n.getTranslation("_Connection"), 2);
            return;
        }
        this.jdbcServerExplorer.getServerExplorerParametersAndRegister();
        this.setVisible(false);
    }

    protected void doCancel() {
        this.isCanceled = true;
        this.setVisible(false);
    }

    protected void doDelete() {
        this.jdbcServerExplorer.delete();
        this.jdbcServerExplorer.clear();
    }

    public void showDialog() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.showDialog(i18nManager.getTranslation("_Connection_parameters"), WindowManager.MODE.DIALOG);
    }

    public void showDialog(String title, WindowManager.MODE mode) {
        WindowManager winmgr = ToolsSwingLocator.getWindowManager();
        winmgr.showWindow((JComponent)this, title, mode);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public JDBCServerExplorerParameters getServerExplorerParameters() {
        return this.jdbcServerExplorer.getServerExplorerParametersAndRegister();
    }

    public LabeledValue<JDBCServerExplorerParameters> getLabeledServerExplorerParameters() {
        return this.jdbcServerExplorer.getLabeledServerExplorerParameters();
    }

    public String getConnectionName() {
        return this.jdbcServerExplorer.getConnectionName();
    }

    public JComponent asJComponent() {
        return this;
    }
}

