/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.jdbc;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataFactory;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.impl.jdbc.DefaultJDBCConnectionPanelView;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJDBCConnectionPanel
extends DefaultJDBCConnectionPanelView
implements JDBCConnectionPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJDBCConnectionPanel.class);
    private static final long serialVersionUID = -6119489353793596382L;
    private JDBCServerExplorerParameters forcedParameters;
    private ItemListener onChangeConnectorItemListener;
    private JDBCConnectionPanel.ConnectorFilter connectorFilter = null;

    public JComponent asJComponent() {
        return this;
    }

    public DefaultJDBCConnectionPanel() {
        this.initComponents();
    }

    protected void initComponents() {
        this.cboConnections.setEditable(true);
        this.cboConnections.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                SwingUtilities.invokeLater(() -> DefaultJDBCConnectionPanel.this.onChangeConnection());
            }
        });
        this.cboConnections.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DefaultJDBCConnectionPanel.this.doSearchConnection();
                }
            }
        });
        this.onChangeConnectorItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                SwingUtilities.invokeLater(() -> DefaultJDBCConnectionPanel.this.onChangeConnector());
            }
        };
        this.cboConnectors.addItemListener(this.onChangeConnectorItemListener);
        try {
            this.fillConnections();
            this.fillConnectors();
        }
        catch (Throwable th) {
            LOGGER.warn("Can't fill combos", th);
        }
        this.translate();
        this.btnDataBaseBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJDBCConnectionPanel.this.onBrowseDatabase();
            }
        });
        this.adjustPreferedHeight(this.lblFoother, 300);
        Dimension sz = this.getPreferredSize();
        if (sz.width < 400) {
            sz.width = 400;
            this.setPreferredSize(sz);
        }
    }

    private void doSearchConnection() {
        Object x = this.cboConnections.getSelectedItem();
        if (x instanceof LabeledValue) {
            this.onChangeConnection();
            return;
        }
        if (x instanceof CharSequence) {
            String s = x.toString();
            for (int i = 0; i < this.cboConnections.getItemCount(); ++i) {
                LabeledValue n = (LabeledValue)this.cboConnections.getItemAt(i);
                if (n == null || !StringUtils.containsIgnoreCase((CharSequence)n.getLabel(), (CharSequence)s)) continue;
                this.cboConnections.setSelectedItem(n);
                return;
            }
        }
    }

    private void adjustPreferedHeight(JLabel label, int prefWidth) {
        JLabel resizer = new JLabel();
        resizer.setText(label.getText());
        View view = (View)resizer.getClientProperty("html");
        view.setSize(prefWidth, 15.0f);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        Dimension dim = new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
        label.setPreferredSize(dim);
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblFile.setText(i18nManager.getTranslation("_File"));
        this.lblConnectionName.setText(i18nManager.getTranslation("_Connection_name"));
        this.lblConnector.setText(i18nManager.getTranslation("_Driver_type"));
        this.lblServer.setText(i18nManager.getTranslation("_Host"));
        this.lblPort.setText(i18nManager.getTranslation("_Port"));
        this.lblDataBase.setText(i18nManager.getTranslation("_Database"));
        this.lblUsername.setText(i18nManager.getTranslation("_User"));
        this.lblPassword.setText(i18nManager.getTranslation("_Password"));
        this.lblFoother.setText("<html>" + i18nManager.getTranslation("_JDBCConecctionPanel_foother") + "</html>");
    }

    public void setLabeledServerExplorerParameters(LabeledValue<JDBCServerExplorerParameters> parameters) {
        if (parameters == null) {
            return;
        }
        if (parameters.getValue() != null) {
            this.setServerExplorerParameters((JDBCServerExplorerParameters)parameters.getValue());
        }
        if (!StringUtils.isBlank((CharSequence)parameters.getLabel())) {
            this.cboConnections.setSelectedItem(parameters.getLabel());
        }
    }

    public void setServerExplorerParameters(JDBCServerExplorerParameters parameters) {
        this.forcedParameters = (JDBCServerExplorerParameters)parameters.getCopy();
        int indexConnector = this.getIndexOfConnector(parameters);
        if (indexConnector >= 0 && this.cboConnectors.getSelectedIndex() != indexConnector) {
            this.cboConnectors.removeItemListener(this.onChangeConnectorItemListener);
            this.cboConnectors.setSelectedIndex(indexConnector);
            this.cboConnectors.addItemListener(this.onChangeConnectorItemListener);
        }
        this.txtServer.setText(parameters.getHost());
        Integer port = parameters.getPort();
        if (port == null) {
            this.txtPort.setText("");
        } else {
            this.txtPort.setText(String.valueOf(port));
        }
        this.txtDataBase.setText(parameters.getDBName());
        this.txtUsername.setText(parameters.getUser());
        this.txtPassword.setText(parameters.getPassword());
        DynClass definition = parameters.getDynClass();
        DynField field = definition.getDynField("host");
        this.txtServer.setEnabled(!field.isReadOnly() && !field.isHidden());
        field = definition.getDynField("port");
        this.txtPort.setEnabled(!field.isReadOnly() && !field.isHidden());
        field = definition.getDynField("dbname");
        this.txtDataBase.setEnabled(!field.isReadOnly() && !field.isHidden());
        field = definition.getDynField("dbuser");
        this.txtUsername.setEnabled(!field.isReadOnly() && !field.isHidden());
        field = definition.getDynField("password");
        this.txtPassword.setEnabled(!field.isReadOnly() && !field.isHidden());
        if (parameters instanceof FilesystemStoreParameters) {
            File f = ((FilesystemStoreParameters)parameters).getFile();
            if (f == null) {
                this.txtFile.setText("");
            } else {
                this.txtFile.setText(f.getAbsolutePath());
            }
            this.btnDataBaseBrowser.setVisible(true);
            this.txtFile.setVisible(true);
            this.lblFile.setVisible(true);
        } else {
            this.btnDataBaseBrowser.setVisible(false);
            this.txtFile.setVisible(false);
            this.lblFile.setVisible(false);
        }
    }

    public JDBCServerExplorerParameters getServerExplorerParametersAndRegister() {
        JDBCServerExplorerParameters params = this.getServerExplorerParametersWithoutRegister();
        this.addServerExplorerParametersToThePool(this.getConnectionName(), params);
        return params;
    }

    public JDBCServerExplorerParameters getServerExplorerParametersWithoutRegister() {
        int n;
        JDBCServerExplorerParameters connector = this.getConnector();
        if (connector == null) {
            return null;
        }
        JDBCServerExplorerParameters params = this.forcedParameters == null ? (JDBCServerExplorerParameters)connector.getCopy() : (JDBCServerExplorerParameters)this.forcedParameters.getCopy();
        String s = this.getServer();
        if (s != null) {
            params.setHost(s);
        }
        if ((n = this.getPort()) > 0) {
            params.setPort(n);
        }
        if ((s = this.getDataBaseName()) != null) {
            params.setDBName(s);
        }
        if ((s = this.getUsername()) != null) {
            params.setUser(s);
        }
        if ((s = this.getPassword()) != null) {
            params.setPassword(s);
        }
        return params;
    }

    public void addServerExplorerParametersToThePool(String name, JDBCServerExplorerParameters params) {
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        pool.add(name, (DataServerExplorerParameters)params);
    }

    public LabeledValue<JDBCServerExplorerParameters> getLabeledServerExplorerParameters() {
        JDBCServerExplorerParameters params = this.getServerExplorerParametersAndRegister();
        if (params == null) {
            return null;
        }
        String name = this.getConnectionName();
        if (StringUtils.isBlank((CharSequence)name)) {
            File f;
            if (params instanceof FilesystemStoreParameters && (f = ((FilesystemStoreParameters)params).getFile()) != null) {
                name = FilenameUtils.getBaseName((String)f.getPath());
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                StringBuilder builder = new StringBuilder();
                builder.append(Objects.toString(params.getHost(), ""));
                if (builder.length() > 0 && !builder.toString().endsWith("-")) {
                    builder.append("-");
                }
                builder.append(Objects.toString(params.getPort(), ""));
                if (builder.length() > 0 && !builder.toString().endsWith("-")) {
                    builder.append("-");
                }
                builder.append(Objects.toString(params.getDBName(), ""));
                name = builder.toString();
            }
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = this.getUniqueEntryName("Connection");
        } else if (this.isNewConnection()) {
            name = this.getUniqueEntryName(name);
        }
        return new LabeledValueImpl(name, (Object)params);
    }

    public boolean areTheParametersValid() {
        try {
            JDBCServerExplorerParameters params = this.getServerExplorerParametersWithoutRegister();
            params.validate();
            return true;
        }
        catch (ValidateDataParametersException ex) {
            return false;
        }
    }

    public String getParametersProblems() {
        try {
            I18nManager i18n = ToolsLocator.getI18nManager();
            JDBCServerExplorerParameters params = this.getServerExplorerParametersWithoutRegister();
            if (params == null) {
                return i18n.getTranslation("You need to select a connector");
            }
            params.validate();
            return null;
        }
        catch (ValidateDataParametersException ex) {
            return ex.getLocalizedMessageStack();
        }
    }

    private String getUniqueEntryName(String name) {
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        String baseName = name;
        for (int i = 0; i < 1000; ++i) {
            if (!pool.contains(name)) {
                return name;
            }
            name = baseName + "-" + i;
        }
        return name + System.currentTimeMillis();
    }

    protected void setConnectionName(String connectionName) {
        JTextField txtConnections = (JTextField)this.cboConnections.getEditor().getEditorComponent();
        txtConnections.setText(connectionName);
    }

    public String getConnectionName() {
        Object value = this.cboConnections.getSelectedItem();
        String name = (String)StringUtils.defaultIfBlank((CharSequence)Objects.toString(value, null), null);
        if (StringUtils.isBlank((CharSequence)name)) {
            name = this.getUniqueEntryName("Connection");
        } else if (this.isNewConnection()) {
            name = this.getUniqueEntryName(name);
        }
        return name;
    }

    public boolean isNewConnection() {
        Object value = this.cboConnections.getSelectedItem();
        String name = (String)StringUtils.defaultIfBlank((CharSequence)Objects.toString(value, null), null);
        if (name == null) {
            return true;
        }
        ComboBoxModel model = this.cboConnections.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValue conn = (LabeledValue)model.getElementAt(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)conn.getLabel())) continue;
            return false;
        }
        return true;
    }

    protected JDBCServerExplorerParameters getConnector() {
        LabeledValue item = (LabeledValue)this.cboConnectors.getSelectedItem();
        if (item == null) {
            return null;
        }
        return (JDBCServerExplorerParameters)item.getValue();
    }

    protected String getConnectorName() {
        JDBCServerExplorerParameters value = this.getConnector();
        if (value == null) {
            return null;
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)value.getExplorerName(), null);
    }

    protected String getServer() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtServer.getText(), null);
    }

    protected int getPort() {
        int ivalue;
        String svalue = (String)StringUtils.defaultIfBlank((CharSequence)this.txtPort.getText(), null);
        try {
            ivalue = Integer.parseInt(svalue);
        }
        catch (Exception ex) {
            ivalue = -1;
        }
        return ivalue;
    }

    protected String getDataBaseName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtDataBase.getText(), null);
    }

    protected String getUsername() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtUsername.getText(), null);
    }

    protected String getPassword() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtPassword.getText(), null);
    }

    private void onChangeConnector() {
        LabeledValue item = (LabeledValue)this.cboConnectors.getSelectedItem();
        if (item == null) {
            return;
        }
        JDBCServerExplorerParameters connector = (JDBCServerExplorerParameters)item.getValue();
        if (connector == null) {
            return;
        }
        this.setServerExplorerParameters(connector);
    }

    private void onChangeConnection() {
        Object value = this.cboConnections.getSelectedItem();
        if (value instanceof LabeledValue) {
            LabeledValue item = (LabeledValue)value;
            JDBCServerExplorerParameters connection = (JDBCServerExplorerParameters)item.getValue();
            if (connection == null) {
                return;
            }
            this.setServerExplorerParameters(connection);
        }
    }

    private int getIndexOfConnector(JDBCServerExplorerParameters explorerParameters) {
        String code = null;
        try {
            code = explorerParameters.toString();
            ComboBoxModel model = this.cboConnectors.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LabeledValue x = (LabeledValue)model.getElementAt(i);
                if (x == null || x.getValue() == null || !((JDBCServerExplorerParameters)x.getValue()).getExplorerName().equalsIgnoreCase(explorerParameters.getExplorerName())) continue;
                return i;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get index of exporer parameter '" + code + "'.", (Throwable)ex);
        }
        return -1;
    }

    public void setConnectorFilter(JDBCConnectionPanel.ConnectorFilter connectorFilter) {
        this.connectorFilter = connectorFilter;
        this.fillConnections();
        this.fillConnectors();
    }

    private void fillConnectors() {
        DataManager dataManager = DALLocator.getDataManager();
        LabeledValueImpl last = null;
        this.cboConnectors.removeAllItems();
        this.cboConnectors.addItem(new LabeledValueImpl("", (Object)null));
        for (DataFactory factory : dataManager.getServerExplorerRegister()) {
            DataServerExplorerParameters params;
            if (factory.isHidden() || !((params = (DataServerExplorerParameters)factory.createParameters()) instanceof JDBCServerExplorerParameters) || this.connectorFilter != null && !this.connectorFilter.accept((JDBCServerExplorerParameters)params)) continue;
            if (params.getClass() == JDBCServerExplorerParameters.class && last == null) {
                last = new LabeledValueImpl(factory.getDescription(), (Object)((JDBCServerExplorerParameters)params));
                continue;
            }
            this.cboConnectors.addItem(new LabeledValueImpl(factory.getDescription(), (Object)((JDBCServerExplorerParameters)params)));
        }
        if (last != null) {
            this.cboConnectors.addItem(last);
        }
    }

    private void fillConnections() {
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        this.cboConnections.removeAllItems();
        for (DataServerExplorerPoolEntry entry : pool) {
            if (!(entry.getExplorerParameters() instanceof JDBCServerExplorerParameters) || this.connectorFilter != null && !this.connectorFilter.accept((JDBCServerExplorerParameters)entry.getExplorerParameters())) continue;
            JDBCServerExplorerParameters dbParams = (JDBCServerExplorerParameters)entry.getExplorerParameters();
            this.cboConnections.addItem(new LabeledValueImpl(entry.getName(), (Object)dbParams));
        }
        this.cboConnections.setSelectedIndex(-1);
    }

    public void delete() {
        String name = this.getConnectionName();
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        pool.remove(name);
        this.fillConnections();
    }

    public void clear() {
        this.cboConnections.setSelectedIndex(-1);
        this.cboConnectors.setSelectedIndex(-1);
        this.txtServer.setText("");
        this.txtPort.setText("");
        this.txtDataBase.setText("");
        this.txtUsername.setText("");
        this.txtPassword.setText("");
        this.txtFile.setText("");
    }

    private void onBrowseDatabase() {
        I18nManager i18nManager;
        if (this.forcedParameters == null) {
            return;
        }
        ThreadSafeDialogsManager dlgmanager = ToolsSwingLocator.getThreadSafeDialogsManager();
        Object[] files = dlgmanager.showOpenFileDialog((i18nManager = ToolsLocator.getI18nManager()).getTranslation("_Select_database"), null);
        if (ArrayUtils.isEmpty((Object[])files)) {
            return;
        }
        File f = new File(((File)files[0]).getPath());
        ((FilesystemStoreParameters)this.forcedParameters).setFile(f);
        this.txtFile.setText(((FilesystemStoreParameters)this.forcedParameters).getFile().getAbsolutePath());
    }
}

