/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchpanel;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.swing.featuretable.SimpleFeaturesTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTSV {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportTSV.class);
    private static final String CELL_SEPARATOR = "\t";
    private static final String STRING_DELIMITER = "\"";
    private static final String STRING_DELIMITER_REPLACE = "\"\"";
    private static final String LINE_BREAK = System.lineSeparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void process(Iterator<Feature> featIterator, long countElements, SimpleFeaturesTableModel tableModel, File file, Charset charset, SimpleTaskStatus status) {
        FileOutputStream fos = null;
        try {
            if (file.exists()) {
                file.delete();
            } else {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            this.process(featIterator, countElements, tableModel, fos, charset, status);
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(fos);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Iterator<Feature> featIterator, long countElements, SimpleFeaturesTableModel tableModel, OutputStream fos, Charset charset, SimpleTaskStatus status) {
        OutputStreamWriter writer = null;
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(fos);
            writer = new OutputStreamWriter((OutputStream)bos, charset != null ? charset : Charset.defaultCharset());
            ArrayList<String> items = new ArrayList<String>();
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                String column = tableModel.getColumnName(i);
                items.add(column);
            }
            String line = String.join((CharSequence)CELL_SEPARATOR, items);
            writer.append(line);
            writer.append(LINE_BREAK);
            status.setRangeOfValues(0L, countElements);
            status.setCurValue(0L);
            while (true) {
                Feature feature;
                block12: {
                    block11: {
                        block10: {
                            if (!featIterator.hasNext()) break block10;
                            feature = featIterator.next();
                            if (status.isCancellationRequested()) break block11;
                            items = new ArrayList();
                            break block12;
                        }
                        status.setTitle(ToolsLocator.getI18nManager().getTranslation("_Export_ended"));
                        status.terminate();
                        IOUtils.closeQuietly((Writer)writer);
                        IOUtils.closeQuietly((OutputStream)bos);
                        return;
                    }
                    status.cancel();
                    status.setTitle(ToolsLocator.getI18nManager().getTranslation("_Export_cancelled"));
                    IOUtils.closeQuietly((Writer)writer);
                    IOUtils.closeQuietly((OutputStream)bos);
                    return;
                }
                for (int c = 0; c < tableModel.getColumnCount(); ++c) {
                    String s;
                    Object value = tableModel.getValueAt(feature, c);
                    if (value instanceof String) {
                        s = (String)value;
                        s = s.replace(CELL_SEPARATOR, " ").replace(STRING_DELIMITER, STRING_DELIMITER_REPLACE).replace("\n", " ").replace("\r", " ");
                        s = STRING_DELIMITER + s + STRING_DELIMITER;
                    } else {
                        FeatureAttributeDescriptor attr = tableModel.getFeatureDescriptor(c);
                        s = attr != null ? attr.format(value) : (value instanceof Number ? ((Number)value).toString() : (value != null ? value.toString() : ""));
                    }
                    items.add(s);
                }
                line = String.join((CharSequence)CELL_SEPARATOR, items);
                writer.append(line);
                writer.append(LINE_BREAK);
                status.incrementCurrentValue();
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Not able to export table to TSV", (Throwable)ex);
                status.abort();
                status.setTitle(ToolsLocator.getI18nManager().getTranslation("_Export_aborted"));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((OutputStream)bos);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)bos);
            return;
        }
    }
}

