/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.visualdbmodeler;

import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.swing.impl.visualdbmodeler.JTableRenderer;
import org.gvsig.fmap.dal.swing.impl.visualdbmodeler.TableDescriptor;
import org.gvsig.fmap.dal.swing.impl.visualdbmodeler.TableDescriptorImpl;
import org.gvsig.fmap.dal.swing.impl.visualdbmodeler.VisualdbmodelerView;

public class Visualdbmodeler
extends VisualdbmodelerView {
    private SchemaGraphComponent schemaGraphComponent;

    public Visualdbmodeler() {
        this.initComponents();
    }

    private void initComponents() {
        DataManager dataManager = DALLocator.getDataManager();
        ArrayList<StoresRepository> repositories = new ArrayList<StoresRepository>();
        for (StoresRepository repo : dataManager.getStoresRepository().getSubrepositories()) {
            repositories.add(repo);
        }
        repositories.sort((o1, o2) -> o1.getLabel().compareTo(o2.getLabel()));
        DefaultComboBoxModel<StoresRepository> model = new DefaultComboBoxModel<StoresRepository>();
        for (StoresRepository repository : repositories) {
            model.addElement(repository);
        }
        this.cboRepositories.setModel(model);
        this.cboRepositories.addActionListener(e -> this.doChangeRepository());
        this.lstTables.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 2 || e.getClickCount() == 2) {
                    Visualdbmodeler.this.doAddTable();
                }
            }
        });
    }

    private StoresRepository getStoresRepository() {
        StoresRepository repo = (StoresRepository)this.cboRepositories.getSelectedItem();
        return repo;
    }

    private TableDescriptor getTable() {
        TableDescriptor table = (TableDescriptor)this.lstTables.getSelectedValue();
        return table;
    }

    private SchemaGraphComponent getCurrentGraph() {
        return this.schemaGraphComponent;
    }

    private void doAddTable() {
        TableDescriptor table = this.getTable();
        if (table == null) {
            return;
        }
        this.getCurrentGraph().addTable(table);
    }

    private void doChangeRepository() {
        StoresRepository repository = this.getStoresRepository();
        if (repository == null) {
            return;
        }
        ArrayList<TableDescriptorImpl> tables = new ArrayList<TableDescriptorImpl>();
        for (String tableName : repository.keySetShallow()) {
            TableDescriptorImpl tableDescriptorImpl = new TableDescriptorImpl(repository.getID(), tableName, repository.getFeatureType(tableName));
            tables.add(tableDescriptorImpl);
        }
        tables.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        DefaultListModel<TableDescriptor> model = new DefaultListModel<TableDescriptor>();
        for (TableDescriptor tableDescriptor : tables) {
            model.addElement(tableDescriptor);
        }
        this.lstTables.setModel(model);
        this.schemaGraphComponent = new SchemaGraphComponent();
        this.pnlDefaultView.setLayout(new BorderLayout());
        this.pnlDefaultView.add((Component)((Object)this.schemaGraphComponent), "Center");
    }

    private static class SchemaGraphComponent
    extends mxGraphComponent {
        public SchemaGraphComponent() {
            super(new mxGraph(){

                public boolean isCellFoldable(Object cell, boolean collapse) {
                    return this.model.isVertex(cell);
                }
            });
            this.getGraph().setCellsResizable(false);
            this.setConnectable(false);
            this.getGraphHandler().setCloneEnabled(false);
            this.getGraphHandler().setImagePreview(false);
        }

        public Component[] createComponents(mxCellState state) {
            if (this.getGraph().getModel().isVertex(state.getCell())) {
                return new Component[]{new JTableRenderer(state.getCell(), this)};
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTable(TableDescriptor table) {
            mxGraph theGraph = this.getGraph();
            Object parent = theGraph.getDefaultParent();
            theGraph.getModel().beginUpdate();
            try {
                mxCell v1 = (mxCell)theGraph.insertVertex(parent, null, (Object)table, 20.0, 20.0, 200.0, 280.0);
                v1.getGeometry().setAlternateBounds(new mxRectangle(0.0, 0.0, 140.0, 25.0));
            }
            finally {
                theGraph.getModel().endUpdate();
            }
        }
    }
}

