/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangesObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileChangesObserver.class);
    private static FileChangesObserver INSTANCE = null;
    private final List<FileObserver> fileObservers = new ArrayList<FileObserver>();
    private final Process process = new Process();

    public static FileChangesObserver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FileChangesObserver();
        }
        return INSTANCE;
    }

    private FileChangesObserver() {
        this.process.start();
    }

    private int getWatchCounts(Path folder) {
        int count = 0;
        for (FileObserver fo : this.fileObservers) {
            if (!folder.equals(fo.getFolder())) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer observer, File file) {
        List<FileObserver> list = this.fileObservers;
        synchronized (list) {
            for (FileObserver fileObserver : this.fileObservers) {
                if (!fileObserver.is(observer, file)) continue;
                return;
            }
            this.removeDeads();
            FileObserver fobserver = new FileObserver(file, observer);
            this.process.reqisterWatch(fobserver.getFolder());
            this.fileObservers.add(fobserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer observer) {
        List<FileObserver> list = this.fileObservers;
        synchronized (list) {
            for (FileObserver fileObserver : this.fileObservers) {
                if (!fileObserver.is(observer)) continue;
                this.fileObservers.remove(fileObserver);
                if (this.getWatchCounts(fileObserver.getFolder()) < 1) {
                    this.process.cancelWatch(fileObserver.getFolder());
                }
                return;
            }
            this.removeDeads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeDeads() {
        List<FileObserver> list = this.fileObservers;
        synchronized (list) {
            int deads = 0;
            for (FileObserver fileObserver : this.fileObservers) {
                if (!fileObserver.isDead()) continue;
                ++deads;
            }
            if (deads == 0) {
                return;
            }
            if (deads >= this.fileObservers.size()) {
                this.fileObservers.clear();
                return;
            }
            ArrayList<FileObserver> lives = new ArrayList<FileObserver>(this.fileObservers.size() - deads);
            for (FileObserver fileObserver : this.fileObservers) {
                if (fileObserver.isDead()) {
                    if (this.getWatchCounts(fileObserver.getFolder()) >= 1) continue;
                    this.process.cancelWatch(fileObserver.getFolder());
                    continue;
                }
                lives.add(fileObserver);
            }
            this.fileObservers.clear();
            this.fileObservers.addAll(lives);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObservers() {
        List<FileObserver> x;
        List<FileObserver> list = this.fileObservers;
        synchronized (list) {
            x = this.fileObservers;
            this.fileObservers.clear();
        }
        for (FileObserver fileObserver : x) {
            this.process.cancelWatch(fileObserver.getFolder());
        }
    }

    static /* synthetic */ List access$100(FileChangesObserver x0) {
        return x0.fileObservers;
    }

    private class Process
    extends Thread {
        private WatchService watcher;
        private final Map<String, WatchKey> folders;

        public Process() {
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            catch (Throwable ex) {
                LOGGER.warn("Can't create WatchService.", ex);
                this.watcher = null;
            }
            this.folders = new HashMap<String, WatchKey>();
            this.setName("ScriptingFilesChangesObserver");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (this.watcher == null) {
                return;
            }
            block15: while (true) {
                try {
                    key = this.watcher.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                if (key == null) continue;
                folder = (Path)key.watchable();
                if (!key.isValid()) {
                    pathname = folder.toFile().getAbsolutePath();
                    var4_6 = this.folders;
                    synchronized (var4_6) {
                        this.folders.remove(pathname);
                    }
                    try {
                        key.cancel();
                    }
                    catch (Throwable th) {
                        FileChangesObserver.access$000().debug("Cat cancel watch on '" + (String)pathname + "'.", th);
                    }
                    continue;
                }
                try {
                    pathname = key.pollEvents().iterator();
                    block16: while (true) {
                        if (!pathname.hasNext()) continue block15;
                        event = (WatchEvent)pathname.next();
                        kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        ev = event;
                        filename = (Path)ev.context();
                        child = folder.resolve(filename);
                        toNotify = new ArrayList<FileObserver>();
                        var10_14 = FileChangesObserver.access$100(FileChangesObserver.this);
                        synchronized (var10_14) {
                            for (FileObserver fileObserver : FileChangesObserver.access$100(FileChangesObserver.this)) {
                                if (!FileObserver.access$200(fileObserver, child)) continue;
                                toNotify.add(fileObserver);
                            }
                        }
                        var10_14 = toNotify.iterator();
                        while (true) {
                            if (var10_14.hasNext()) ** break;
                            continue block16;
                            fileObserver = (FileObserver)var10_14.next();
                            fileObserver.notifyObserver();
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    FileChangesObserver.access$000().warn("Can't process watch event.", (Throwable)ex);
                    continue;
                }
                finally {
                    key.reset();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reqisterWatch(Path folder) {
            Map<String, WatchKey> map = this.folders;
            synchronized (map) {
                String pathname = folder.toFile().getAbsolutePath();
                WatchKey watchkey = this.folders.get(pathname);
                if (watchkey != null) {
                    return;
                }
                try {
                    watchkey = folder.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    this.folders.put(pathname, watchkey);
                }
                catch (IOException x) {
                    LOGGER.warn("Can't add watch on path '" + Objects.toString(folder), (Throwable)x);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelWatch(Path folder) {
            Map<String, WatchKey> map = this.folders;
            synchronized (map) {
                String pathname = folder.toFile().getAbsolutePath();
                WatchKey watchkey = this.folders.get(pathname);
                if (watchkey == null) {
                    return;
                }
                this.folders.remove(pathname);
                try {
                    watchkey.cancel();
                }
                catch (Throwable th) {
                    LOGGER.debug("Cat cancel watch on '" + pathname + "'.", th);
                }
            }
        }
    }

    private class FileObserver
    implements Observable {
        private final Path folder;
        private final WeakReference<Observer> observer;
        private File file;

        public FileObserver(File file, Observer observer) {
            try {
                this.file = file.getCanonicalFile();
            }
            catch (IOException ex) {
                this.file = file.getAbsoluteFile();
            }
            this.observer = new WeakReference<Observer>(observer);
            FileSystem fs = FileSystems.getDefault();
            this.folder = file.isDirectory() ? fs.getPath(file.getAbsolutePath(), new String[0]) : fs.getPath(file.getParentFile().getAbsolutePath(), new String[0]);
        }

        public Path getFolder() {
            return this.folder;
        }

        public File getFile() {
            return this.file;
        }

        public void notifyObserver() {
            Observer obs = (Observer)this.observer.get();
            if (obs == null) {
                return;
            }
            obs.update((Observable)this, (Object)this.file);
        }

        private boolean is(Observer observer) {
            Observer obs = (Observer)this.observer.get();
            if (obs == null) {
                return false;
            }
            return obs == observer;
        }

        private boolean is(Observer observer, File file) {
            Observer obs = (Observer)this.observer.get();
            if (obs == null || obs != observer) {
                return false;
            }
            return this.file.equals(file);
        }

        private boolean is(Path file) {
            File f = file.toAbsolutePath().toFile();
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ex) {
                f = f.getAbsoluteFile();
            }
            return this.file.equals(f);
        }

        private boolean isDead() {
            Observer obs = (Observer)this.observer.get();
            return obs == null;
        }

        public void addObserver(Observer obsrvr) {
            FileChangesObserver.this.addObserver(obsrvr, this.file);
        }

        public void deleteObserver(Observer obsrvr) {
            FileChangesObserver.this.deleteObserver(obsrvr);
        }

        public void deleteObservers() {
            FileChangesObserver.this.deleteObservers();
        }

        static /* synthetic */ boolean access$200(FileObserver x0, Path x1) {
            return x0.is(x1);
        }
    }
}

