/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;

public class ChangeListenerSupport {
    protected Set<PropertyChangeListener> changeListeners;
    protected boolean enabled = true;

    public void addChangeListener(PropertyChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet<PropertyChangeListener>();
        }
        this.changeListeners.add(listener);
    }

    public void fireChange(PropertyChangeEvent evt) {
        if (this.changeListeners == null || !this.enabled) {
            return;
        }
        for (PropertyChangeListener listener : this.changeListeners) {
            listener.propertyChange(evt);
        }
    }

    public void fireChange(String name, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, name, "", newValue);
        this.fireChange(evt);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean enabled) {
        boolean prev = this.enabled;
        this.enabled = enabled;
        return prev;
    }
}

