/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.io.File;
import javax.swing.tree.TreePath;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;

public class JMoveScriptModel {
    public static final int ACTION_CANCEL = 0;
    public static final int ACTION_ACCEPT = 1;
    private ScriptingUnit unit;
    private File moveTo;
    private int action;
    private ScriptingManager manager;
    private TreePath initialSelectedPath;
    private boolean overwrite;

    public JMoveScriptModel(ScriptingManager manager, ScriptingUnit unit) {
        this.manager = manager;
        this.unit = unit;
        this.overwrite = false;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void validate() throws Exception {
        ScriptingFolder folder;
        File file = this.getMoveTo();
        if (file == null) {
            throw new Exception("Destination must not be empty.");
        }
        if (file.exists()) {
            if (!this.overwrite) {
                throw new Exception("A file existst in the destination folder.");
            }
            if (!file.canWrite()) {
                throw new Exception("Can't write in the destination folder.");
            }
        }
        if (!this.manager.validateUnitId(folder = this.manager.getFolder(file), this.getUnit().getId())) {
            throw new Exception("This file already exists.\nWrite another name for the script");
        }
    }

    public void setAction(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public void setMoveTo(File moveTo) {
        this.moveTo = moveTo;
    }

    public void setMoveTo(String moveTo) {
        this.moveTo = new File(moveTo);
    }

    public File getMoveTo() {
        return this.moveTo;
    }

    public ScriptingUnit getUnit() {
        return this.unit;
    }

    void setSelectionPath(TreePath path) {
        this.initialSelectedPath = path;
    }

    TreePath getSelectionPath() {
        return this.initialSelectedPath;
    }
}

