/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.impl.DefaultJScriptingBrowser;
import org.gvsig.scripting.swing.impl.DialogPanel;
import org.gvsig.scripting.swing.impl.composer.JNewScriptModel;
import org.gvsig.scripting.swing.impl.composer.JNewScriptPanelLayout;
import org.gvsig.tools.swing.api.ListElement;

public class JNewScriptPanel
extends JNewScriptPanelLayout
implements DialogPanel {
    private static final long serialVersionUID = -3455272930442207085L;
    private final ScriptingUIManager uimanager;
    private final ScriptingManager manager;
    private final JNewScriptModel model;
    private final DefaultJScriptingBrowser jbrowser;
    private File saveToFile;

    public JNewScriptPanel(ScriptingUIManager uimanager, JNewScriptModel model, boolean folder) {
        this.uimanager = uimanager;
        this.manager = this.uimanager.getManager();
        this.model = model;
        model.setAction(0);
        this.description.setFocusTraversalKeys(0, null);
        this.description.setFocusTraversalKeys(1, null);
        Set<AWTKeyStroke> forwardKeys = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        this.setFocusTraversalKeys(0, newForwardKeys);
        List langs = this.manager.getSupportedLanguages();
        DefaultComboBoxModel<ListElement> languagesModel = new DefaultComboBoxModel<ListElement>();
        int selected = 0;
        for (int i = 0; i < langs.size(); ++i) {
            String lang = (String)langs.get(i);
            if (lang.equalsIgnoreCase("r")) {
                languagesModel.addElement(new ListElement(lang, (Object)lang));
                continue;
            }
            if (lang.equalsIgnoreCase("python")) {
                languagesModel.addElement(new ListElement(lang, (Object)lang));
                selected = i;
                continue;
            }
            languagesModel.addElement(new ListElement(lang + " (without support)", (Object)lang));
        }
        this.languages.setModel(languagesModel);
        this.languages.setSelectedIndex(selected);
        this.units.setModel(new DefaultComboBoxModel<Object>(this.manager.getUnitTypes().toArray()));
        this.units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((JComboBox)arg0.getSource()).getSelectedItem().equals("Folder")) {
                    JNewScriptPanel.this.languages.setEnabled(false);
                    JNewScriptPanel.this.createdBy.setEditable(false);
                    JNewScriptPanel.this.version.setEditable(false);
                } else {
                    JNewScriptPanel.this.languages.setEnabled(true);
                    JNewScriptPanel.this.createdBy.setEditable(true);
                    JNewScriptPanel.this.version.setEditable(true);
                }
            }
        });
        this.saveToFile = this.manager.getRootUserFolder();
        this.saveTo.setText(this.manager.getUserFolder().getUserPath());
        this.jbrowser = new DefaultJScriptingBrowser(this.uimanager, this.manager.getUserFolder(), true);
        this.jbrowser.setPreferredSize(new Dimension(250, 100));
        this.saveToPanel.setLayout(new BorderLayout());
        this.saveToPanel.add((Component)this.jbrowser, "Center");
        this.jbrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getID() == 2) {
                    JNewScriptPanel.this.doFolderSelection();
                }
            }
        });
        this.jbrowser.setSelectionPath(this.model.getSelectionPath());
        this.doFolderSelection();
        if (folder) {
            this.units.setSelectedItem("Folder");
            this.languages.setSelectedIndex(-1);
            this.units.setEnabled(false);
            this.languages.setEnabled(false);
            this.createdBy.setEditable(false);
            this.version.setEditable(false);
        }
        this.units.addItemListener(e -> {
            String type = (String)this.units.getSelectedItem();
            this.languages.setEnabled(StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"Script"));
        });
        this.name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JNewScriptPanel.this.actionAccept();
                }
            }
        });
    }

    private void doFolderSelection() {
        ScriptingUnit node = this.jbrowser.getSelectedNode();
        if (node instanceof ScriptingFolder) {
            ScriptingFolder selectedFolder = (ScriptingFolder)node;
            this.saveToFile = selectedFolder.getFile();
            this.saveTo.setText(selectedFolder.getUserPath());
        }
    }

    @Override
    public void actionAccept() {
        ListElement item;
        this.model.setType((String)this.units.getSelectedItem());
        this.model.setName(this.name.getText().trim());
        this.model.setDescription(this.description.getText().trim());
        this.model.setCreatedBy(this.createdBy.getText().trim());
        this.model.setVersion(this.version.getText().trim());
        this.model.setPath(this.saveToFile);
        if (!this.model.getType().equals("Folder") && (item = (ListElement)this.languages.getSelectedItem()) != null) {
            this.model.setLanguage((String)item.getValue());
        }
        try {
            this.model.validate();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Can't create the script\n" + e.getMessage(), "Info", 2);
            return;
        }
        this.model.setAction(1);
        this.setVisible(false);
    }

    @Override
    public void actionApply() {
    }

    @Override
    public void actionCancel() {
        this.setVisible(false);
    }

    @Override
    public boolean isVisibleAccept() {
        return true;
    }

    @Override
    public boolean isVisibleApply() {
        return false;
    }

    @Override
    public boolean isVisibleCancel() {
        return true;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }
}

