/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.swing.impl.composer.ChangeListenerSupport;
import org.gvsig.scripting.swing.impl.composer.JPropertiesFolderView;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.FolderPickerController;

public class JPropertiesFolder
extends JPropertiesFolderView {
    private final ChangeListenerSupport changeListeners = new ChangeListenerSupport();
    private FolderPickerController folderPicker;
    private boolean changed;
    private boolean rawChanges;

    public JPropertiesFolder(ScriptingFolder folder) {
        this.initComponents();
        this.set(folder);
    }

    private void initComponents() {
        this.txtName.getDocument().addDocumentListener(new DocumentChangeListener("name", this.txtName));
        this.txtDescription.getDocument().addDocumentListener(new DocumentChangeListener("description", this.txtDescription));
        this.txtCreatedBy.getDocument().addDocumentListener(new DocumentChangeListener("createdBy", this.txtCreatedBy));
        this.txtRaw.getDocument().addDocumentListener(new DocumentChangeListener("raw", this.txtRaw));
        this.txtFile.getDocument().addDocumentListener(new DocumentChangeListener("file", this.txtFile));
        this.folderPicker = ToolsSwingLocator.getToolsSwingManager().createFolderPickerController((JTextComponent)this.txtFile, this.btnFile);
    }

    private void doChange(String name, Object value) {
        this.changed = true;
        switch (name) {
            case "name": {
                this.txtRaw.setEditable(false);
                this.changeListeners.fireChange(name, value);
                break;
            }
            case "description": {
                this.txtRaw.setEditable(false);
                this.changeListeners.fireChange(name, value);
                break;
            }
            case "createdBy": {
                this.txtRaw.setEditable(false);
                this.changeListeners.fireChange(name, value);
                break;
            }
            case "file": {
                this.txtRaw.setEditable(false);
                this.changeListeners.fireChange(name, value);
                break;
            }
            case "raw": {
                this.txtCreatedBy.setEditable(false);
                this.txtDescription.setEditable(false);
                this.txtName.setEditable(false);
                this.folderPicker.setEditable(false);
                this.changeListeners.fireChange(name, value);
                this.rawChanges = true;
            }
        }
    }

    public void set(ScriptingFolder unit) {
        boolean enabled = this.changeListeners.setEnabled(false);
        try {
            this.txtName.setEditable(true);
            this.txtDescription.setEditable(true);
            this.txtCreatedBy.setEditable(true);
            this.txtName.setText(unit.getName());
            this.txtDescription.setText(unit.getDescription());
            this.txtCreatedBy.setText(unit.getCreatedBy());
            this.txtRaw.setText(unit.getRawInf());
            this.folderPicker.set((Object)unit.getFile());
            this.folderPicker.setEditable(unit.isLink());
            this.txtIconName.setText(unit.getIconNames()[0]);
            this.txtIconNameOpen.setText(unit.getIconNames()[1]);
            this.setChanged(false);
        }
        finally {
            this.changeListeners.setEnabled(enabled);
        }
    }

    public void fectch(ScriptingFolder unit) {
        if (this.hasRawChanges()) {
            unit.setRawInf(this.txtRaw.getText());
        } else {
            unit.setName(this.txtName.getText());
            unit.setDescription(this.txtDescription.getText());
            unit.setCreatedBy(this.txtCreatedBy.getText());
            unit.setIconNames(this.txtIconName.getText(), this.txtIconNameOpen.getText());
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addChangeListener(listener);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean hasChanges) {
        this.changed = hasChanges;
        this.rawChanges = hasChanges;
        if (!hasChanges) {
            this.txtName.setEnabled(true);
            this.txtDescription.setEnabled(true);
            this.txtCreatedBy.setEnabled(true);
            this.txtRaw.setEnabled(true);
            this.folderPicker.setEnabled(true);
            this.txtName.setEditable(true);
            this.txtDescription.setEditable(true);
            this.txtCreatedBy.setEditable(true);
            this.txtRaw.setEditable(true);
        }
    }

    private boolean hasRawChanges() {
        return this.rawChanges;
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private final String name;
        private final JTextComponent text;

        public DocumentChangeListener(String name, JTextComponent text) {
            this.name = name;
            this.text = text;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JPropertiesFolder.this.doChange(this.name, this.text.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JPropertiesFolder.this.doChange(this.name, this.text.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JPropertiesFolder.this.doChange(this.name, this.text.getText());
        }
    }
}

