/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.impl.composer.components.JTabbedPaneClosable;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class DefaultJTabbedPaneClosable
extends JTabbedPane
implements JTabbedPaneClosable {
    private static final long serialVersionUID = -3995298424891579555L;
    private final ActionListenerSupport closeTabListeners;
    private final ScriptingUIManager uimanager;

    public static JTabbedPaneClosable create(ScriptingUIManager uimanager) {
        DefaultJTabbedPaneClosable tab = new DefaultJTabbedPaneClosable(uimanager);
        return tab;
    }

    private DefaultJTabbedPaneClosable(ScriptingUIManager uimanager) {
        this.uimanager = uimanager;
        this.closeTabListeners = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
    }

    @Override
    public JTabbedPane asJComponent() {
        return this;
    }

    @Override
    public String getTitleAt(int index) {
        TabTitleComponent title = (TabTitleComponent)this.getTabComponentAt(index);
        if (title == null) {
            return null;
        }
        return title.getTitle();
    }

    @Override
    public void setTitleAt(int index, String title) {
        TabTitleComponent titleComponent = (TabTitleComponent)this.getTabComponentAt(index);
        titleComponent.setTitle(title);
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(null, component);
        int index = this.getTabCount() - 1;
        TabTitleComponent tabcomponent = new TabTitleComponent(title, ae -> {
            TabTitleComponent tabTitleComponent = (TabTitleComponent)ae.getSource();
            int index1 = this.indexOfTabComponent(tabTitleComponent);
            this.setSelectedIndex(index1);
            ae.setSource(this);
            this.closeTabListeners.fireActionEvent(ae);
        });
        super.setTabComponentAt(index, tabcomponent);
    }

    @Override
    public void removeTab(Component component) {
        super.remove(component);
    }

    @Override
    public void addCloseTabListener(ActionListener remove) {
        this.closeTabListeners.addActionListener(remove);
    }

    @Override
    public void removeCloseTabListener(ActionListener remove) {
        this.closeTabListeners.removeActionListener(remove);
    }

    @Override
    public ActionListener[] getCloseTabListeners() {
        return this.closeTabListeners.getActionListeners();
    }

    @Override
    public boolean isTabModified(int index) {
        TabTitleComponent comp = (TabTitleComponent)this.getTabComponentAt(index);
        if (comp == null) {
            return false;
        }
        return comp.isChanged();
    }

    @Override
    public void setTabModified(int index, boolean changed) {
        TabTitleComponent comp = (TabTitleComponent)this.getTabComponentAt(index);
        if (comp != null) {
            comp.setChanged(changed);
        }
    }

    private class TabTitleComponent
    extends JPanel {
        private static final long serialVersionUID = -1061417669527944341L;
        private final JLabel label;
        private final JButton button;
        private boolean changed = false;
        private final Font fontNormal;
        private final Font fontBold;
        private JPopupMenu popup;

        public TabTitleComponent(String title, ActionListener onclose) {
            this.setOpaque(true);
            this.label = new JLabel(title + " ");
            this.label.setOpaque(true);
            this.label.setBackground(UIManager.getColor("TabbedPane.tabAreaBackground"));
            this.label.setVerticalTextPosition(0);
            this.fontNormal = this.label.getFont();
            this.fontBold = new Font(this.fontNormal.getFontName(), 1, this.fontNormal.getSize());
            this.button = new JButton();
            this.button.setText("");
            this.button.setToolTipText(DefaultJTabbedPaneClosable.this.uimanager.getTranslation("Close_tab"));
            this.button.setBackground(UIManager.getColor("TabbedPane.tabAreaBackground"));
            this.button.setBorder(BorderFactory.createEmptyBorder());
            this.button.setBorderPainted(false);
            this.button.setFocusPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setCursor(new Cursor(12));
            this.button.setRolloverEnabled(true);
            this.button.setIcon(DefaultJTabbedPaneClosable.this.uimanager.getIcon("scripting-tabclose-inactive"));
            this.button.setRolloverIcon(DefaultJTabbedPaneClosable.this.uimanager.getIcon("scripting-tabclose-active"));
            this.button.addActionListener(ae -> {
                ae.setSource(this);
                onclose.actionPerformed(ae);
            });
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
            this.add((Component)this.button, "East");
            this.popup = null;
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger() || e.getButton() == 3) {
                        if (TabTitleComponent.this.popup != null) {
                            TabTitleComponent.this.popup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    } else {
                        int index = DefaultJTabbedPaneClosable.this.indexOfTabComponent(TabTitleComponent.this);
                        DefaultJTabbedPaneClosable.this.setSelectedIndex(index);
                    }
                }
            });
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }

        public String getTitle() {
            return this.label.getText();
        }

        public void setChanged(boolean changed) {
            if (changed) {
                this.label.setFont(this.fontBold);
            } else {
                this.label.setFont(this.fontNormal);
            }
            this.changed = changed;
        }

        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public void setComponentPopupMenu(JPopupMenu popup) {
            this.popup = popup;
        }
    }
}

