/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.api.SyntaxtHighlightTextComponent;
import org.gvsig.scripting.swing.impl.composer.ChangeListenerSupport;

public class BaseTextEditor
extends JPanel {
    private static final long serialVersionUID = -4217823183731699721L;
    private final ChangeListenerSupport changeListeners;
    final ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
    private SyntaxtHighlightTextComponent editorText;

    public BaseTextEditor() {
        this.changeListeners = new ChangeListenerSupport();
        this.initComponent();
    }

    public ChangeListenerSupport getChangeListenerSupport() {
        return this.changeListeners;
    }

    public void addUpdateCaretPositionActionListener(ActionListener actionlistener) {
        this.editorText.addUpdateCaretPositionActionListener(actionlistener);
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addChangeListener(listener);
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout());
        this.editorText = this.uimanager.createSyntaxHighlightingPanel();
        this.editorText.getJTextComponent().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BaseTextEditor.this.changeListeners.fireChange("code", null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BaseTextEditor.this.changeListeners.fireChange("code", null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BaseTextEditor.this.changeListeners.fireChange("code", null);
            }
        });
        this.add((Component)this.editorText.asJComponent(), "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String mimeType, String text) {
        boolean enabled = this.changeListeners.setEnabled(false);
        try {
            this.editorText.setContentType(mimeType);
            this.editorText.setText(text);
            this.editorText.discardAllEdits();
        }
        finally {
            this.changeListeners.setEnabled(enabled);
        }
    }

    public String getText() {
        return this.editorText.getText();
    }

    public JTextComponent getJTextComponent() {
        return this.editorText.getJTextComponent();
    }

    public void selectLine(int line) {
        JTextComponent editor = this.getJTextComponent();
        editor.requestFocusInWindow();
        String code = editor.getText();
        int lineCounter = 0;
        int initialSelection = 0;
        int finalSelection = 0;
        for (int j = 0; j < code.length(); ++j) {
            if (code.charAt(j) != '\n') continue;
            if (++lineCounter == line - 1) {
                initialSelection = j;
            }
            if (lineCounter != line && (finalSelection != 0 || j != code.length() - 1)) continue;
            finalSelection = j;
        }
        editor.select(initialSelection, finalSelection);
    }

    public SyntaxtHighlightTextComponent getSyntaxtHighlightTextComponent() {
        return this.editorText;
    }

    public void gotoline(int line) {
        this.getSyntaxtHighlightTextComponent().gotoline(line);
    }

    public int getLineCount() {
        JTextComponent textComponent = this.getJTextComponent();
        if (textComponent instanceof RSyntaxTextArea) {
            return ((RSyntaxTextArea)textComponent).getLineCount();
        }
        return 0;
    }

    public void setEditable(boolean editable) {
        this.editorText.setEditable(editable);
    }

    public boolean isEditable() {
        return this.editorText.isEditable();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.editorText.addFocusListener(l);
    }
}

