/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.gvsig.scripting.ScriptingText;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.impl.composer.editors.TextEditor;

public class PropertiesEditor
extends TextEditor {
    private static final long serialVersionUID = -1201748764869858488L;

    public PropertiesEditor(ScriptingText unit) {
        super(unit);
    }

    @Override
    public ScriptingText getUnit() {
        return super.getUnit();
    }

    @Override
    public void set(ScriptingUnit unit) {
        super.set(unit);
        Properties props = new Properties();
        File f = this.getUnit().getFile();
        try (FileInputStream fis = new FileInputStream(f);){
            props.load(fis);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't load properties file.", ex);
        }
        StringBuilder builder = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(names);
        for (String name : names) {
            String value = props.getProperty(name);
            builder.append(name).append("=").append(value).append("\n");
        }
        this.getTextEditor().setText(this.getUnit().getMimeType(), builder.toString());
    }

    @Override
    public void save() {
        String text = this.getTextEditor().getText();
        String[] lines = text.split("\n");
        Properties props = new Properties();
        String comments = "";
        for (String line : lines) {
            if ((line = line.trim()).startsWith("#")) {
                comments = comments + line.substring(1) + " ";
                continue;
            }
            if (!line.contains("=")) continue;
            String[] parts = line.split("=");
            props.setProperty(parts[0].trim(), parts[1]);
        }
        File f = this.getUnit().getFile();
        try (FileOutputStream fout = new FileOutputStream(f);){
            props.store(fout, comments);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't save properties file.", ex);
        }
        this.setModified(false);
    }
}

