/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.syntaxhighlight.styles;

import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class PythonStyledDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 2859530660266127826L;
    private static int TABSIZE = 4;
    private final DefaultStyledDocument doc = this;
    private final Element rootElement = this.doc.getDefaultRootElement();
    private boolean multiLineComment;
    private final MutableAttributeSet normal;
    private final MutableAttributeSet keyword1;
    private final MutableAttributeSet keyword2;
    private final MutableAttributeSet keyword3;
    private final MutableAttributeSet keyword4;
    private final MutableAttributeSet builtin;
    private final MutableAttributeSet comment;
    private final MutableAttributeSet quote;
    private final MutableAttributeSet identifiers;
    private final Set<String> keywords1;
    private final Set<String> keywords2;
    private final Set<String> keywords3;
    private final Set<String> keywords4;
    private final Set<String> builtins;
    private int columnNumber;

    public PythonStyledDocument() {
        this.putProperty("__EndOfLine__", "\n");
        int fontSize = 14;
        this.normal = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normal, Color.BLACK);
        StyleConstants.setFontFamily(this.normal, "monospaced");
        StyleConstants.setBold(this.normal, true);
        StyleConstants.setFontSize(this.normal, fontSize);
        this.comment = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment, Color.GRAY);
        StyleConstants.setItalic(this.comment, true);
        StyleConstants.setBold(this.comment, true);
        StyleConstants.setFontFamily(this.comment, "monospaced");
        StyleConstants.setFontSize(this.comment, fontSize);
        this.keyword1 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword1, Color.BLACK);
        StyleConstants.setFontFamily(this.keyword1, "monospaced");
        StyleConstants.setBold(this.keyword1, true);
        StyleConstants.setFontSize(this.keyword1, fontSize);
        this.keyword2 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword2, Color.CYAN);
        StyleConstants.setFontFamily(this.keyword2, "monospaced");
        StyleConstants.setBold(this.keyword2, false);
        StyleConstants.setFontSize(this.keyword2, fontSize);
        this.keyword3 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword3, Color.GREEN.darker());
        StyleConstants.setFontFamily(this.keyword3, "monospaced");
        StyleConstants.setBold(this.keyword3, false);
        StyleConstants.setFontSize(this.keyword3, fontSize);
        this.keyword4 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword4, Color.BLUE.darker());
        StyleConstants.setFontFamily(this.keyword4, "monospaced");
        StyleConstants.setBold(this.keyword4, true);
        StyleConstants.setFontSize(this.keyword4, fontSize);
        this.builtin = new SimpleAttributeSet();
        StyleConstants.setForeground(this.builtin, Color.RED.darker());
        StyleConstants.setFontFamily(this.builtin, "monospaced");
        StyleConstants.setBold(this.builtin, false);
        StyleConstants.setFontSize(this.builtin, fontSize);
        this.identifiers = new SimpleAttributeSet();
        StyleConstants.setForeground(this.identifiers, Color.BLACK);
        StyleConstants.setFontFamily(this.identifiers, "monospaced");
        StyleConstants.setBold(this.identifiers, false);
        StyleConstants.setFontSize(this.identifiers, fontSize);
        this.quote = new SimpleAttributeSet();
        StyleConstants.setForeground(this.quote, Color.RED.darker());
        StyleConstants.setFontFamily(this.quote, "monospaced");
        StyleConstants.setBold(this.quote, true);
        StyleConstants.setFontSize(this.quote, fontSize);
        this.keywords1 = new HashSet<String>();
        this.keywords1.add("except");
        this.keywords1.add("class");
        this.keywords1.add("continue");
        this.keywords1.add("else");
        this.keywords1.add("finally");
        this.keywords1.add("if");
        this.keywords1.add("elif");
        this.keywords1.add("in");
        this.keywords1.add("return");
        this.keywords1.add("raise");
        this.keywords1.add("try");
        this.keywords1.add("while");
        this.keywords1.add("def");
        this.keywords1.add("print");
        this.keywords1.add("globals");
        this.keywords1.add("for");
        this.keywords1.add("pass");
        this.keywords2 = new HashSet<String>();
        this.keywords2.add("from");
        this.keywords2.add("import");
        this.keywords3 = new HashSet<String>();
        this.keywords3.add("True");
        this.keywords3.add("False");
        this.keywords3.add("None");
        this.keywords3.add("self");
        this.keywords4 = new HashSet<String>();
        this.keywords4.add("__init__");
        this.keywords4.add("__len__");
        this.keywords4.add("__str__");
        this.keywords4.add("__repr__");
        this.keywords4.add("__call__");
        this.keywords4.add("__iter__");
        this.keywords4.add("__class__");
        this.keywords4.add("__getattr__");
        this.keywords4.add("__setattr__");
        this.keywords4.add("__delattr__");
        this.keywords4.add("__getitem__");
        this.keywords4.add("__setitem__");
        this.keywords4.add("__delitem__");
        this.keywords4.add("__getslice__");
        this.keywords4.add("__setslice__");
        this.keywords4.add("__delslice__");
        this.keywords4.add("__getattribute__");
        this.keywords4.add("__setattribute__");
        this.keywords4.add("__contains__");
        this.keywords4.add("__reduce__");
        this.keywords4.add("__cmp__");
        this.keywords4.add("__eq__");
        this.keywords4.add("__ne__");
        this.keywords4.add("__lt__");
        this.keywords4.add("__le__");
        this.keywords4.add("__gt__");
        this.keywords4.add("__ge__");
        this.keywords4.add("__mul__");
        this.keywords4.add("__imul__");
        this.keywords4.add("__rmul__");
        this.keywords4.add("__add__");
        this.keywords4.add("__iadd__");
        this.keywords4.add("__radd__");
        this.keywords4.add("__mod__");
        this.keywords4.add("__rmod__");
        this.builtins = new HashSet<String>();
        this.builtins.add("int");
        this.builtins.add("unicode");
        this.builtins.add("str");
        this.builtins.add("float");
        this.builtins.add("long");
        this.builtins.add("list");
        this.builtins.add("tuple");
        this.builtins.add("dict");
        this.builtins.add("iter");
        this.builtins.add("vars");
        this.builtins.add("isinstance");
        this.builtins.add("dir");
        this.builtins.add("repr");
        this.builtins.add("reduce");
        this.builtins.add("zip");
        this.builtins.add("chr");
        this.builtins.add("hex");
        this.builtins.add("id");
        this.builtins.add("max");
        this.builtins.add("min");
        this.builtins.add("oct");
        this.builtins.add("pow");
        this.builtins.add("ord");
        this.builtins.add("unichr");
        this.builtins.add("range");
        this.builtins.add("xrange");
        this.builtins.add("abs");
        this.builtins.add("len");
        this.builtins.add("apply");
        this.builtins.add("open");
        this.builtins.add("getattr");
        this.builtins.add("setattr");
        this.builtins.add("hasattr");
    }

    public Iterator<String> keywords() {
        return new DelegatedIterator<String>(new Iterator[]{this.keywords1.iterator(), this.keywords2.iterator(), this.keywords3.iterator(), this.keywords4.iterator(), this.builtins.iterator()});
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, this.processTab(offset, str, a), a);
        this.processChangedLines(offset, str.length());
    }

    public void setPosition(int lineNumber, int columnNumber) {
        this.columnNumber = columnNumber;
    }

    private String processTab(int offset, String str, AttributeSet a) {
        if (!"\t".equals(str)) {
            return str;
        }
        try {
            int numberOfSpacesToInsert = TABSIZE - (this.columnNumber - 1) % TABSIZE;
            str = "                                                   ".substring(0, numberOfSpacesToInsert);
        }
        catch (Exception e) {
            return "                    ".substring(0, TABSIZE);
        }
        return str;
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this.comment, false);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, this.comment, false);
        }
    }

    private void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.rootElement.getElement(i);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(this.comment)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this.comment, false);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, this.comment, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this.quote, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        if (this.isKeyword(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword1, false);
        } else if (this.keywords2.contains(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword2, false);
        } else if (this.keywords3.contains(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword3, false);
        } else if (this.keywords4.contains(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword4, false);
        } else if (this.isBuiltin(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.builtin, false);
        } else if (this.isIdentifier(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.identifiers, false);
        }
        return endOfToken + 1;
    }

    private boolean isIdentifier(String token) {
        return token.matches("[A-Za-z_][A-Za-z0-9_]*");
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        String operands = ";:()[]+-/%<=>!&|^~*.,";
        return Character.isWhitespace(character.charAt(0)) || operands.indexOf(character) != -1;
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return quoteDelimiters.indexOf(character) >= 0;
    }

    protected boolean isKeyword(String token) {
        return this.keywords1.contains(token);
    }

    protected boolean isBuiltin(String token) {
        return this.builtins.contains(token);
    }

    protected String getStartDelimiter() {
        return "\"\"\"";
    }

    protected String getEndDelimiter() {
        return "\"\"\"";
    }

    protected String getSingleLineDelimiter() {
        return "#";
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    private static class DelegatedIterator<T>
    implements Iterator<T> {
        private final Iterator<T>[] iterators;
        private int cur;

        private DelegatedIterator(Iterator<T>[] iterators) {
            this.iterators = iterators;
            this.cur = 0;
        }

        @Override
        public boolean hasNext() {
            while (this.iterators.length < this.cur) {
                boolean x = this.iterators[this.cur].hasNext();
                if (x) {
                    return true;
                }
                ++this.cur;
            }
            return false;
        }

        @Override
        public T next() {
            return this.iterators[this.cur].next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

