/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.JScriptingBrowser;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.impl.DefaultJScriptingBrowser;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.script.ScriptSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class DefaultScriptChooserPanel
extends JPanel
implements ScriptSwingManager.ScriptChooserPanel {
    private final ScriptingUIManager uimanager;
    private JTabbedPane pestana;
    private int action;

    public DefaultScriptChooserPanel(ScriptingUIManager uimanager) {
        this.uimanager = uimanager;
        this.action = 2;
    }

    private void initComponents() {
        if (this.pestana != null) {
            return;
        }
        ScriptingManager manager = this.uimanager.getManager();
        ArrayList<ScriptingFolder> folders = new ArrayList<ScriptingFolder>();
        folders.add(manager.getUserFolder());
        folders.addAll(manager.getAlternativeUserFolders());
        folders.add(manager.getSystemFolder());
        this.pestana = new JTabbedPane();
        for (ScriptingFolder folder : folders) {
            DefaultJScriptingBrowser browser = new DefaultJScriptingBrowser(this.uimanager, folder);
            this.pestana.addTab(this.uimanager.getTranslation(folder.getName()), browser);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.pestana, "Center");
        this.setPreferredSize(new Dimension(260, 300));
    }

    public int showDialog() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winManager.createDialog(this.asJComponent(), i18n.getTranslation("_Select_a_script"), null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        this.action = dialog.getAction();
        return this.action;
    }

    public Script getScript() {
        if (this.action != 1) {
            return null;
        }
        JScriptingBrowser browser = (JScriptingBrowser)this.pestana.getSelectedComponent();
        if (browser == null) {
            return null;
        }
        ScriptingUnit x = browser.getSelectedNode();
        if (x instanceof Script) {
            return (Script)x;
        }
        return null;
    }

    public int getAction() {
        return this.action;
    }

    public JComponent asJComponent() {
        this.initComponents();
        return this;
    }
}

