/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.script.ScriptSwingManager;

public class ScriptListPickerController
extends AbstractPickerController<List<Script>> {
    private List<Script> scripts = new ArrayList<Script>();
    private final ListComponent list;
    private final JButton btnRemove;
    private final JButton btnChooser;

    public ScriptListPickerController(JComboBox combo, JButton remove, JButton chooser) {
        this.list = new ListComponent(combo);
        this.btnChooser = chooser;
        this.btnRemove = remove;
        this.initComponents();
    }

    public ScriptListPickerController(JList list, JButton remove, JButton chooser) {
        this.list = new ListComponent(list);
        this.btnChooser = chooser;
        this.btnRemove = remove;
        this.initComponents();
    }

    private void initComponents() {
        this.list.setEnabled(true);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setIcon(this.getIcon("picker-script-remove"));
        this.btnRemove.setText("");
        this.btnChooser.setEnabled(true);
        this.btnChooser.setIcon(this.getIcon("picker-script"));
        this.btnChooser.setText("");
        this.btnChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptListPickerController.this.doChooseScript();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptListPickerController.this.doRemoveScript();
            }
        });
        this.list.addSelectionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptListPickerController.this.doSelectionChanged();
            }
        });
        this.list.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ((e.getModifiers() & 2) == 2) {
                    ScriptListPickerController.this.doMoveCurrentScript(e.getKeyCode());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiers() & 2) == 2) {
                    ScriptListPickerController.this.doMoveCurrentScript(e.getKeyCode());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void doMoveCurrentScript(int keyCode) {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (keyCode == 38) {
            if (n < 1) {
                return;
            }
            Script sc = this.scripts.get(n);
            this.scripts.remove(n);
            this.scripts.add(n - 1, sc);
            this.list.setSelectedIndex(n - 1);
            this.rebuildList();
            return;
        }
        if (keyCode == 40) {
            if (n >= this.scripts.size() - 1) {
                return;
            }
            Script sc = this.scripts.get(n);
            this.scripts.remove(n);
            this.scripts.add(n + 1, sc);
            this.list.setSelectedIndex(n + 1);
            this.rebuildList();
        }
    }

    private void doSelectionChanged() {
        if (this.list.getSelectedIndex() >= 0) {
            this.btnRemove.setEnabled(true);
        } else {
            this.btnRemove.setEnabled(false);
        }
    }

    private void doChooseScript() {
        Script theScript;
        ScriptingUIManager manager = ScriptingSwingLocator.getUIManager();
        ScriptSwingManager.ScriptChooserPanel chooser = manager.createScriptChooserPanel();
        chooser.showDialog();
        if (chooser.getAction() == 1 && (theScript = chooser.getScript()) != null) {
            this.add(theScript);
            this.fireChangeEvent();
        }
    }

    private void doRemoveScript() {
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.scripts.remove(index);
        this.rebuildList();
    }

    private void add(Script script) {
        this.scripts.add(script);
        this.rebuildList();
    }

    public List<Script> get() {
        return this.scripts;
    }

    public void set(List<Script> value) {
        this.scripts = value;
        this.rebuildList();
    }

    public void coerceAndSet(Object value) {
        if (value instanceof List) {
            this.set((List)value);
            return;
        }
        String s = "null";
        if (value != null) {
            s = value.getClass().getName();
        }
        throw new IllegalArgumentException("Can't coerce '" + s + "' to List of scripts.");
    }

    public void setEnabled(boolean enabled) {
        this.btnChooser.setEnabled(enabled ? this.isEditable() : false);
        this.list.setEnabled(enabled);
        if (enabled) {
            if (this.list.getSelectedIndex() >= 0) {
                this.btnRemove.setEnabled(this.isEditable());
            } else {
                this.btnRemove.setEnabled(false);
            }
        } else {
            this.btnRemove.setEnabled(false);
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.btnChooser.setEnabled(editable);
        this.btnRemove.setEnabled(editable);
    }

    public boolean isEnabled() {
        return this.btnChooser.isEnabled();
    }

    private void rebuildList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = ScriptListPickerController.this.list.getSelectedIndex();
                ScriptListPickerController.this.list.clearElements();
                if (ScriptListPickerController.this.scripts != null) {
                    for (Script script : ScriptListPickerController.this.scripts) {
                        String label = script instanceof ScriptingUnit ? ((ScriptingUnit)script).getUserPath() : script.getName();
                        ScriptListPickerController.this.list.addElement(new ListElement(label, (Object)script));
                    }
                }
                if (n >= 0 && n < ScriptListPickerController.this.scripts.size()) {
                    ScriptListPickerController.this.btnRemove.setEnabled(true);
                    ScriptListPickerController.this.list.setSelectedIndex(n);
                } else {
                    ScriptListPickerController.this.btnRemove.setEnabled(false);
                }
            }
        });
    }

    private class ListComponent {
        private final JComboBox combo;
        private final JList list;

        public ListComponent(JComboBox combo) {
            this.list = null;
            this.combo = combo;
        }

        public ListComponent(JList list) {
            this.list = list;
            this.combo = null;
        }

        public void setEnabled(boolean b) {
            if (this.list == null) {
                this.combo.setEnabled(b);
            } else {
                this.list.setEnabled(b);
            }
        }

        public int getSelectedIndex() {
            if (this.list == null) {
                return this.combo.getSelectedIndex();
            }
            return this.list.getSelectedIndex();
        }

        public void clearElements() {
            if (this.list == null) {
                this.combo.setModel(new DefaultComboBoxModel());
            } else {
                this.list.setModel(new DefaultListModel());
            }
        }

        public void addElement(ListElement element) {
            if (this.list == null) {
                this.combo.addItem(element);
            } else {
                ((DefaultListModel)this.list.getModel()).addElement(element);
            }
        }

        public void addSelectionListener(final ActionListener listener) {
            if (this.combo != null) {
                this.combo.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        ActionEvent event = new ActionEvent(this, 1, "ItemChanged");
                        listener.actionPerformed(event);
                    }
                });
            }
            if (this.list != null) {
                this.list.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        ActionEvent event = new ActionEvent(this, 1, "ItemChanged");
                        listener.actionPerformed(event);
                    }
                });
            }
        }

        public void addKeyListener(KeyListener listener) {
            if (this.list != null) {
                this.list.addKeyListener(listener);
            }
        }

        private void setSelectedIndex(int n) {
            if (this.list == null) {
                this.combo.setSelectedIndex(n);
            } else {
                this.list.setSelectedIndex(n);
            }
        }
    }
}

