/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.i18n.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gvsig.andami.LocaleManager;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.i18n.I18nException;
import org.gvsig.i18n.I18nManager;
import org.gvsig.i18n.Messages;
import org.gvsig.i18n.impl.ExportLocaleException;
import org.gvsig.i18n.impl.InstallLocalesException;
import org.gvsig.i18n.impl.LocaleFileNameRequiredException;
import org.gvsig.i18n.impl.LocaleLanguageRequiredException;
import org.gvsig.i18n.impl.ReadCSVLocalesFileException;
import org.gvsig.i18n.impl.UninstallLocaleException;
import org.gvsig.utils.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nManagerImpl
implements I18nManager {
    private static final Logger logger = LoggerFactory.getLogger(I18nManagerImpl.class);
    private static final String LOCALES_FILE_NAME = "locales.csv";
    private static final String CSV_SEPARATOR = ",";
    private static final I18nManager DEFAULT = new I18nManagerImpl();
    private Locale[] referenceLocales = new Locale[]{ENGLISH, SPANISH};
    LocaleManager localeManager = null;

    private LocaleManager getLocaleManager() {
        if (this.localeManager == null) {
            this.localeManager = PluginsLocator.getLocaleManager();
        }
        return this.localeManager;
    }

    public static I18nManager getInstance() {
        return DEFAULT;
    }

    public static String capitalize(String text) {
        String capitalLetter = new String(new char[]{Character.toUpperCase(text.charAt(0))});
        return capitalLetter.concat(text.substring(1));
    }

    private Set<Locale> getRegisteredLocales() {
        return this.getLocaleManager().getInstalledLocales();
    }

    @Override
    public Locale getCurrentLocale() {
        return this.getLocaleManager().getCurrentLocale();
    }

    @Override
    public Locale[] getInstalledLocales() {
        Set<Locale> locales = this.getRegisteredLocales();
        return locales.toArray(new Locale[locales.size()]);
    }

    private File getResourcesFolder() {
        return this.getLocaleManager().getResourcesFolder();
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        this.getLocaleManager().setCurrentLocale(locale);
    }

    @Override
    public Locale getDefaultSystemLocale() {
        return this.getLocaleManager().getDefaultSystemLocale();
    }

    @Override
    public void installLocale(Locale locale) {
        this.getLocaleManager().uninstallLocale(locale);
    }

    @Override
    public void uninstallLocale(Locale locale) throws I18nException {
        File bundleFile;
        if (this.getCurrentLocale().equals(locale) || this.isReferenceLocale(locale)) {
            throw new UninstallLocaleException(locale);
        }
        if (this.getLocaleManager().uninstallLocale(locale) && (bundleFile = new File(this.getResourcesFolder(), this.getResourceFileName(locale))).exists()) {
            bundleFile.delete();
        }
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, locale);
    }

    @Override
    public String getDisplayName(Locale locale, Locale displayLocale) {
        StringBuffer name = new StringBuffer(this.getLanguageDisplayName(locale, displayLocale));
        if (!this.isEmpty(locale.getCountry())) {
            name.append(" - ");
            name.append(locale.getDisplayCountry(displayLocale));
        }
        if (!this.isEmpty(locale.getVariant())) {
            name.append(" - ");
            name.append(locale.getDisplayVariant(displayLocale));
        }
        name.append(" (").append(locale.toString()).append(")");
        return name.toString();
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().length() == 0;
    }

    @Override
    public String getLanguageDisplayName(Locale locale) {
        return this.getLocaleManager().getLanguageDisplayName(locale);
    }

    @Override
    public String getLanguageDisplayName(Locale locale, Locale displayLocale) {
        return this.getLocaleManager().getLanguageDisplayName(locale);
    }

    @Override
    public Locale[] installLocales(File importFile) throws I18nException {
        ArrayList<Locale> importLocales = new ArrayList<Locale>();
        try {
            ZipFile zipFile = new ZipFile(importFile);
            Map locales = this.getZipFileNonReferenceLocales(zipFile);
            if (locales == null || locales.size() == 0) {
                return null;
            }
            for (Map.Entry entry : locales.entrySet()) {
                String line;
                String fileName = (String)entry.getKey();
                Locale locale = (Locale)entry.getValue();
                importLocales.add(locale);
                this.getLocaleManager().installLocale(locale);
                ZipEntry zipEntry = zipFile.getEntry(fileName);
                InputStream is = zipFile.getInputStream(zipEntry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                File bundleFile = this.getResourceFile(locale);
                FileWriter fileWriter = new FileWriter(bundleFile);
                BufferedWriter writer = new BufferedWriter(fileWriter);
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.write(10);
                }
                writer.flush();
                writer.close();
                fileWriter.close();
                reader.close();
                is.close();
            }
        }
        catch (Exception ex) {
            throw new InstallLocalesException(importFile, (Throwable)ex);
        }
        return importLocales.toArray(new Locale[importLocales.size()]);
    }

    @Override
    public void exportLocaleForUpdate(Locale locale, Locale referenceLocale, File exportFile) throws I18nException {
        this.exportLocalesForUpdate(new Locale[]{locale}, referenceLocale, exportFile);
    }

    @Override
    public void exportLocalesForUpdate(Locale[] locales, Locale referenceLocale, File exportFile) throws I18nException {
        this.exportLocale(locales, new Locale[]{referenceLocale}, exportFile, true);
    }

    @Override
    public void exportLocaleForTranslation(Locale locale, Locale referenceLocale, File exportFile) throws I18nException {
        this.exportLocaleForTranslation(locale, new Locale[]{referenceLocale}, exportFile);
    }

    @Override
    public void exportLocaleForTranslation(Locale locale, Locale[] referenceLocales, File exportFile) throws I18nException {
        this.exportLocale(new Locale[]{locale}, referenceLocales, exportFile, false);
    }

    @Override
    public Locale[] getReferenceLocales() {
        return this.referenceLocales;
    }

    @Override
    public void setReferenceLocales(Locale[] referenceLocales) {
        this.referenceLocales = referenceLocales;
    }

    @Override
    public void setDefaultLocales(Locale[] defaultLocales) {
        logger.warn("This operation (setDefaultLocales) is not supported.");
    }

    private void exportLocale(Locale[] locales, Locale[] referenceLocales, File exportFile, boolean update) throws I18nException {
        Locale[] refArray = this.getReferenceLocalesToExport(locales, referenceLocales);
        HashSet allReferenceKeys = new HashSet();
        HashMap<Locale, Map> referenceTexts = new HashMap<Locale, Map>(refArray.length);
        for (int i = 0; i < refArray.length; ++i) {
            Map texts = this.getAllTexts(refArray[i]);
            referenceTexts.put(refArray[i], texts);
            allReferenceKeys.addAll(texts.keySet());
        }
        try {
            int i;
            FileOutputStream fos = new FileOutputStream(exportFile);
            ZipOutputStream zipos = new ZipOutputStream(fos);
            this.writeZipFileLocales(zipos, locales, refArray);
            PrintStream ps = new PrintStream(zipos);
            Map texts = null;
            if (update) {
                if (locales != null) {
                    for (i = 0; i < locales.length; ++i) {
                        texts = this.getAllTexts(locales[i]);
                        this.addPendingKeys(texts, allReferenceKeys);
                        this.putResourceInZip(zipos, ps, texts, this.getResourceFileName(locales[i]));
                    }
                }
            } else if (locales != null) {
                for (i = 0; i < locales.length; ++i) {
                    this.putResourceInZip(zipos, ps, allReferenceKeys, this.getResourceFileName(locales[i]));
                }
            }
            if (refArray != null) {
                for (i = 0; i < refArray.length; ++i) {
                    texts = this.getAllTexts(refArray[i]);
                    this.putResourceInZip(zipos, ps, texts, this.getResourceFileName(refArray[i]));
                }
            }
            ps.flush();
            ps.close();
            zipos.close();
            fos.close();
        }
        catch (IOException ex) {
            throw new ExportLocaleException(locales, (Throwable)ex);
        }
    }

    private void addPendingKeys(Map texts, Set allReferenceKeys) {
        for (Object key : allReferenceKeys) {
            if (texts.containsKey(key)) continue;
            texts.put(key, "");
        }
    }

    private Locale[] getReferenceLocalesToExport(Locale[] locales, Locale[] referenceLocalesSelected) {
        int i;
        HashSet<Locale> exportRefLocales = new HashSet<Locale>(this.referenceLocales.length);
        for (i = 0; i < this.referenceLocales.length; ++i) {
            exportRefLocales.add(this.referenceLocales[i]);
        }
        if (referenceLocalesSelected != null) {
            for (i = 0; i < referenceLocalesSelected.length; ++i) {
                exportRefLocales.add(referenceLocalesSelected[i]);
            }
        }
        if (locales != null) {
            for (i = 0; i < locales.length; ++i) {
                exportRefLocales.remove(locales[i]);
            }
        }
        Locale[] refArray = exportRefLocales.toArray(new Locale[exportRefLocales.size()]);
        return refArray;
    }

    private Map getAllTexts(Locale locale) {
        return Messages.getAllTexts((Locale)locale);
    }

    private Map getZipFileNonReferenceLocales(ZipFile zipFile) throws I18nException {
        HashMap<String, Locale> locales;
        ZipEntry zipEntry = zipFile.getEntry(LOCALES_FILE_NAME);
        if (zipEntry == null) {
            return null;
        }
        try {
            String line;
            InputStream is = zipFile.getInputStream(zipEntry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            locales = new HashMap<String, Locale>(2);
            while ((line = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, CSV_SEPARATOR, true);
                String fileName = st.nextToken();
                if (CSV_SEPARATOR.equals(fileName)) {
                    throw new LocaleFileNameRequiredException(line);
                }
                st.nextToken();
                String language = st.nextToken();
                if (CSV_SEPARATOR.equals(language)) {
                    throw new LocaleLanguageRequiredException(line);
                }
                st.nextToken();
                String country = st.nextToken();
                if (CSV_SEPARATOR.equals(country)) {
                    country = null;
                } else {
                    st.nextToken();
                }
                String variant = st.nextToken();
                if (CSV_SEPARATOR.equals(variant)) {
                    variant = null;
                } else {
                    st.nextToken();
                }
                String refStr = st.nextToken();
                if (CSV_SEPARATOR.equals(refStr)) {
                    refStr = null;
                }
                if (refStr == null || "true".equals(refStr.toLowerCase())) continue;
                if (country == null) {
                    variant = null;
                }
                country = country == null ? "" : country;
                variant = variant == null ? "" : variant;
                Locale locale = new Locale(language, country, variant);
                locales.put(fileName, locale);
            }
            reader.close();
            is.close();
        }
        catch (IOException ex) {
            throw new ReadCSVLocalesFileException(ex);
        }
        return locales;
    }

    private void writeZipFileLocales(ZipOutputStream zos, Locale[] locales, Locale[] referenceLocales) throws IOException {
        int i;
        ZipEntry zipEntry = new ZipEntry(LOCALES_FILE_NAME);
        zos.putNextEntry(zipEntry);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zos));
        if (locales != null) {
            for (i = 0; i < locales.length; ++i) {
                this.writeLocaleEntry(locales[i], writer, false);
            }
        }
        if (referenceLocales != null) {
            for (i = 0; i < referenceLocales.length; ++i) {
                this.writeLocaleEntry(referenceLocales[i], writer, true);
            }
        }
        writer.flush();
        zos.closeEntry();
    }

    private void writeLocaleEntry(Locale locale, BufferedWriter writer, boolean reference) throws IOException {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        country = country == null ? "" : country;
        String variant = locale.getVariant();
        variant = variant == null ? "" : variant;
        writer.write(this.getResourceFileName(locale));
        writer.write(44);
        writer.write(language);
        writer.write(44);
        writer.write(country);
        writer.write(44);
        writer.write(variant);
        writer.write(44);
        writer.write(Boolean.toString(reference));
        writer.write(10);
    }

    private boolean isReferenceLocale(Locale locale) {
        for (int i = 0; i < this.referenceLocales.length; ++i) {
            if (!this.referenceLocales[i].equals(locale)) continue;
            return true;
        }
        return false;
    }

    private void putResourceInZip(ZipOutputStream zipos, PrintStream ps, Map texts, String resourceFileName) throws IOException {
        zipos.putNextEntry(new ZipEntry(resourceFileName));
        for (Map.Entry entry : texts.entrySet()) {
            String keyEncoded = this.escape((String)entry.getKey(), true);
            ps.print(keyEncoded);
            ps.print("=");
            String valueEncoded = this.escape((String)entry.getValue(), false);
            ps.println(valueEncoded);
        }
        ps.flush();
        zipos.closeEntry();
    }

    private void putResourceInZip(ZipOutputStream zipos, PrintStream ps, Set keys, String resourceFileName) throws IOException {
        zipos.putNextEntry(new ZipEntry(resourceFileName));
        for (String value : keys) {
            String keyEncoded = this.escape(value, true);
            ps.print(keyEncoded);
            ps.print("=");
            ps.println();
        }
        ps.flush();
        zipos.closeEntry();
    }

    private File getResourceFile(Locale locale) {
        return new File(this.getResourcesFolder(), this.getResourceFileName(locale));
    }

    private String getResourceFileName(Locale locale) {
        StringBuffer fileName = new StringBuffer("text");
        if (!this.isEmpty(locale.getCountry()) || !"es".equals(locale.getLanguage())) {
            fileName.append('_').append(locale.getLanguage());
        }
        if (!this.isEmpty(locale.getCountry())) {
            fileName.append('_').append(locale.getCountry());
        }
        if (!this.isEmpty(locale.getVariant())) {
            fileName.append('_').append(locale.getVariant());
        }
        fileName.append(".properties");
        return fileName.toString();
    }

    private String escape(String value, boolean replaceBlanks) {
        if (replaceBlanks) {
            value = StringUtilities.replace((String)value, (String)" ", (String)"\\ ");
        }
        value = StringUtilities.replace((String)value, (String)":", (String)"\\:");
        value = StringUtilities.replace((String)value, (String)"\n", (String)"\\n");
        value = StringUtilities.replace((String)value, (String)"\t", (String)"\\t");
        value = StringUtilities.replace((String)value, (String)"\b", (String)"\\b");
        value = StringUtilities.replace((String)value, (String)"\f", (String)"\\f");
        value = StringUtilities.replace((String)value, (String)"\r", (String)"\\r");
        return this.toRawUnicodeEncoded(value);
    }

    private String toRawUnicodeEncoded(String value) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '\u0080') {
                sb.append(c);
                continue;
            }
            sb.append("\\u");
            String hexValue = Integer.toHexString(c);
            for (int j = hexValue.length(); j < 4; ++j) {
                sb.append('0');
            }
            sb.append(hexValue);
        }
        return sb.toString();
    }
}

